/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Wololo, wololo wololo.
 */
@Singleton
@SuppressWarnings("all")
public class ModelTypingSpaceBuilder {
  @Inject
  private Injector injector;

  private Map<Language, LanguageBuilder> registry = CollectionLiterals.<Language, LanguageBuilder>newHashMap();

  /**
   * Creates and returns a builder to construct a model for {@code l}.
   * Always returns the same builder for a given language.
   */
  public LanguageBuilder getBuilder(final Language l) {
    LanguageBuilder res = this.registry.get(l);
    if ((res == null)) {
      LanguageBuilder _languageBuilder = new LanguageBuilder(l, this);
      res = _languageBuilder;
      this.injector.injectMembers(res);
      this.registry.put(l, res);
    }
    return res;
  }

  public void resetFor(final ModelTypingSpace root) {
    final Consumer<Language> _function = (Language it) -> {
      this.registry.remove(it);
    };
    Iterables.<Language>filter(root.getElements(), Language.class).forEach(_function);
  }

  /**
   * Return the builder corresponding to {@code l}, or null if it cannot be
   * retrieved.
   */
  public LanguageBuilder findBuilder(final Language l) {
    return this.registry.get(l);
  }
}
