/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.project.PDEProject;

public class SourceEntryErrorReporter
extends BuildErrorReporter {
    private static final String DEF_OUTPUT_ENTRY = "output..";
    private final HashMap<IPath, SourceFolder> fSourceFolderMap = new HashMap(4);
    private final HashMap<IPath, OutputFolder> fOutputFolderMap = new HashMap(4);
    private IBuild fBuild = null;
    Map<String, String> fDefaultLibraryEncodings = new HashMap<String, String>();
    Map<String, List<EncodingEntry>> fCustomEncodings = new HashMap<String, List<EncodingEntry>>();

    public SourceEntryErrorReporter(IFile file, IBuild model) {
        super(file);
        this.fBuild = model;
    }

    public void initialize(List<IBuildEntry> sourceEntries, List<IBuildEntry> outputEntries, IClasspathEntry[] cpes, IProject project) {
        IPath path;
        String token;
        String[] tokens;
        int n;
        this.fProject = project;
        IPath defaultOutputLocation = null;
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        try {
            defaultOutputLocation = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {}
        ArrayList<String> pluginLibraryNames = new ArrayList<String>(1);
        IPluginModelBase pluginModel = PluginRegistry.findModel(this.fProject);
        if (pluginModel != null) {
            IPluginLibrary[] pluginLibraries = pluginModel.getPluginBase().getLibraries();
            IPluginObject[] iPluginObjectArray = pluginLibraries;
            int n2 = pluginLibraries.length;
            n = 0;
            while (n < n2) {
                IPluginLibrary library = iPluginObjectArray[n];
                pluginLibraryNames.add(library.getName());
                ++n;
            }
            iPluginObjectArray = pluginModel.getPluginBase().getExtensions();
            n2 = iPluginObjectArray.length;
            n = 0;
            while (n < n2) {
                IPluginObject extension = iPluginObjectArray[n];
                if ("org.eclipse.ant.core.extraClasspathEntries".equals(extension.getPoint())) {
                    IPluginObject[] iPluginObjectArray2 = extension.getChildren();
                    int n3 = iPluginObjectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginAttribute library;
                        IPluginObject pluginObject = iPluginObjectArray2[n4];
                        if ("extraClasspathEntry".equals(pluginObject.getName()) && pluginObject instanceof IPluginElement && (library = ((IPluginElement)pluginObject).getAttribute("library")) != null) {
                            pluginLibraryNames.add(library.getValue().trim());
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (!pluginLibraryNames.contains(".")) {
            pluginLibraryNames.add(".");
        }
        IClasspathEntry[] iClasspathEntryArray = cpes;
        n = cpes.length;
        int n5 = 0;
        while (n5 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n5];
            if (entry.getEntryKind() == 3) {
                IPath sourcePath = this.getPath(entry);
                if (sourcePath != null) {
                    SourceFolder sourceFolder;
                    IPath outputPath;
                    OutputFolder outputFolder;
                    IPath outputLocation = entry.getOutputLocation();
                    if (outputLocation == null) {
                        outputLocation = defaultOutputLocation;
                    }
                    if ((outputFolder = this.fOutputFolderMap.get(outputPath = this.getPath(outputLocation))) == null) {
                        outputFolder = new OutputFolder(outputPath);
                    }
                    if ((sourceFolder = this.fSourceFolderMap.get(sourcePath)) == null) {
                        sourceFolder = new SourceFolder(sourcePath, outputFolder);
                    }
                    outputFolder.addSourceFolder(sourceFolder);
                    this.fOutputFolderMap.put(outputPath, outputFolder);
                    this.fSourceFolderMap.put(sourcePath, sourceFolder);
                }
            } else if (entry.getEntryKind() == 1) {
                IPackageFragmentRoot[] roots = javaProject.findPackageFragmentRoots(entry);
                IPath outputPath = null;
                if (roots.length == 1 && !roots[0].isArchive()) {
                    outputPath = this.getPath(entry);
                    OutputFolder outputFolder = new OutputFolder(outputPath, true);
                    this.fOutputFolderMap.put(outputPath, outputFolder);
                }
            }
            ++n5;
        }
        for (IBuildEntry sourceEntry : sourceEntries) {
            String libName = sourceEntry.getName().substring("source.".length());
            if (!pluginLibraryNames.contains(libName)) {
                this.prepareError(sourceEntry.getName(), null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName), 8197, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
            }
            String[] stringArray = tokens = sourceEntry.getTokens();
            int n6 = tokens.length;
            int n7 = 0;
            while (n7 < n6) {
                token = stringArray[n7];
                path = new Path(token).addTrailingSeparator();
                SourceFolder sourceFolder = this.fSourceFolderMap.get(path);
                if (sourceFolder == null) {
                    sourceFolder = new SourceFolder(path, null);
                    this.fSourceFolderMap.put(path, sourceFolder);
                }
                sourceFolder.setToken(token);
                sourceFolder.addLib(libName);
                ++n7;
            }
        }
        for (IBuildEntry outputEntry : outputEntries) {
            String libName = outputEntry.getName().substring("output.".length());
            if (!pluginLibraryNames.contains(libName)) {
                this.prepareError(outputEntry.getName(), null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName), 8197, this.fOututLibSeverity, "compilers.p.build.output.library", "");
            }
            String[] stringArray = tokens = outputEntry.getTokens();
            int n8 = tokens.length;
            int n9 = 0;
            while (n9 < n8) {
                OutputFolder outputFolder;
                token = stringArray[n9];
                path = new Path(token).addTrailingSeparator();
                if (path.segmentCount() == 1 && path.segment(0).equals(".")) {
                    path = Path.ROOT;
                }
                if ((outputFolder = this.fOutputFolderMap.get(path)) == null) {
                    outputFolder = new OutputFolder(path);
                    this.fOutputFolderMap.put(path, outputFolder);
                }
                outputFolder.setToken(token);
                outputFolder.addLib(libName);
                ++n9;
            }
        }
    }

    private IPath getPath(Object entry) {
        IPath path = null;
        if (entry instanceof IClasspathEntry) {
            IClasspathEntry cpes = (IClasspathEntry)entry;
            path = cpes.getPath();
        } else if (entry instanceof IPath) {
            path = (IPath)entry;
        }
        if (path != null && path.matchingFirstSegments(this.fProject.getFullPath()) > 0) {
            path = path.removeFirstSegments(1);
        }
        if (path != null) {
            return path.addTrailingSeparator();
        }
        return null;
    }

    public void validate() {
        IPath sourcePath;
        Object srcFolder;
        String message;
        for (Map.Entry<IPath, OutputFolder> entry : this.fOutputFolderMap.entrySet()) {
            IPath iPath = entry.getKey();
            Iterator outputFolder = entry.getValue();
            ArrayList<SourceFolder> sourceFolders = ((OutputFolder)((Object)outputFolder)).getSourceFolders();
            ArrayList<String> outputFolderLibs = new ArrayList<String>(((ProjectFolder)((Object)outputFolder)).getLibs());
            if (sourceFolders.isEmpty()) {
                IPluginModelBase model;
                if (!((OutputFolder)((Object)outputFolder)).isLibrary()) {
                    for (String libName : outputFolderLibs) {
                        String message2;
                        IResource folderEntry = this.fProject.findMember(iPath);
                        if (folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer)) {
                            String message22 = NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)iPath.toString());
                        } else {
                            message2 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidOutputFolder, (Object)iPath.toString());
                        }
                        this.prepareError("output." + libName, ((ProjectFolder)((Object)outputFolder)).getToken(), message2, 8197, this.fOututLibSeverity, "compilers.p.build.output.library", "");
                    }
                    continue;
                }
                if (!outputFolderLibs.isEmpty() || (model = PluginRegistry.findModel(this.fProject)) == null) continue;
                IPluginLibrary[] libs = model.getPluginBase().getLibraries();
                message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputLibForClassFolder, (Object)iPath.toString());
                if (libs.length > 0) {
                    this.prepareError("output.", null, message, 4135, this.fOututLibSeverity, "compilers.p.build.output.library", "");
                    continue;
                }
                this.prepareError(DEF_OUTPUT_ENTRY, iPath.toString(), message, 8195, this.fOututLibSeverity, "compilers.p.build.output.library", "");
                continue;
            }
            String srcFolderLibName = null;
            int i = 0;
            while (i < sourceFolders.size()) {
                SourceFolder sourceFolder = sourceFolders.get(i);
                ArrayList<String> srcFolderLibs = sourceFolder.getLibs();
                outputFolderLibs.removeAll(srcFolderLibs);
                switch (srcFolderLibs.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (srcFolderLibName == null) {
                            srcFolderLibName = srcFolderLibs.get(0);
                            break;
                        }
                        if (srcFolderLibName.equals(srcFolderLibs.get(0))) break;
                    }
                    default: {
                        String erringSrcFolders = this.join(sourceFolders.toArray(new SourceFolder[sourceFolders.size()]));
                        int j = 0;
                        while (j < sourceFolders.size()) {
                            srcFolder = sourceFolders.get(j);
                            int k = 0;
                            while (k < ((ProjectFolder)srcFolder).getLibs().size()) {
                                String libName = ((ProjectFolder)srcFolder).getLibs().get(k);
                                String message3 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DifferentTargetLibrary, (Object)erringSrcFolders);
                                this.prepareError("source." + libName, ((ProjectFolder)srcFolder).getToken(), message3, 4135, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
                                ++k;
                            }
                            ++j;
                        }
                        break block1;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < outputFolderLibs.size()) {
                message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_ExtraOutputFolder, (Object)((ProjectFolder)((Object)outputFolder)).getPath().toString(), (Object)("source." + outputFolderLibs.get(i)));
                this.prepareError("output." + outputFolderLibs.get(i), ((ProjectFolder)((Object)outputFolder)).getToken(), message, 8197, this.fOututLibSeverity, "compilers.p.build.output.library", "");
                ++i;
            }
            if (((ProjectFolder)((Object)outputFolder)).getDupeLibName() == null) continue;
            String message4 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeOutputFolder, (Object)iPath.toString(), (Object)("output." + ((ProjectFolder)((Object)outputFolder)).getDupeLibName()));
            this.prepareError("output." + ((ProjectFolder)((Object)outputFolder)).getDupeLibName(), ((ProjectFolder)((Object)outputFolder)).getToken(), message4, 4135, this.fOututLibSeverity, "compilers.p.build.output.library", "");
        }
        class MissingOutputEntry {
            private final List<String> fSrcFolders = new ArrayList<String>(1);
            private final List<String> fOutputFolders = new ArrayList<String>(1);

            MissingOutputEntry() {
            }

            public String getOutputList() {
                return this.generateList(this.fOutputFolders);
            }

            public String getSourceList() {
                return this.generateList(this.fSrcFolders);
            }

            private String generateList(List<String> strings) {
                StringBuilder buffer = new StringBuilder();
                Iterator<String> iterator = strings.iterator();
                while (iterator.hasNext()) {
                    String next = iterator.next();
                    buffer.append(next);
                    if (!iterator.hasNext()) continue;
                    buffer.append(',');
                    buffer.append(' ');
                }
                return buffer.toString();
            }

            public void addSrcFolder(String sourcePath) {
                if (!this.fSrcFolders.contains(sourcePath)) {
                    this.fSrcFolders.add(sourcePath);
                }
            }

            public void addOutputFolder(String outputPath) {
                if (!this.fOutputFolders.contains(outputPath)) {
                    this.fOutputFolders.add(outputPath);
                }
            }
        }
        HashMap<String, MissingOutputEntry> missingOutputEntryErrors = new HashMap<String, MissingOutputEntry>(4);
        ArrayList<SourceFolder> toValidate = new ArrayList<SourceFolder>();
        for (Map.Entry entry : this.fSourceFolderMap.entrySet()) {
            sourcePath = (IPath)entry.getKey();
            SourceFolder sourceFolder = (SourceFolder)entry.getValue();
            OutputFolder outputFolder = sourceFolder.getOutputLocation();
            if (outputFolder == null) {
                IResource folderEntry = this.fProject.findMember(sourcePath);
                message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)sourcePath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidSourceFolder, (Object)sourcePath.toString());
                ArrayList<String> srcLibs = sourceFolder.getLibs();
                int i = 0;
                while (i < srcLibs.size()) {
                    String libName = srcLibs.get(i);
                    this.prepareError("source." + libName, sourceFolder.getToken(), message, 8197, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
                    ++i;
                }
                continue;
            }
            if (outputFolder.getLibs().isEmpty() && sourceFolder.getLibs().size() == 1) {
                String libName = sourceFolder.getLibs().get(0);
                MissingOutputEntry errorEntry = (MissingOutputEntry)missingOutputEntryErrors.get(libName);
                if (errorEntry == null) {
                    errorEntry = new MissingOutputEntry();
                }
                errorEntry.addSrcFolder(sourcePath.toString());
                errorEntry.addOutputFolder(outputFolder.getToken());
                missingOutputEntryErrors.put(libName, errorEntry);
            }
            if (sourceFolder.getDupeLibName() != null) {
                String message5 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeSourceFolder, (Object)sourcePath.toString(), (Object)("source." + sourceFolder.getDupeLibName()));
                this.prepareError("source." + sourceFolder.getDupeLibName(), sourceFolder.getToken(), message5, 4135, this.fSrcLibSeverity, "compilers.p.build.source.library", "");
            }
            toValidate.add(sourceFolder);
        }
        for (Map.Entry entry : missingOutputEntryErrors.entrySet()) {
            String libName = (String)entry.getKey();
            MissingOutputEntry errorEntry = (MissingOutputEntry)entry.getValue();
            String message6 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputEntry, (Object)errorEntry.getSourceList(), (Object)("output." + libName));
            this.prepareError("output." + libName, errorEntry.getOutputList(), message6, 8195, this.fMissingOutputLibSeverity, "compilers.p.build.missing.output", "");
        }
        if (this.fEncodingSeverity == 0 || this.fEncodingSeverity == 1 || this.fEncodingSeverity == 3) {
            IBuildEntry[] entries;
            Object lib;
            for (SourceFolder sourceFolder : toValidate) {
                sourcePath = sourceFolder.getPath();
                IProject container = this.fProject;
                if (!sourcePath.isEmpty() && !sourcePath.isRoot()) {
                    container = container.getFolder(sourcePath);
                }
                try {
                    ArrayList<String> list = sourceFolder.getLibs();
                    String[] libs = list.toArray(new String[list.size()]);
                    String encoding = this.getExplicitEncoding((IContainer)container);
                    if (encoding != null) {
                        srcFolder = libs;
                        int libName = libs.length;
                        int i = 0;
                        while (i < libName) {
                            lib = srcFolder[i];
                            this.fDefaultLibraryEncodings.put((String)lib, encoding);
                            ++i;
                        }
                    }
                    container.accept((IResourceVisitor)new Visitor(sourceFolder));
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
            }
            IBuildEntry[] libs = entries = this.fBuild.getBuildEntries();
            int e = entries.length;
            int container = 0;
            while (container < e) {
                IBuildEntry entry = libs[container];
                String name = entry.getName();
                if (name.startsWith("javacDefaultEncoding.")) {
                    lib = name.substring("javacDefaultEncoding.".length());
                    String[] tokens = entry.getTokens();
                    if (tokens.length > 0) {
                        if (tokens.length == 1) {
                            String specified = tokens[0];
                            String expected = this.fDefaultLibraryEncodings.remove(lib);
                            if (expected != null) {
                                if (!specified.equals(expected)) {
                                    this.prepareError(name, expected, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_0, (Object[])new String[]{expected, specified, lib}), 8198, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                                }
                            } else {
                                this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_1, (Object[])new String[]{specified, lib}), 8197, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                            }
                        } else {
                            this.fDefaultLibraryEncodings.remove(lib);
                            this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_2, (Object)lib), 4135, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                        }
                    }
                } else if (name.startsWith("javacCustomEncodings.")) {
                    IContainer bundleRoot = PDEProject.getBundleRoot(this.fProject);
                    String lib2 = name.substring("javacCustomEncodings.".length());
                    String[] tokens = entry.getTokens();
                    if (tokens.length > 0) {
                        ArrayList<EncodingEntry> encodings = new ArrayList<EncodingEntry>();
                        String[] stringArray = tokens;
                        int message3 = tokens.length;
                        int libName = 0;
                        while (libName < message3) {
                            String special = stringArray[libName];
                            int index = special.indexOf(91);
                            if (index >= 0 && special.endsWith("]")) {
                                String path = special.substring(0, index);
                                String encoding = special.substring(index + 1, special.length() - 1);
                                IResource member = bundleRoot.findMember(path);
                                if (member == null) {
                                    String message7 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_3, (Object[])new String[]{encoding, path});
                                    this.prepareError(name, special, message7, 8197, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                                } else {
                                    encodings.add(new EncodingEntry(member, encoding));
                                }
                            } else {
                                String message8 = PDECoreMessages.SourceEntryErrorReporter_4;
                                this.prepareError(name, special, message8, 4135, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                            }
                            ++libName;
                        }
                        List<EncodingEntry> workspace = this.fCustomEncodings.remove(lib2);
                        if (workspace == null) {
                            this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_5, (Object)lib2), 8197, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                        } else {
                            HashMap<IResource, String> map = new HashMap<IResource, String>();
                            for (EncodingEntry ee : workspace) {
                                map.put(ee.getResource(), ee.getEncoding());
                            }
                            for (EncodingEntry ee : encodings) {
                                String specified = ee.getEncoding();
                                String expected = (String)map.remove(ee.getResource());
                                if (expected == null) {
                                    this.prepareError(name, ee.getValue(), NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_6, (Object[])new String[]{expected, ee.getResource().getProjectRelativePath().toString()}), 8197, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                                    continue;
                                }
                                if (specified.equals(expected)) continue;
                                this.prepareError(name, ee.getValue(), NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_7, (Object[])new String[]{expected, ee.getResource().getProjectRelativePath().toString(), specified}), 4135, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                            }
                            if (!map.isEmpty()) {
                                for (Map.Entry en : map.entrySet()) {
                                    IResource res = (IResource)en.getKey();
                                    String expected = (String)en.getValue();
                                    EncodingEntry missing = new EncodingEntry(res, expected);
                                    String m = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_8, (Object[])new String[]{expected, res.getProjectRelativePath().toString()});
                                    this.prepareError(name, missing.getValue(), m, 8195, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                                }
                            }
                        }
                    }
                }
                ++container;
            }
            for (Map.Entry<String, String> entry : this.fDefaultLibraryEncodings.entrySet()) {
                String lib3 = entry.getKey();
                String expected = entry.getValue();
                this.prepareError("javacDefaultEncoding." + lib3, expected, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_9, (Object[])new String[]{expected, lib3}), 8195, this.fEncodingSeverity, "compilers.p.build.encodings", "");
            }
            for (Map.Entry<String, List<EncodingEntry>> entry : this.fCustomEncodings.entrySet()) {
                String lib4 = entry.getKey();
                List<EncodingEntry> encodings = entry.getValue();
                for (EncodingEntry encoding : encodings) {
                    String m = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_10, (Object[])new String[]{encoding.getEncoding(), encoding.getResource().getProjectRelativePath().toString()});
                    this.prepareError("javacCustomEncodings." + lib4, encoding.getValue(), m, 8195, this.fEncodingSeverity, "compilers.p.build.encodings", "");
                }
            }
        }
    }

    private String getExplicitEncoding(IContainer container) throws CoreException {
        IContainer parent;
        String encoding = container.getDefaultCharset(false);
        if (encoding == null && (parent = container.getParent()) != null) {
            switch (parent.getType()) {
                case 2: {
                    return this.getExplicitEncoding(parent);
                }
                case 4: {
                    return this.getExplicitEncoding(parent);
                }
            }
            return null;
        }
        return encoding;
    }

    private String join(ProjectFolder[] folders) {
        StringBuilder result = new StringBuilder();
        ProjectFolder[] projectFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectFolder folder = projectFolderArray[n2];
            String text = folder.getPath().toString().trim();
            if (text.length() > 0) {
                result.append(text);
                result.append(',');
            }
            ++n2;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public ArrayList<BuildErrorReporter.BuildProblem> getProblemList() {
        return this.fProblemList;
    }

    static class EncodingEntry {
        private final String fEncoding;
        private final IResource fResource;

        EncodingEntry(IResource resource, String encoding) {
            this.fEncoding = encoding;
            this.fResource = resource;
        }

        public String getEncoding() {
            return this.fEncoding;
        }

        public IResource getResource() {
            return this.fResource;
        }

        public String toString() {
            return this.getValue();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncodingEntry) {
                EncodingEntry other = (EncodingEntry)obj;
                return other.fEncoding.equals(this.fEncoding) && other.fResource.equals((Object)this.fResource);
            }
            return false;
        }

        public int hashCode() {
            return this.fEncoding.hashCode() + this.fResource.hashCode();
        }

        String getValue() {
            StringBuilder buf = new StringBuilder();
            IContainer root = PDEProject.getBundleRoot(this.fResource.getProject());
            buf.append(this.fResource.getFullPath().makeRelativeTo(root.getFullPath()).makeAbsolute());
            buf.append('[');
            buf.append(this.fEncoding);
            buf.append(']');
            return buf.toString();
        }
    }

    static class OutputFolder
    extends ProjectFolder {
        private final ArrayList<SourceFolder> fSourceFolders = new ArrayList();
        private boolean fIsLibrary = false;

        public OutputFolder(IPath path) {
            super(path);
        }

        public OutputFolder(IPath path, boolean isLibrary) {
            this(path);
            this.fIsLibrary = isLibrary;
        }

        public void addSourceFolder(SourceFolder sourceFolder) {
            if (!this.fSourceFolders.contains(sourceFolder)) {
                this.fSourceFolders.add(sourceFolder);
            }
        }

        public boolean isLibrary() {
            return this.fIsLibrary;
        }

        public ArrayList<SourceFolder> getSourceFolders() {
            return this.fSourceFolders;
        }
    }

    static class ProjectFolder {
        IPath fPath;
        String fToken;
        ArrayList<String> fLibs = new ArrayList(1);
        String dupeLibName = null;

        public ProjectFolder(IPath path) {
            this.fPath = path;
        }

        public IPath getPath() {
            return this.fPath;
        }

        void setToken(String token) {
            this.fToken = token;
        }

        public String getToken() {
            if (this.fToken == null) {
                return this.fPath.toString();
            }
            return this.fToken;
        }

        public void addLib(String libName) {
            if (this.fLibs.contains(libName)) {
                this.dupeLibName = libName;
            } else {
                this.fLibs.add(libName);
            }
        }

        public ArrayList<String> getLibs() {
            return this.fLibs;
        }

        public String getDupeLibName() {
            return this.dupeLibName;
        }
    }

    static class SourceFolder
    extends ProjectFolder {
        OutputFolder fOutputFolder;

        public SourceFolder(IPath path, OutputFolder outputFolder) {
            super(path);
            this.fOutputFolder = outputFolder;
        }

        public OutputFolder getOutputLocation() {
            return this.fOutputFolder;
        }
    }

    class Visitor
    implements IResourceVisitor {
        String[] fLibs = null;

        Visitor(SourceFolder folder) {
            ArrayList<String> list = folder.getLibs();
            this.fLibs = list.toArray(new String[list.size()]);
        }

        public boolean visit(IResource resource) throws CoreException {
            String encoding = null;
            switch (resource.getType()) {
                case 2: {
                    encoding = ((IFolder)resource).getDefaultCharset(false);
                    break;
                }
                case 1: {
                    IFile file = (IFile)resource;
                    if (file.getFileExtension() == null || !file.getFileExtension().equals("java")) break;
                    encoding = file.getCharset(false);
                }
            }
            if (encoding != null) {
                EncodingEntry entry = new EncodingEntry(resource, encoding);
                String[] stringArray = this.fLibs;
                int n = this.fLibs.length;
                int n2 = 0;
                while (n2 < n) {
                    String lib = stringArray[n2];
                    List<EncodingEntry> encodings = SourceEntryErrorReporter.this.fCustomEncodings.get(lib);
                    if (encodings == null) {
                        encodings = new ArrayList<EncodingEntry>();
                        SourceEntryErrorReporter.this.fCustomEncodings.put(lib, encodings);
                    }
                    encodings.add(entry);
                    ++n2;
                }
            }
            return true;
        }
    }
}

