/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.ui.contribution.ModelConverterDescriptor;
import org.eclipse.emf.converter.ui.contribution.ModelConverterManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelConverterDescriptorSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    protected ModelConverterManager<?> modelConverterManager;
    protected ModelConverterDescriptor descriptor;
    protected TableViewer descriptorTableViewer;
    protected ImageDescriptor modeConverterWizardDefaultImageDescriptor;
    protected Map<? extends ModelConverterDescriptor, ModelConverterManager.ModelConverterDescriptorWizardNode> modelConverterWizardNodeMap;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected boolean firstTime = true;
    protected Set<IWizard> initializedWizards = new HashSet<IWizard>();
    private static final InstanceScope INSTANCE_SCOPE = new InstanceScope();

    public ModelConverterDescriptorSelectionPage(String pageId, ModelConverterManager<?> modelConverterManager, IWorkbench workbench, IStructuredSelection selection) {
        super(pageId);
        this.modelConverterManager = modelConverterManager;
        this.workbench = workbench;
        this.selection = selection;
    }

    public void dispose() {
        if (this.descriptorTableViewer != null) {
            this.descriptorTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.descriptorTableViewer = null;
        }
        if (this.initializedWizards != null) {
            this.initializedWizards.clear();
            this.initializedWizards = null;
        }
        this.modeConverterWizardDefaultImageDescriptor = null;
        this.descriptor = null;
        this.modelConverterManager = null;
        this.clearCache();
        super.dispose();
    }

    public void clearCache() {
        if (this.modelConverterWizardNodeMap != null) {
            for (IWizardNode iWizardNode : this.modelConverterWizardNodeMap.values()) {
                iWizardNode.dispose();
            }
            this.modelConverterWizardNodeMap.clear();
            this.modelConverterWizardNodeMap = null;
        }
        this.selection = null;
        this.workbench = null;
    }

    public void setModeConverterWizardDefaultImageDescriptor(ImageDescriptor imageDescriptor) {
        this.modeConverterWizardDefaultImageDescriptor = imageDescriptor;
    }

    public String getLastModelConverterDescriptorId() {
        return Platform.getPreferencesService().getString("org.eclipse.emf.converter", this.modelConverterManager.getClass().getName(), "", null);
    }

    public void performFinish() {
        if (this.descriptor != null) {
            IEclipsePreferences node = INSTANCE_SCOPE.getNode("org.eclipse.emf.converter");
            node.put(this.modelConverterManager.getClass().getName(), this.descriptor.getID());
            try {
                node.flush();
            }
            catch (BackingStoreException exception) {
                ConverterPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public void setModelConverterDescriptor(ModelConverterDescriptor descriptor) {
        if (this.getModelConverterDescriptor() != descriptor) {
            this.descriptor = descriptor;
            if (this.descriptorTableViewer != null) {
                if (descriptor != null) {
                    this.descriptorTableViewer.setSelection((ISelection)new StructuredSelection((Object)descriptor), true);
                } else {
                    this.descriptorTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        }
    }

    public ModelConverterDescriptor getModelConverterDescriptor() {
        return this.descriptor;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.firstTime) {
            this.firstTime = false;
            Table table = this.descriptorTableViewer.getTable();
            this.firstTimeVisible(table);
            table.setFocus();
        }
    }

    protected void firstTimeVisible(Table descriptorTable) {
        if (descriptorTable.getItemCount() > 0) {
            ModelConverterDescriptor descriptor = this.getModelConverterDescriptor();
            if (descriptor == null) {
                descriptor = this.modelConverterManager.getModelConverterDescriptor(this.getLastModelConverterDescriptorId());
                if (descriptor == null) {
                    descriptor = (ModelConverterDescriptor)descriptorTable.getItem(0).getData();
                }
                this.setModelConverterDescriptor(descriptor);
            }
        } else {
            this.setErrorMessage(this.getNoModelConverterMessage());
        }
    }

    protected String getNoModelConverterMessage() {
        return GenModelEditPlugin.INSTANCE.getString("_UI_NoModelConverter_error");
    }

    protected abstract String getSelectModelConverterLabel();

    protected abstract Object[] getTableInput();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(this.getSelectModelConverterLabel());
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        Table descriptorTable = new Table(composite, 67588);
        GridData data2 = new GridData();
        data2.widthHint = Display.getCurrent().getBounds().width / 5;
        data2.heightHint = Display.getCurrent().getBounds().height / 3;
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        descriptorTable.setLayoutData((Object)data2);
        this.descriptorTableViewer = new TableViewer(descriptorTable);
        this.descriptorTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.descriptorTableViewer.setLabelProvider((IBaseLabelProvider)new ModelConverterManager.ModelConverterDescriptorLabelProvider());
        this.descriptorTableViewer.setComparator(new ViewerComparator());
        this.descriptorTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ModelConverterDescriptorSelectionPage.this.canFlipToNextPage()) {
                    ModelConverterDescriptorSelectionPage.this.getContainer().showPage(ModelConverterDescriptorSelectionPage.this.getNextPage());
                }
            }
        });
        this.descriptorTableViewer.setInput((Object)this.getTableInput());
        this.descriptorTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.getModelConverterDescriptor() != null) {
            this.descriptorTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.getModelConverterDescriptor()), true);
        }
        this.setControl((Control)composite);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selectedObject;
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof ModelConverterDescriptor) {
            this.descriptor = (ModelConverterDescriptor)selectedObject;
            if (this.modelConverterWizardNodeMap == null) {
                this.modelConverterWizardNodeMap = this.modelConverterManager.createModelConverterDescriptorWizardNodeMap();
            }
            this.setMessage(this.descriptor.getDescription(), 0);
            this.setSelectedNode(this.modelConverterWizardNodeMap.get(this.descriptor));
            return;
        }
        this.setPageComplete(false);
    }

    public boolean isPageComplete() {
        return this.descriptor != null;
    }

    public IWizardPage getNextPage() {
        IWizard modelConverterWizard = this.getSelectedNode().getWizard();
        if (this.initializedWizards.add(modelConverterWizard)) {
            if (modelConverterWizard instanceof Wizard) {
                Wizard wizard = (Wizard)modelConverterWizard;
                if (this.modeConverterWizardDefaultImageDescriptor != null) {
                    wizard.setDefaultPageImageDescriptor(this.modeConverterWizardDefaultImageDescriptor);
                }
                if (wizard.getWindowTitle() == null) {
                    wizard.setWindowTitle(this.getWizard().getWindowTitle());
                }
            }
            if (modelConverterWizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)modelConverterWizard).init(this.workbench, this.selection);
            }
        }
        this.adjustModelConverterWizard(modelConverterWizard);
        IWizardPage wizardPage = super.getNextPage();
        IWizardNode wizardNode = this.getSelectedNode();
        if (wizardNode instanceof ModelConverterManager.ModelConverterDescriptorWizardNode) {
            ((ModelConverterManager.ModelConverterDescriptorWizardNode)wizardNode).setContentCreated(true);
        }
        return wizardPage;
    }

    protected void adjustModelConverterWizard(IWizard modelConverterWizard) {
    }
}

