/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class PDESection
extends SectionPart
implements IContextPart,
IAdaptable {
    private PDEFormPage fPage;

    public PDESection(PDEFormPage page, Composite parent, int style) {
        this(page, parent, style, true);
    }

    public PDESection(PDEFormPage page, Composite parent, int style, boolean titleBar) {
        super(parent, page.getManagedForm().getToolkit(), titleBar ? 0x100 | style : style);
        this.fPage = page;
        this.initialize(page.getManagedForm());
        this.getSection().clientVerticalSpacing = 6;
        this.getSection().setData("part", (Object)this);
    }

    protected abstract void createClient(Section var1, FormToolkit var2);

    @Override
    public PDEFormPage getPage() {
        return this.fPage;
    }

    protected IProject getProject() {
        return this.fPage.getPDEEditor().getCommonProject();
    }

    public boolean doGlobalAction(String actionId) {
        return false;
    }

    protected void handleSelectAll() {
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    @Override
    public String getContextId() {
        return null;
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
        if (this.getContextId() != null) {
            this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
        }
    }

    @Override
    public boolean isEditable() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return model == null ? false : model.isEditable();
    }

    public boolean canCopy(ISelection selection) {
        return false;
    }

    public boolean canCut(ISelection selection) {
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    @Override
    public void cancelEdit() {
        super.refresh();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

