/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.NonExistingVariableException;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.UnpoppableScopeException;

public class StackedScopes
implements Scopes {
    private final LinkedList<HumbleScope> stack = new LinkedList();

    public StackedScopes() {
        this(new LinkedList<Map<String, Object>>());
    }

    public StackedScopes(List<Map<String, Object>> stack) {
        for (Map<String, Object> rawScope : stack) {
            Scopes.Scope enclosingScope = this.getCurrentOrEmptyScope();
            this.stack.addLast(new EnclosedScope(enclosingScope, rawScope));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public Scopes.Scope getCurrent() {
        return this.stack.getLast();
    }

    @Override
    public Optional<Scopes.Scope> getDeclaringScope(String variable) {
        Iterator<HumbleScope> scopesFromLastToFirst = this.stack.descendingIterator();
        while (scopesFromLastToFirst.hasNext()) {
            HumbleScope scope = scopesFromLastToFirst.next();
            if (!scope.containsOnItsOwn(variable)) continue;
            return Optional.of(scope);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Scopes.Scope> iterator() {
        LinkedList<HumbleScope> stackCopy = new LinkedList<HumbleScope>(this.stack);
        return stackCopy.iterator();
    }

    @Override
    public Scopes.Scope pushNew() {
        this.stack.addLast(new EnclosedScope(this.getCurrentOrEmptyScope()));
        return this.getCurrent();
    }

    @Override
    public Optional<Scopes.Scope> pop() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Scopes.Scope)this.stack.removeLast());
    }

    @Override
    public void clear() {
        this.stack.clear();
    }

    private Scopes.Scope getCurrentOrEmptyScope() {
        try {
            return this.getCurrent();
        }
        catch (NoSuchElementException e) {
            return new EmptyScope();
        }
    }

    public String toString() {
        return this.stack.toString();
    }

    private class EmptyScope
    implements HumbleScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(String variable) {
            return false;
        }

        @Override
        public boolean containsOnItsOwn(String variable) {
            return false;
        }

        @Override
        public Set<String> getVariableNames() {
            return new HashSet<String>(0);
        }

        @Override
        public boolean hasValue(String variable) {
            return false;
        }

        @Override
        public Object getValue(String variable) {
            throw new IllegalArgumentException("variable '" + variable + "' not found");
        }

        @Override
        public Optional<Object> findValue(String variable) {
            return Optional.empty();
        }

        @Override
        public Map<String, Object> getVariableValues() {
            return new HashMap<String, Object>(0);
        }

        @Override
        public boolean hasTypes(String variable) {
            return false;
        }

        @Override
        public Set<IType> getTypes(String variable) {
            return new HashSet<IType>(0);
        }

        @Override
        public Optional<Set<IType>> findTypes(String variable) {
            return Optional.empty();
        }

        @Override
        public Map<String, Set<IType>> getVariableTypes() {
            return new HashMap<String, Set<IType>>(0);
        }

        @Override
        public void putVariable(String variable, Set<IType> types, Object value) {
            throw new UnsupportedOperationException("EmptyScope does not support 'putVariable(String, Set<IType>, Object)'; this method should not be called");
        }

        @Override
        public void putValue(String variable, Object value) {
            throw new UnsupportedOperationException("EmptyScope does not support 'putValue(String, Object)'; this method should not be called");
        }

        @Override
        public void putTypes(String variable, Set<IType> types) {
            throw new UnsupportedOperationException("EmptyScope does not support 'put(String, Set<IType)'; this method should not be called");
        }

        @Override
        public void putTypes(Expression expression, Set<IType> types) {
            throw new UnsupportedOperationException("EmptyScope does not support 'put(Expression, Set<IType>)'; this method should not be called");
        }

        @Override
        public Set<IType> getPossibleTypesOf(Expression expression) {
            return new HashSet<IType>(0);
        }

        @Override
        public void close() {
            if (StackedScopes.this.isEmpty()) {
                throw new UnpoppableScopeException("Cannot pop " + this + " when " + StackedScopes.this + " is empty");
            }
            if (StackedScopes.this.getCurrent() != this) {
                throw new UnpoppableScopeException("Cannot pop " + this + " when " + StackedScopes.this.getCurrent() + " is the current scope");
            }
            StackedScopes.this.pop();
        }

        public String toString() {
            return "Scope: {}";
        }
    }

    private class EnclosedScope
    implements HumbleScope {
        private final Scopes.Scope enclosing;
        private final Map<String, Object> values;
        private final Map<String, Set<IType>> types;
        private final Map<Expression, Set<IType>> expressions;

        EnclosedScope(Scopes.Scope enclosing) {
            this(enclosing, Collections.emptyMap());
        }

        EnclosedScope(Scopes.Scope enclosing, Map<String, Object> variables) {
            this.enclosing = enclosing;
            this.values = new HashMap<String, Object>(variables);
            this.types = new HashMap<String, Set<IType>>();
            this.expressions = new HashMap<Expression, Set<IType>>();
        }

        @Override
        public boolean contains(String variable) {
            return this.getVariableNames().contains(variable) || this.getVariableTypes().containsKey(variable);
        }

        @Override
        public boolean containsOnItsOwn(String variable) {
            return this.types.containsKey(variable);
        }

        @Override
        public boolean hasValue(String variable) {
            return this.getVariableValues().containsKey(variable);
        }

        @Override
        public Object getValue(String variable) {
            return this.findValue(variable).orElseThrow(() -> new NonExistingVariableException("variable '" + variable + "' not found"));
        }

        @Override
        public Optional<Object> findValue(String variable) {
            return Optional.ofNullable(this.values.get(variable));
        }

        @Override
        public boolean hasTypes(String variable) {
            return this.getVariableTypes().containsKey(variable);
        }

        @Override
        public Set<IType> getTypes(String variable) {
            return this.findTypes(variable).orElseThrow(() -> new NonExistingVariableException("variable '" + variable + "' not found"));
        }

        @Override
        public Optional<Set<IType>> findTypes(String variable) {
            if (this.types.containsKey(variable)) {
                return Optional.ofNullable(this.types.get(variable));
            }
            return this.enclosing.findTypes(variable);
        }

        @Override
        public Set<String> getVariableNames() {
            HashSet<String> names = new HashSet<String>(this.values.keySet());
            names.addAll(this.enclosing.getVariableNames());
            return names;
        }

        @Override
        public void putVariable(String variable, Set<IType> types, Object value) {
            this.putValue(variable, value);
            this.putTypes(variable, types);
        }

        @Override
        public void putValue(String variable, Object value) {
            this.values.put(variable, value);
        }

        @Override
        public void putTypes(String variable, Set<IType> types) {
            this.types.put(variable, new HashSet<IType>(types));
        }

        @Override
        public void putTypes(Expression expression, Set<IType> types) {
            this.expressions.put(expression, new HashSet<IType>(types));
        }

        @Override
        public Set<IType> getPossibleTypesOf(Expression expression) {
            return this.expressions.getOrDefault(expression, new HashSet(0));
        }

        @Override
        public Map<String, Set<IType>> getVariableTypes() {
            Map<String, Set<IType>> variableTypes = this.enclosing.getVariableTypes();
            variableTypes.putAll(this.types);
            return variableTypes;
        }

        @Override
        public Map<String, Object> getVariableValues() {
            Map<String, Object> variableValues = this.enclosing.getVariableValues();
            variableValues.putAll(this.values);
            return variableValues;
        }

        @Override
        public void close() {
            if (StackedScopes.this.isEmpty()) {
                throw new UnpoppableScopeException("Cannot pop " + this + " when " + StackedScopes.this + " is empty");
            }
            if (StackedScopes.this.getCurrent() != this) {
                throw new UnpoppableScopeException("Cannot pop " + this + " when " + StackedScopes.this.getCurrent() + " is the current scope");
            }
            StackedScopes.this.pop();
        }

        public String toString() {
            return "EnclosedScope {" + System.lineSeparator() + "    values=" + this.getVariableValues() + "," + System.lineSeparator() + "    types=" + this.getVariableTypes() + "," + System.lineSeparator() + "    expressions=" + this.expressions + System.lineSeparator() + "}";
        }
    }

    private static interface HumbleScope
    extends Scopes.Scope {
        public boolean containsOnItsOwn(String var1);
    }
}

