/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;

public final class ConvertType
implements IConvertType {
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public ConvertType(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = Objects.requireNonNull(queryEnvironment, "queryEnvironment");
    }

    @Override
    public IType toAQL(ETypedElement typedElement) {
        if (typedElement.getEType() == EcorePackage.eINSTANCE.getEEList()) {
            NothingType aqlGenericType = new NothingType("?");
            if (!typedElement.getEGenericType().getETypeArguments().isEmpty()) {
                EGenericType emfGenericType = (EGenericType)typedElement.getEGenericType().getETypeArguments().get(0);
                aqlGenericType = this.toAQL(emfGenericType.getEClassifier());
            }
            return new SequenceType(this.queryEnvironment, (IType)aqlGenericType);
        }
        if (typedElement.isMany()) {
            if (typedElement.isUnique()) {
                return new SetType(this.queryEnvironment, this.toAQL(typedElement.getEType()));
            }
            return new SequenceType(this.queryEnvironment, this.toAQL(typedElement.getEType()));
        }
        return this.toAQL(typedElement.getEType());
    }

    @Override
    public IType toAQL(EClassifier type) {
        return this.toAQL(type, null);
    }

    @Override
    public IType toAQL(EClassifier type, EClassifier typeParameter) {
        if (type == EcorePackage.eINSTANCE.getEEList()) {
            NothingType collectionType = new NothingType("?");
            if (typeParameter != null) {
                collectionType = this.toAQL(typeParameter);
            }
            return new SequenceType(this.queryEnvironment, (IType)collectionType);
        }
        if (type == null || type == ImplementationPackage.eINSTANCE.getVoidEClassifier()) {
            return new NothingType("void");
        }
        return new EClassifierType(this.queryEnvironment, type);
    }

    @Override
    public Optional<EClassifier> toEMF(IType type) {
        if (type.getType() instanceof EClassifier) {
            EClassifier classifier = (EClassifier)type.getType();
            return Optional.of(classifier);
        }
        return Optional.empty();
    }

    @Override
    public Optional<EClassifier> toEMF(TypeLiteral typeLiteral) {
        if (typeLiteral instanceof CollectionTypeLiteral) {
            CollectionTypeLiteral collectionTypeLiteral = (CollectionTypeLiteral)typeLiteral;
            if (collectionTypeLiteral.getElementType().getValue() instanceof Class) {
                Class clazz = (Class)collectionTypeLiteral.getElementType().getValue();
                EClassifier classifier = this.toEMF(clazz);
                if (classifier == ImplementationPackage.eINSTANCE.getUnresolvedEClassifier()) {
                    classifier = EcoreFactory.eINSTANCE.createEDataType();
                    classifier.setInstanceClass((Class)collectionTypeLiteral.getElementType().getValue());
                    classifier.setName(classifier.getInstanceClass().getSimpleName());
                    classifier.setInstanceTypeName(classifier.getInstanceClass().getName());
                    classifier.setInstanceClassName(classifier.getInstanceClass().getName());
                }
                return Optional.ofNullable(classifier);
            }
            if (collectionTypeLiteral.getElementType().getValue() instanceof EClass) {
                EClass classifier = (EClass)collectionTypeLiteral.getElementType().getValue();
                return Optional.of(classifier);
            }
        } else {
            if (typeLiteral.getValue() instanceof Class) {
                EClassifier classifier = this.toEMF((Class)typeLiteral.getValue());
                return Optional.of(classifier);
            }
            if (typeLiteral.getValue() instanceof EClassifier) {
                return Optional.of((EClassifier)typeLiteral.getValue());
            }
        }
        return Optional.empty();
    }

    @Override
    public EClassifier toEMF(Class<?> type) {
        if (type == String.class) {
            return EcorePackage.eINSTANCE.getEString();
        }
        if (type == Integer.class) {
            return EcorePackage.eINSTANCE.getEInt();
        }
        if (type == Double.class) {
            return EcorePackage.eINSTANCE.getEDouble();
        }
        if (type == Boolean.class) {
            return EcorePackage.eINSTANCE.getEBoolean();
        }
        if (type == List.class) {
            return EcorePackage.eINSTANCE.getEEList();
        }
        if (type == Set.class) {
            return EcorePackage.eINSTANCE.getEEList();
        }
        return ImplementationPackage.eINSTANCE.getUnresolvedEClassifier();
    }
}

