/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;

public class LockHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public LockHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "LockHandler");
        }
        if (pkt.getType() == 11) {
            this.handleLock(sender, pkt);
        } else if (pkt.getType() == 12) {
            this.handleLockReply(sender, pkt);
        } else {
            this.logger.log(16, "LockHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    private void handleLock(BrokerAddress sender, GPacket pkt) {
        String resId = (String)pkt.getProp((Object)"I");
        long timestamp = (Long)pkt.getProp((Object)"TS");
        long xid = (Long)pkt.getProp((Object)"X");
        boolean shared = (Boolean)pkt.getProp((Object)"SH");
        this.p.receiveLockRequest(sender, resId, timestamp, xid, shared);
    }

    private void handleLockReply(BrokerAddress sender, GPacket pkt) {
        String resId = (String)pkt.getProp((Object)"I");
        long xid = (Long)pkt.getProp((Object)"X");
        int response = (Integer)pkt.getProp((Object)"S");
        this.p.receiveLockResponse(sender, resId, xid, response);
    }
}

