/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.authorize;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.authorize.PolicyContextDelegate;
import com.sun.enterprise.security.ee.PermissionCacheFactory;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.internal.api.Globals;

public class HandlerData {
    private HttpServletRequest httpReq = null;
    private ComponentInvocation inv = null;
    private PolicyContextDelegate ejbDelegate = Globals.getDefaultHabitat().getService(PolicyContextDelegate.class, "EJB", new Annotation[0]);

    private HandlerData() {
    }

    public static HandlerData getInstance() {
        return new HandlerData();
    }

    public void setHttpServletRequest(HttpServletRequest httpReq) {
        this.httpReq = httpReq;
    }

    public void setInvocation(ComponentInvocation inv) {
        this.inv = inv;
    }

    public Object get(String key) {
        if ("javax.servlet.http.HttpServletRequest".equalsIgnoreCase(key)) {
            return this.httpReq;
        }
        if ("javax.security.auth.Subject.container".equalsIgnoreCase(key)) {
            return SecurityContext.getCurrent().getSubject();
        }
        if ("java.security.Policy.supportsReuse".equalsIgnoreCase(key)) {
            PermissionCacheFactory.resetCaches();
            return 0;
        }
        if (this.inv == null) {
            return null;
        }
        if ("javax.xml.soap.SOAPMessage".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getSOAPMessage(this.inv) : null;
        }
        if ("javax.ejb.EnterpriseBean".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEnterpriseBean(this.inv) : null;
        }
        if ("javax.ejb.arguments".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEJbArguments(this.inv) : null;
        }
        return null;
    }

    void reset() {
        this.httpReq = null;
        this.inv = null;
        this.ejbDelegate = null;
    }
}

