/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.wizards;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Element;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Model;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.OrGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.OutputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Wire;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.XORGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.util.LogicSemanticType;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicDiagramFactory {
    public static void CreateFourBitAdder(IGraphicalEditPart diagramEditPart, IProgressMonitor progressMonitor) {
        Circuit fullAdder1 = LogicDiagramFactory.createFullAdder(new Point(20, 120), new Dimension(140, 230), diagramEditPart, progressMonitor);
        Circuit fullAdder2 = LogicDiagramFactory.createFullAdder(new Point(170, 120), new Dimension(140, 230), diagramEditPart, progressMonitor);
        Circuit fullAdder3 = LogicDiagramFactory.createFullAdder(new Point(320, 120), new Dimension(140, 230), diagramEditPart, progressMonitor);
        Circuit halfAdder = LogicDiagramFactory.createHalfAdder(new Point(470, 120), new Dimension(70, 230), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder1, 3), LogicDiagramFactory.inputTerminal((Element)fullAdder2, 4), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder2, 3), LogicDiagramFactory.inputTerminal((Element)fullAdder3, 4), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder3, 3), LogicDiagramFactory.inputTerminal((Element)halfAdder, 4), diagramEditPart, progressMonitor);
        final LED ledInput1 = LogicDiagramFactory.createElement(LogicSemanticType.LED, LED.class, new Point(150, 20), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput1, 3), LogicDiagramFactory.inputTerminal((Element)fullAdder1, 0), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput1, 2), LogicDiagramFactory.inputTerminal((Element)fullAdder2, 0), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput1, 1), LogicDiagramFactory.inputTerminal((Element)fullAdder3, 0), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput1, 0), LogicDiagramFactory.inputTerminal((Element)halfAdder, 0), diagramEditPart, progressMonitor);
        final LED ledInput2 = LogicDiagramFactory.createElement(LogicSemanticType.LED, LED.class, new Point(350, 20), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput2, 3), LogicDiagramFactory.inputTerminal((Element)fullAdder1, 2), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput2, 2), LogicDiagramFactory.inputTerminal((Element)fullAdder2, 2), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput2, 1), LogicDiagramFactory.inputTerminal((Element)fullAdder3, 2), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)ledInput2, 0), LogicDiagramFactory.inputTerminal((Element)halfAdder, 3), diagramEditPart, progressMonitor);
        LED ledOutput = LogicDiagramFactory.createElement(LogicSemanticType.LED, LED.class, new Point(250, 400), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder1, 7), LogicDiagramFactory.inputTerminal((Element)ledOutput, 3), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder2, 7), LogicDiagramFactory.inputTerminal((Element)ledOutput, 2), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)fullAdder3, 7), LogicDiagramFactory.inputTerminal((Element)ledOutput, 1), diagramEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)halfAdder, 7), LogicDiagramFactory.inputTerminal((Element)ledOutput, 0), diagramEditPart, progressMonitor);
        AbstractCommand cmd = new AbstractCommand(){

            public void execute() {
                ledInput1.setValue(3);
                ledInput2.setValue(7);
            }

            public void redo() {
                this.execute();
            }
        };
        EMFCommandTransaction trans = new EMFCommandTransaction((Command)cmd, (InternalTransactionalEditingDomain)diagramEditPart.getEditingDomain(), null);
        try {
            trans.start();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        trans.getCommand().execute();
        try {
            trans.commit();
        }
        catch (RollbackException e) {
            e.printStackTrace();
        }
    }

    public static Circuit createFullAdder(Point location, Dimension size, IGraphicalEditPart containerEditPart, IProgressMonitor progressMonitor) {
        Circuit circuit = LogicDiagramFactory.createElement(LogicSemanticType.CIRCUIT, Circuit.class, location, size, containerEditPart, progressMonitor);
        CircuitEditPart circuitEditPart = LogicDiagramFactory.getEditPart((EObject)circuit, CircuitEditPart.class, containerEditPart);
        Circuit halfAdder1 = LogicDiagramFactory.createHalfAdder(new Point(10, 10), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        Circuit halfAdder2 = LogicDiagramFactory.createHalfAdder(new Point(50, 100), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        OrGate orGate = LogicDiagramFactory.createElement(LogicSemanticType.ORGATE, OrGate.class, new Point(40, 180), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 0), LogicDiagramFactory.inputTerminal((Element)halfAdder1, 0), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 2), LogicDiagramFactory.inputTerminal((Element)halfAdder1, 3), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 3), LogicDiagramFactory.inputTerminal((Element)halfAdder2, 3), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)halfAdder1, 7), LogicDiagramFactory.inputTerminal((Element)halfAdder2, 0), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)halfAdder1, 4), LogicDiagramFactory.inputTerminal((Element)orGate, 0), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)halfAdder2, 4), LogicDiagramFactory.inputTerminal((Element)orGate, 1), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)orGate, 0), LogicDiagramFactory.inputTerminal((Element)circuit, 4), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)halfAdder2, 7), LogicDiagramFactory.inputTerminal((Element)circuit, 7), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        return circuit;
    }

    public static Circuit createHalfAdder(Point location, IGraphicalEditPart containerEditPart, IProgressMonitor progressMonitor) {
        return LogicDiagramFactory.createHalfAdder(location, new Dimension(70, 70), containerEditPart, progressMonitor);
    }

    public static Circuit createHalfAdder(Point location, Dimension size, IGraphicalEditPart containerEditPart, IProgressMonitor progressMonitor) {
        Circuit circuit = LogicDiagramFactory.createElement(LogicSemanticType.CIRCUIT, Circuit.class, location, size, containerEditPart, progressMonitor);
        CircuitEditPart circuitEditPart = LogicDiagramFactory.getEditPart((EObject)circuit, CircuitEditPart.class, containerEditPart);
        AndGate andGate = LogicDiagramFactory.createElement(LogicSemanticType.ANDGATE, AndGate.class, new Point(10, 20), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        XORGate xorGate = LogicDiagramFactory.createElement(LogicSemanticType.XORGATE, XORGate.class, new Point(40, 20), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 0), LogicDiagramFactory.inputTerminal((Element)andGate, 0), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 3), LogicDiagramFactory.inputTerminal((Element)andGate, 1), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 0), LogicDiagramFactory.inputTerminal((Element)xorGate, 0), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)circuit, 3), LogicDiagramFactory.inputTerminal((Element)xorGate, 1), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)andGate, 0), LogicDiagramFactory.inputTerminal((Element)circuit, 4), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        LogicDiagramFactory.connect(LogicDiagramFactory.outputTerminal((Element)xorGate, 0), LogicDiagramFactory.inputTerminal((Element)circuit, 7), (IGraphicalEditPart)circuitEditPart, progressMonitor);
        return circuit;
    }

    private static <T> T createElement(IElementType elementType, Class<T> elementTypeClass, Point location, IGraphicalEditPart container, IProgressMonitor progressMonitor) {
        return LogicDiagramFactory.createElement(elementType, elementTypeClass, location, null, container, progressMonitor);
    }

    private static <T> T createElement(IElementType elementType, Class<T> elementTypeClass, Point location, Dimension size, IGraphicalEditPart container, IProgressMonitor progressMonitor) {
        if (container instanceof CircuitEditPart) {
            container = container.getChildBySemanticHint("LogicCompartment");
        }
        CreateViewRequest createRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)elementType, (PreferencesHint)container.getDiagramPreferencesHint());
        createRequest.setLocation(location);
        createRequest.setSize(size);
        org.eclipse.gef.commands.Command command = container.getCommand((Request)createRequest);
        container.getDiagramEditDomain().getDiagramCommandStack().execute(command, progressMonitor);
        List newObject = (List)createRequest.getNewObject();
        CreateViewAndElementRequest.ViewAndElementDescriptor viewAndElementDescriptor = (CreateViewAndElementRequest.ViewAndElementDescriptor)newObject.get(0);
        return (T)viewAndElementDescriptor.getElementAdapter().getAdapter(elementTypeClass);
    }

    private static void connect(OutputTerminal outputTerminal, InputTerminal inputTerminal, IGraphicalEditPart container, IProgressMonitor progressMonitor) {
        CreateRelationshipRequest createRequest = new CreateRelationshipRequest(container.getEditingDomain(), (EObject)outputTerminal, (EObject)inputTerminal, LogicSemanticType.WIRE);
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(createRequest.getEditHelperContext());
        ICommand createCommand = elementType.getEditCommand((IEditCommandRequest)createRequest);
        try {
            createCommand.execute(progressMonitor, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (createRequest.getContainer() instanceof Model) {
            TerminalEditPart outputTerminalEditPart = LogicDiagramFactory.getEditPart((EObject)outputTerminal, TerminalEditPart.class, container);
            TerminalEditPart inputTerminalEditPart = LogicDiagramFactory.getEditPart((EObject)inputTerminal, TerminalEditPart.class, container);
            org.eclipse.gef.commands.Command command = CreateConnectionViewRequest.getCreateCommand((EObject)((Wire)createCommand.getCommandResult().getReturnValue()), (EditPart)outputTerminalEditPart, (EditPart)inputTerminalEditPart, (PreferencesHint)container.getDiagramPreferencesHint());
            container.getDiagramEditDomain().getDiagramCommandStack().execute(command, progressMonitor);
        }
    }

    private static OutputTerminal outputTerminal(Element element, int terminal) {
        return (OutputTerminal)element.getOutputTerminals().get(terminal);
    }

    private static InputTerminal inputTerminal(Element element, int terminal) {
        return (InputTerminal)element.getInputTerminals().get(terminal);
    }

    private static <T> T getEditPart(EObject modelElement, Class<T> editPartType, IGraphicalEditPart container) {
        if (container instanceof CircuitEditPart) {
            container = container.getChildBySemanticHint("LogicCompartment");
        }
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)container.getRoot().getViewer();
        String proxyId = EMFCoreUtil.getProxyID((EObject)modelElement);
        return (T)viewer.findEditPartsForElement(proxyId, editPartType).get(0);
    }
}

