/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.decorator.provider;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.examples.runtime.diagram.decorator.DecoratorPlugin;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ReviewDecorator
implements IDecorator {
    private IDecoratorTarget decoratorTarget;
    private IDecoration decoration;
    private static final Image ICON_FAILED;
    private static final Image ICON_PASSED;
    private NotificationListener notificationListener = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            ReviewDecorator.this.refresh();
        }
    };

    static {
        IPath path = new Path("$nl$").append("icons//failed.gif");
        URL url = FileLocator.find((Bundle)DecoratorPlugin.getDefault().getBundle(), (IPath)path, null);
        ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
        ICON_FAILED = imgDesc.createImage();
        path = new Path("$nl$").append("icons//passed.gif");
        url = FileLocator.find((Bundle)DecoratorPlugin.getDefault().getBundle(), (IPath)path, null);
        imgDesc = ImageDescriptor.createFromURL((URL)url);
        ICON_PASSED = imgDesc.createImage();
    }

    public ReviewDecorator(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    protected IDecoratorTarget getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public IDecoration getDecoration() {
        return this.decoration;
    }

    public void setDecoration(IDecoration decoration) {
        this.decoration = decoration;
    }

    protected void removeDecoration() {
        if (this.decoration != null) {
            this.decoratorTarget.removeDecoration(this.decoration);
            this.decoration = null;
        }
    }

    public static Node getDecoratorTargetNode(IDecoratorTarget decoratorTarget) {
        DescriptionStyle descStyle = null;
        View node = (View)decoratorTarget.getAdapter(View.class);
        if (node != null && node.eContainer() instanceof Diagram && (descStyle = (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle())) != null) {
            return (Node)node;
        }
        return null;
    }

    public void refresh() {
        DescriptionStyle descStyle;
        this.removeDecoration();
        Node node = ReviewDecorator.getDecoratorTargetNode(this.getDecoratorTarget());
        if (node != null && (descStyle = this.getDescriptionStyle(node)) != null) {
            boolean passed = descStyle.getDescription().matches("Passed*");
            boolean failed = descStyle.getDescription().matches("Failed*");
            if (passed || failed) {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(passed ? ICON_PASSED : ICON_FAILED, IDecoratorTarget.Direction.NORTH, 75, false));
            }
        }
    }

    private DescriptionStyle getDescriptionStyle(Node node) {
        return (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
    }

    public void activate() {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).addNotificationListener((EObject)gep.getNotationView(), (EStructuralFeature)NotationPackage.eINSTANCE.getDescriptionStyle_Description(), this.notificationListener);
    }

    public void deactivate() {
        this.removeDecoration();
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).removeNotificationListener((EObject)gep.getNotationView(), (Object)NotationPackage.eINSTANCE.getDescriptionStyle_Description(), this.notificationListener);
    }
}

