/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypeDebugOptions;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.XMLExpressionMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class XMLClientContext
extends ClientContext {
    private static final String E_ENABLEMENT = "enablement";
    private static final String E_MATCHER = "matcher";

    public XMLClientContext(IConfigurationElement config) throws CoreException {
        super(XMLClientContext.initializeId(config), XMLClientContext.initializeMatcher(config, config.getAttribute("id")));
    }

    private static String initializeId(IConfigurationElement config) throws CoreException {
        String result = config.getAttribute("id");
        if (result == null) {
            CoreException ce = EMFTypePluginStatusCodes.getContextInitException(config.getContributor().getName(), EMFTypeCoreMessages.context_no_id_ERROR_);
            Trace.throwing((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_THROWING, XMLClientContext.class, (String)"initializeId", (Throwable)ce);
            throw ce;
        }
        return result;
    }

    private static IElementMatcher initializeMatcher(IConfigurationElement config, String id) throws CoreException {
        IElementMatcher result = null;
        IConfigurationElement[] enablement = config.getChildren(E_ENABLEMENT);
        if (enablement.length > 0) {
            result = XMLClientContext.initializeExpressionMatcher(enablement[0], id);
        } else {
            IConfigurationElement[] custom = config.getChildren(E_MATCHER);
            if (custom.length > 0) {
                result = XMLClientContext.initializeCustomMatcher(custom[0], id);
            }
        }
        if (result == null) {
            CoreException ce = EMFTypePluginStatusCodes.getContextInitException(id, EMFTypeCoreMessages.context_no_matcher_ERROR_);
            Trace.throwing((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_THROWING, XMLClientContext.class, (String)"initializeMatcher", (Throwable)ce);
            throw ce;
        }
        return result;
    }

    private static IElementMatcher initializeExpressionMatcher(IConfigurationElement enablement, String id) throws CoreException {
        return new XMLExpressionMatcher(enablement, id);
    }

    private static IElementMatcher initializeCustomMatcher(IConfigurationElement config, String id) throws CoreException {
        Object result = config.createExecutableExtension("class");
        if (!(result instanceof IElementMatcher)) {
            CoreException ce = EMFTypePluginStatusCodes.getContextInitException(id, EMFTypeCoreMessages.context_matcher_wrong_class_ERROR_);
            Trace.throwing((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_THROWING, XMLClientContext.class, (String)"initializeMatcher", (Throwable)ce);
            throw ce;
        }
        return (IElementMatcher)result;
    }
}

