/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.FileBufferListenerAdapter;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IBufferListener;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.text.edits.MalformedTreeException;

public final class TextFileBuffer
implements IBuffer {
    private final Object location;
    private ICoreTextFileBufferProvider coreTextFileBufferProvider;
    private int refCount = 1;
    private ListenerList<IBufferListener> listeners;
    private FileBufferListener fileBufferListener;

    public static TextFileBuffer forLocation(IPath location, LocationKind locationKind) throws CoreException {
        return new TextFileBuffer(ICoreTextFileBufferProvider.forLocation(location, locationKind, ITextFileBufferManager.DEFAULT), null);
    }

    public static TextFileBuffer forFileStore(IFileStore fileStore) throws CoreException {
        return new TextFileBuffer(ICoreTextFileBufferProvider.forFileStore(fileStore, ITextFileBufferManager.DEFAULT), null);
    }

    public static TextFileBuffer forFile(IFile file) throws CoreException {
        return TextFileBuffer.forLocation(file.getFullPath(), LocationKind.IFILE);
    }

    public TextFileBuffer(ICoreTextFileBufferProvider provider, IProgressMonitor monitor) throws CoreException {
        this.coreTextFileBufferProvider = provider;
        if (this.coreTextFileBufferProvider == null) {
            throw new IllegalArgumentException();
        }
        provider.connect(monitor);
        boolean f = false;
        try {
            ITextFileBuffer buffer = provider.getBuffer();
            IPath location = buffer.getLocation();
            if (location == null) {
                location = buffer.getFileStore();
            }
            this.location = location;
            f = true;
        }
        finally {
            if (!f) {
                provider.disconnect(null);
            }
        }
    }

    public ICoreTextFileBufferProvider getCoreTextFileBufferProvider() {
        ICoreTextFileBufferProvider result = this.coreTextFileBufferProvider;
        if (result == null) {
            throw new IllegalStateException("Attempt to access a disconnected TextFileBuffer for " + String.valueOf(this.location));
        }
        return result;
    }

    @Override
    public IDocument getDocument() {
        return this.getCoreTextFileBufferProvider().getBuffer().getDocument();
    }

    @Override
    public IAnnotationModel getAnnotationModel() {
        return this.getCoreTextFileBufferProvider().getBuffer().getAnnotationModel();
    }

    @Override
    public ISnapshot getSnapshot() {
        ICoreTextFileBufferProvider provider = this.getCoreTextFileBufferProvider();
        return new TextFileBufferSnapshot(provider.getBuffer(), provider.getBufferManager());
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = new BufferChangeOperation(this, change);
            if (!this.getCoreTextFileBufferProvider().getBuffer().isSynchronizationContextRequested()) {
                return operation.execute(monitor);
            }
            UiSynchronizer synchronizer = UiSynchronizer.getDefault();
            if (synchronizer == null) {
                throw new IllegalStateException("Synchronization context is requested, but synchronizer is not available");
            }
            UiBufferChangeRunner runner = new UiBufferChangeRunner(synchronizer, operation);
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    @Override
    public void save(IContext context, IProgressMonitor monitor) throws CoreException {
        this.getCoreTextFileBufferProvider().getBuffer().commit(monitor, false);
    }

    @Override
    public boolean isDirty() {
        return this.getCoreTextFileBufferProvider().getBuffer().isDirty();
    }

    @Override
    public int getSupportedListenerMethods() {
        return 1;
    }

    @Override
    public synchronized void addListener(IBufferListener listener) {
        if (this.listeners != null) {
            this.listeners.add((Object)listener);
        } else {
            ICoreTextFileBufferProvider provider = this.getCoreTextFileBufferProvider();
            this.listeners = new ListenerList();
            this.listeners.add((Object)listener);
            this.fileBufferListener = new FileBufferListener(provider.getBuffer());
            provider.getBufferManager().addFileBufferListener((IFileBufferListener)this.fileBufferListener);
        }
    }

    @Override
    public synchronized void removeListener(IBufferListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
        if (this.listeners.isEmpty()) {
            this.getCoreTextFileBufferProvider().getBufferManager().removeFileBufferListener((IFileBufferListener)this.fileBufferListener);
            this.fileBufferListener = null;
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRef() {
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ICoreTextFileBufferProvider provider;
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            if (--this.refCount != 0) {
                return;
            }
            if (this.coreTextFileBufferProvider == null) {
                return;
            }
            provider = this.coreTextFileBufferProvider;
            this.coreTextFileBufferProvider = null;
            this.listeners = null;
        }
        try {
            if (this.fileBufferListener != null) {
                provider.getBufferManager().removeFileBufferListener((IFileBufferListener)this.fileBufferListener);
                this.fileBufferListener = null;
            }
        }
        finally {
            try {
                provider.disconnect(null);
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBufferSaved() {
        ListenerList<IBufferListener> listeners;
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            if (this.listeners == null) {
                return;
            }
            listeners = this.listeners;
        }
        for (IBufferListener listener : listeners) {
            SafeRunner.run(() -> listener.bufferSaved(this));
        }
    }

    private class FileBufferListener
    extends FileBufferListenerAdapter {
        private final ITextFileBuffer buffer;
        private long modificationStamp;

        FileBufferListener(ITextFileBuffer buffer) {
            this.buffer = buffer;
            this.modificationStamp = buffer.getModificationStamp();
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (buffer == this.buffer && !isDirty && buffer.isSynchronized() && this.modificationStamp != buffer.getModificationStamp()) {
                this.modificationStamp = buffer.getModificationStamp();
                TextFileBuffer.this.fireBufferSaved();
            }
        }
    }
}

