/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import java.util.List;
import java.util.UUID;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyViewManager;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public final class CallHierarchyViewOpener {
    private final String viewId;
    private final CallHierarchyViewManager viewManager;

    public CallHierarchyViewOpener(String viewId, CallHierarchyViewManager viewManager) {
        if (viewId == null) {
            throw new IllegalArgumentException();
        }
        if (viewManager == null) {
            throw new IllegalArgumentException();
        }
        this.viewId = viewId;
        this.viewManager = viewManager;
    }

    public IViewPart openView(IWorkbenchPage page, Object[] inputElements) throws PartInitException {
        IViewPart view;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        CallHierarchyViewPart viewToReuse = this.findViewToReuse(page);
        if (viewToReuse != null) {
            page.activate((IWorkbenchPart)viewToReuse);
            viewToReuse.setInputElements(inputElements);
            return viewToReuse;
        }
        String secondaryId = null;
        if (page.findViewReference(this.viewId) != null) {
            secondaryId = UUID.randomUUID().toString();
        }
        if ((view = page.showView(this.viewId, secondaryId, 1)) instanceof CallHierarchyViewPart) {
            ((CallHierarchyViewPart)view).setInputElements(inputElements);
        }
        return view;
    }

    private CallHierarchyViewPart findViewToReuse(IWorkbenchPage page) {
        IViewReference[] viewReferences;
        List<CallHierarchyViewPart> views = this.viewManager.getViews();
        for (CallHierarchyViewPart view : views) {
            if (!page.equals(view.getSite().getPage()) || !this.viewId.equals(view.getSite().getId()) || view.isPinned()) continue;
            return view;
        }
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            CallHierarchyViewPart view;
            IViewPart restored;
            IViewReference viewReference = iViewReferenceArray[n2];
            if (this.viewId.equals(viewReference.getId()) && viewReference.getView(false) == null && (restored = viewReference.getView(true)) instanceof CallHierarchyViewPart && !(view = (CallHierarchyViewPart)restored).isPinned()) {
                return view;
            }
            ++n2;
        }
        return null;
    }
}

