/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.workingset;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.ui.viewer.LabelComparator;
import org.eclipse.handly.ui.workingset.Messages;
import org.eclipse.handly.util.ArrayUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.AbstractWorkingSet;

public abstract class AbstractWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    protected static final IAdaptable[] NO_ELEMENTS = new IAdaptable[0];
    private Text workingSetName;
    private TreeViewer tree;
    private TableViewer table;
    private ITreeContentProvider treeContentProvider;
    private IWorkingSet workingSet;
    private boolean firstCheck = true;
    private Set<IAdaptable> selectedElements = new LinkedHashSet<IAdaptable>();
    private IStructuredSelection initialSelection;

    public AbstractWorkingSetPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        ISelection selection;
        this.setDescription(Messages.AbstractWorkingSetPage_workingSet_description);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (selection = activeWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            this.initialSelection = (IStructuredSelection)selection;
        }
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(Messages.AbstractWorkingSetPage_workingSet_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.workingSetName = new Text(composite, 2052);
        this.workingSetName.setLayoutData((Object)new GridData(768));
        this.workingSetName.addModifyListener(e -> this.validateInput());
        Composite leftCenterRightComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        leftCenterRightComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftCenterRightComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(leftCenterRightComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        this.createTree(leftComposite);
        this.createTable(rightComposite);
        if (this.workingSet != null) {
            this.workingSetName.setText(this.workingSet.getName());
        }
        this.initializeSelectedElements();
        this.validateInput();
        this.table.setInput(this.selectedElements);
        this.table.refresh(true);
        this.tree.refresh(true);
        this.createButtonBar(centerComposite);
        this.workingSetName.setFocus();
        this.workingSetName.setSelection(0, this.workingSetName.getText().length());
        Dialog.applyDialogFont((Control)composite);
    }

    public void finish() {
        String name = this.workingSetName.getText();
        IAdaptable[] elements = this.getFinalWorkingSetElements(this.workingSet, this.selectedElements.toArray(NO_ELEMENTS));
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(name, elements);
            this.workingSet.setId(this.getPageId());
        } else {
            this.workingSet.setName(name);
            this.workingSet.setElements(elements);
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException();
        }
        this.workingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.workingSetName != null) {
            this.firstCheck = false;
            this.workingSetName.setText(workingSet.getName());
            this.initializeSelectedElements();
            this.validateInput();
        }
    }

    protected abstract String getPageId();

    protected abstract void configureTree(TreeViewer var1);

    protected abstract void configureTable(TableViewer var1);

    protected final IStructuredSelection getInitialSelection() {
        return this.initialSelection;
    }

    protected void initializeTreeSelection(TreeViewer tree) {
        Object[] elements;
        if (this.workingSet == null) {
            return;
        }
        IStructuredSelection selection = this.getInitialSelection();
        if (selection != null && !selection.isEmpty() && (elements = this.adaptElements(AbstractWorkingSetPage.getAdaptables(selection.toArray()))).length > 0) {
            tree.setSelection((ISelection)new StructuredSelection(elements));
        }
    }

    protected IAdaptable[] adaptElements(IAdaptable[] objects) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("", NO_ELEMENTS);
        workingSet.setId(this.getPageId());
        ((AbstractWorkingSet)workingSet).connect(workingSetManager);
        try {
            IAdaptable[] iAdaptableArray = workingSet.adaptElements(objects);
            return iAdaptableArray;
        }
        finally {
            ((AbstractWorkingSet)workingSet).disconnect();
        }
    }

    protected static IAdaptable[] getAdaptables(Object[] elements) {
        return ArrayUtil.elementsOfType((Object[])elements, (Class[])new Class[]{IAdaptable.class}).toArray(NO_ELEMENTS);
    }

    protected IAdaptable[] getInitialWorkingSetElements(IWorkingSet workingSet) {
        if (workingSet != null) {
            return workingSet.getElements();
        }
        IStructuredSelection selection = this.getInitialSelection();
        if (selection != null && !selection.isEmpty()) {
            return this.adaptElements(AbstractWorkingSetPage.getAdaptables(selection.toArray()));
        }
        return NO_ELEMENTS;
    }

    protected IAdaptable[] getFinalWorkingSetElements(IWorkingSet workingSet, IAdaptable[] elements) {
        return elements;
    }

    private void createTree(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(Messages.AbstractWorkingSetPage_workspace_content);
        this.tree = new TreeViewer(parent, 2818);
        this.tree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setComparator((ViewerComparator)new LabelComparator());
        this.tree.addFilter((ViewerFilter)new AddedElementsFilter());
        this.tree.setUseHashlookup(true);
        this.configureTree(this.tree);
        this.initializeTreeSelection(this.tree);
        this.treeContentProvider = (ITreeContentProvider)this.tree.getContentProvider();
    }

    private void createButtonBar(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText(Messages.AbstractWorkingSetPage_add_button);
        addButton.setEnabled(!this.tree.getSelection().isEmpty());
        final Button addAllButton = new Button(parent, 8);
        addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addAllButton.setText(Messages.AbstractWorkingSetPage_addAll_button);
        addAllButton.setEnabled(this.tree.getTree().getItems().length > 0);
        Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(Messages.AbstractWorkingSetPage_remove_button);
        removeButton.setEnabled(!this.table.getSelection().isEmpty());
        final Button removeAllButton = new Button(parent, 8);
        removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        removeAllButton.setText(Messages.AbstractWorkingSetPage_removeAll_button);
        removeAllButton.setEnabled(!this.selectedElements.isEmpty());
        this.tree.addSelectionChangedListener(event -> addButton.setEnabled(!event.getSelection().isEmpty()));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetPage.this.addTreeSelection();
                removeAllButton.setEnabled(true);
                addAllButton.setEnabled(AbstractWorkingSetPage.this.tree.getTree().getItems().length > 0);
            }
        });
        this.tree.addDoubleClickListener(event -> {
            this.addTreeSelection();
            removeAllButton.setEnabled(true);
            addAllButton.setEnabled(this.tree.getTree().getItems().length > 0);
        });
        this.table.addSelectionChangedListener(event -> removeButton.setEnabled(!event.getSelection().isEmpty()));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetPage.this.removeTableSelection();
                addAllButton.setEnabled(true);
                removeAllButton.setEnabled(!AbstractWorkingSetPage.this.selectedElements.isEmpty());
            }
        });
        this.table.addDoubleClickListener(event -> {
            this.removeTableSelection();
            addAllButton.setEnabled(true);
            removeAllButton.setEnabled(!this.selectedElements.isEmpty());
        });
        addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = AbstractWorkingSetPage.this.tree.getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    Object element = item.getData();
                    if (element instanceof IAdaptable) {
                        AbstractWorkingSetPage.this.selectedElements.add((IAdaptable)element);
                    }
                    ++n2;
                }
                AbstractWorkingSetPage.this.table.refresh();
                AbstractWorkingSetPage.this.tree.refresh();
                addAllButton.setEnabled(false);
                removeAllButton.setEnabled(true);
            }
        });
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetPage.this.selectedElements.clear();
                AbstractWorkingSetPage.this.table.refresh();
                AbstractWorkingSetPage.this.tree.refresh();
                removeAllButton.setEnabled(false);
                addAllButton.setEnabled(true);
            }
        });
    }

    private void addTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tree.getSelection();
        Object[] elements = AbstractWorkingSetPage.getAdaptables(selection.toArray());
        this.selectedElements.addAll(Arrays.asList(elements));
        this.table.add(elements);
        this.tree.remove(elements);
        this.table.setSelection((ISelection)selection);
        this.table.getControl().setFocus();
        this.validateInput();
    }

    private void removeTableSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        this.selectedElements.removeAll(selection.toList());
        Object[] selectedElements = selection.toArray();
        this.table.remove(selectedElements);
        try {
            this.tree.getTree().setRedraw(false);
            Object[] objectArray = selectedElements;
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                this.tree.refresh(this.treeContentProvider.getParent(selectedElement), true);
                ++n2;
            }
        }
        finally {
            this.tree.getTree().setRedraw(true);
        }
        this.tree.setSelection((ISelection)selection);
        this.tree.getControl().setFocus();
        this.validateInput();
    }

    private void createTable(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.AbstractWorkingSetPage_workingSet_content);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.table = new TableViewer(parent, 2818);
        GridData gd = new GridData(4, 4, true, true);
        this.table.getControl().setLayoutData((Object)gd);
        this.table.setComparator((ViewerComparator)new LabelComparator());
        this.table.setUseHashlookup(true);
        this.configureTable(this.table);
        this.table.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return AbstractWorkingSetPage.this.selectedElements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.workingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = Messages.AbstractWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.isEmpty()) {
            if (this.firstCheck) {
                this.setPageComplete(false);
                this.firstCheck = false;
                return;
            }
            errorMessage = Messages.AbstractWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.firstCheck = false;
        if (errorMessage == null && this.workingSet != null && !newText.equals(this.workingSet.getName())) {
            IWorkingSet[] workingSets;
            IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                if (newText.equals(workingSet.getName())) {
                    errorMessage = Messages.AbstractWorkingSetPage_warning_workingSetExists;
                }
                ++n2;
            }
        }
        if (!this.hasSelectedElement()) {
            infoMessage = Messages.AbstractWorkingSetPage_warning_elementMustBeChecked;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasSelectedElement() {
        return !this.selectedElements.isEmpty();
    }

    private void initializeSelectedElements() {
        this.selectedElements.clear();
        this.selectedElements.addAll(Arrays.asList(this.getInitialWorkingSetElements(this.workingSet)));
    }

    private class AddedElementsFilter
    extends ViewerFilter {
        private AddedElementsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !AbstractWorkingSetPage.this.selectedElements.contains(element);
        }
    }
}

