/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.inner;

import java.io.Serializable;
import java.util.List;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemReader;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.batch.api.partition.AbstractPartitionAnalyzer;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

public class PartitionRerunArtifacts {

    @Named(value="PartitionRerunArtifacts.B")
    public static class Batchlet
    extends AbstractBatchlet {
        @Inject
        @BatchProperty(name="force.failure2")
        String forceFailure2;
        @Inject
        StepContext stepCtx;

        public String process() {
            if (Boolean.parseBoolean(this.forceFailure2)) {
                throw new RuntimeException("Forcing failure for step2: " + this.stepCtx.getStepName());
            }
            return "true";
        }
    }

    @Named(value="PartitionRerunArtifacts.A")
    public static class Analyzer
    extends AbstractPartitionAnalyzer {
        @Inject
        JobContext jobCtx;

        public void analyzeCollectorData(Serializable data) throws Exception {
            if (this.jobCtx.getExitStatus() == null) {
                this.jobCtx.setExitStatus(data.toString() + ",");
            } else {
                this.jobCtx.setExitStatus(this.jobCtx.getExitStatus() + data.toString() + ",");
            }
        }
    }

    @Named(value="PartitionRerunArtifacts.C")
    public static class Collector
    implements PartitionCollector {
        @Inject
        StepContext stepCtx;

        public Serializable collectPartitionData() throws Exception {
            return Long.valueOf(this.stepCtx.getStepExecutionId());
        }
    }

    @Named(value="PartitionRerunArtifacts.W")
    public static class Writer
    extends AbstractItemWriter {
        public void writeItems(List<Object> items) {
        }
    }

    @Named(value="PartitionRerunArtifacts.R")
    public static class Reader
    extends AbstractItemReader {
        @Inject
        @BatchProperty(name="force.failure")
        String forceFailure;
        @Inject
        @BatchProperty(name="partition.num")
        String partitionNum;
        @Inject
        StepContext stepCtx;

        public Object readItem() {
            if (Boolean.parseBoolean(this.forceFailure) && this.partitionNum.charAt(0) == '1') {
                throw new RuntimeException("Forcing failure for step: " + this.stepCtx.getStepName());
            }
            return null;
        }
    }
}

