/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.specialized.BatchletUsingStepContextImpl;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import org.junit.BeforeClass;
import org.testng.Reporter;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExecuteTests {
    private static final Logger logger = Logger.getLogger(ExecuteTests.class.getName());
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ExecuteTests.handleException(METHOD, e);
        }
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @Test
    @org.junit.Test
    public void testMyStepContextBatchlet() throws Exception {
        String METHOD = "testMyStepContextBatchlet";
        try {
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("test_batchlet_stepCtx");
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecuteTests.handleException(METHOD, e);
        }
    }
}

