/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunktypes;

import jakarta.inject.Named;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

@Named(value="arrayIndexCheckpointData")
public class ArrayIndexCheckpointData
implements Externalizable {
    private static final Logger logger = Logger.getLogger(ArrayIndexCheckpointData.class.getName());
    private static final long serialVersionUID = 1L;
    private int i = 0;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.i = in.readInt();
        logger.fine("AJM: reading in the chkpt data: " + this.i);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        logger.fine("AJM: must have been checkpointed, writing out array index: " + this.i);
        out.writeInt(this.i);
    }

    public int getCurrentIndex() {
        logger.fine("AJM: current index = " + this.i);
        return this.i;
    }

    public void setCurrentIndex(int incoming_idx) {
        this.i = incoming_idx;
    }
}

