/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.managedobjects;

import jakarta.inject.Inject;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ManagedValueExtractorsTest
extends AbstractTCKTest {
    @Inject
    private Validator defaultValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ManagedValueExtractorsTest.webArchiveBuilder().withTestClassPackage(ManagedValueExtractorsTest.class)).withValidationXml("validation-ManagedValueExtractorsTest.xml")).withBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="d"), @SpecAssertion(section="integration-dependencyinjection-customconfiguration", id="a"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testValueExtractorsAreSubjectToDependencyInjection() {
        Assert.assertNotNull((Object)this.defaultValidator);
        Set violations = this.defaultValidator.validate((Object)Foo.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("property").containerElement("Hello from Greeter!", true, null, null, Map.class, 0), ConstraintViolationAssert.pathWith().property("property").containerElement("Hello from Greeter!", true, null, null, Map.class, 1));
    }

    private static class Foo {
        private final Map<@NotNull String, @NotNull String> property = new HashMap<String, String>();

        private Foo() {
        }

        private static Foo invalid() {
            Foo foo = new Foo();
            foo.property.put(null, null);
            return foo;
        }
    }
}

