/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.listener;

import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.cdi.tck.tests.context.session.listener.IntrospectServlet;
import org.jboss.cdi.tck.tests.context.session.listener.SimpleSessionBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebListener
public class TestHttpSessionListener
implements HttpSessionListener {
    private static final SimpleLogger logger = new SimpleLogger(TestHttpSessionListener.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleSessionBean simpleBean;

    public void sessionCreated(HttpSessionEvent se) {
        logger.log("Session {0} created...", se.getSession().getId());
        this.checkSessionContextActive();
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        logger.log("Session {0} destroyed...", se.getSession().getId());
        this.checkSessionContextActive();
    }

    private void checkSessionContextActive() throws IllegalStateException {
        try {
            if (!this.beanManager.getContext(SessionScoped.class).isActive() || this.simpleBean == null) {
                IntrospectServlet.isSessionScopeActive = false;
            }
            logger.log("Simple bean id: {0}", this.simpleBean.getId());
        }
        catch (Exception e) {
            IntrospectServlet.isSessionScopeActive = false;
        }
    }
}

