/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.interceptorbinding;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.interceptorbinding.Level;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.interceptorbinding.MissileInterceptor;
import org.jboss.cdi.tck.tests.extensions.beanManager.equivalence.interceptorbinding.MissileInterceptorBinding;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptorBindingEquivalenceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingEquivalenceTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{MissileInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_determining_hash", id="b")})
    public void testAreInterceptorBindingsEquivalent() {
        MissileInterceptorBinding literal1 = new MissileInterceptorBinding(){};
        MissileInterceptorBinding literal2 = new MissileInterceptorBinding(){

            @Override
            public int numberOfTargets() {
                return 7;
            }

            @Override
            public Level level() {
                return Level.B;
            }
        };
        Annotation containerProvided = this.getContainerProvidedInterceptorBinding(literal1);
        Assert.assertTrue((boolean)this.getCurrentManager().areInterceptorBindingsEquivalent((Annotation)literal1, containerProvided));
        Assert.assertFalse((boolean)this.getCurrentManager().areInterceptorBindingsEquivalent((Annotation)literal1, (Annotation)literal2));
        Assert.assertFalse((boolean)this.getCurrentManager().areInterceptorBindingsEquivalent(containerProvided, (Annotation)literal2));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_determining_hash", id="d")})
    public void testGetInterceptorBindingHashCode() {
        MissileInterceptorBinding literal1 = new MissileInterceptorBinding(){};
        MissileInterceptorBinding literal2 = new MissileInterceptorBinding(){

            @Override
            public String position() {
                return "hill";
            }
        };
        Annotation containerProvided = this.getContainerProvidedInterceptorBinding(literal1);
        Assert.assertEquals((int)this.getCurrentManager().getInterceptorBindingHashCode(containerProvided), (int)this.getCurrentManager().getInterceptorBindingHashCode((Annotation)literal1));
        Assert.assertNotEquals((Object)this.getCurrentManager().getInterceptorBindingHashCode((Annotation)literal1), (Object)this.getCurrentManager().getInterceptorBindingHashCode((Annotation)literal2));
        Assert.assertNotEquals((Object)this.getCurrentManager().getInterceptorBindingHashCode(containerProvided), (Object)this.getCurrentManager().getInterceptorBindingHashCode((Annotation)literal2));
    }

    private Annotation getContainerProvidedInterceptorBinding(Annotation literal) {
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{literal});
        Assert.assertFalse((boolean)interceptors.isEmpty());
        return (Annotation)((Interceptor)interceptors.get(0)).getInterceptorBindings().iterator().next();
    }
}

