/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.AbstractComponent;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.AlterableComponent;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.ApplicationScopedComponent;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.CustomAlterableContext;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.CustomScopeExtension;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.NonAlterableComponent;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal.RequestScopedComponent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class DestroyingNormalScopedInstanceTest
extends AbstractTest {
    private static final String[] VALUES = new String[]{"foo", "bar", "baz"};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DestroyingNormalScopedInstanceTest.class)).withExtension(CustomScopeExtension.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="o")})
    public void testApplicationScopedComponent(Instance<ApplicationScopedComponent> instance) {
        this.testComponent(instance);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="o")})
    public void testRequestScopedComponent(Instance<RequestScopedComponent> instance) {
        this.testComponent(instance);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="o")})
    public void testCustomScopedComponent(Instance<AlterableComponent> instance) {
        this.testComponent(instance);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    public void testNothingHappensIfNoInstanceToDestroy(ApplicationScopedComponent application) {
        Bean<ApplicationScopedComponent> bean = this.getUniqueBean(ApplicationScopedComponent.class, new Annotation[0]);
        AlterableContext context = (AlterableContext)this.getCurrentManager().getContext(bean.getScope());
        AbstractComponent.reset();
        application.setValue("value");
        context.destroy(bean);
        Assert.assertTrue((boolean)AbstractComponent.isDestroyed());
        context.destroy(bean);
        context.destroy(bean);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", expectedExceptions={UnsupportedOperationException.class})
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="p")})
    public void testUnsupportedOperationExceptionThrownIfUnderlyingContextNotAlterable(Instance<NonAlterableComponent> instance, CustomScopeExtension extension) {
        NonAlterableComponent component = (NonAlterableComponent)instance.get();
        instance.destroy((Object)component);
        Assert.fail((String)"expected exception not thrown");
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="o")})
    public void testContextDestroyCalled(Instance<AlterableComponent> instance) {
        AlterableComponent component = (AlterableComponent)instance.get();
        CustomAlterableContext.reset();
        instance.destroy((Object)component);
        Assert.assertTrue((boolean)CustomAlterableContext.isDestroyCalled());
    }

    @Test(expectedExceptions={NullPointerException.class}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="o")})
    public void testNullParameter(Instance<ApplicationScopedComponent> instance) {
        instance.destroy(null);
    }

    private <T extends AbstractComponent> void testComponent(Instance<T> instance) {
        for (String string : VALUES) {
            AbstractComponent reference = (AbstractComponent)instance.get();
            Assert.assertNull((Object)reference.getValue());
            reference.setValue(string);
            Assert.assertEquals((String)reference.getValue(), (String)string);
            AbstractComponent.reset();
            instance.destroy((Object)reference);
            Assert.assertTrue((boolean)AbstractComponent.isDestroyed());
            Assert.assertNull((Object)reference.getValue(), (String)reference.getValue());
        }
    }
}

