/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Transmission;
import ee.jakarta.tck.nosql.entities.Vehicle;
import ee.jakarta.tck.nosql.factories.VehicleSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The basic template operations with entity that contains enum")
public class BasicEnumFieldTemplateTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicEnumFieldTemplateTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=VehicleSupplier.class)
    @DisplayName(value="Should insert vehicle with enum: {0}")
    void shouldInsert(Vehicle entity) {
        Vehicle vehicle = (Vehicle)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)vehicle).isNotNull();
            soft.assertThat(vehicle.getId()).isNotNull();
            soft.assertThat(vehicle.getModel()).isEqualTo(entity.getModel());
            soft.assertThat((Comparable)((Object)vehicle.getTransmission())).isEqualTo((Object)entity.getTransmission());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleSupplier.class)
    @DisplayName(value="Should update vehicle with enum: {0}")
    void shouldUpdate(Vehicle entity) {
        Vehicle insertedVehicle = (Vehicle)this.template.insert((Object)entity);
        insertedVehicle.setTransmission(Transmission.AUTOMATIC);
        Vehicle updatedVehicle = (Vehicle)this.template.update((Object)insertedVehicle);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedVehicle).isNotNull();
            soft.assertThat((Comparable)((Object)updatedVehicle.getTransmission())).isEqualTo((Object)Transmission.AUTOMATIC);
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleSupplier.class)
    @DisplayName(value="Should delete vehicle with enum: {0}")
    void shouldDelete(Vehicle entity) {
        Vehicle insertedVehicle = (Vehicle)this.template.insert((Object)entity);
        this.template.delete(Vehicle.class, (Object)insertedVehicle.getId());
        Optional deletedVehicle = this.template.find(Vehicle.class, (Object)insertedVehicle.getId());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedVehicle).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleSupplier.class)
    @DisplayName(value="Should find vehicle with enum: {0}")
    void shouldFind(Vehicle entity) {
        Vehicle insertedVehicle = (Vehicle)this.template.insert((Object)entity);
        Optional foundVehicle = this.template.find(Vehicle.class, (Object)insertedVehicle.getId());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundVehicle).isPresent();
            soft.assertThat((Comparable)((Object)((Vehicle)foundVehicle.orElseThrow()).getTransmission())).isEqualTo((Object)insertedVehicle.getTransmission());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleSupplier.class)
    @DisplayName(value="Should insert vehicle with TTL")
    void shouldInsertWithTTL(Vehicle entity) {
        try {
            Vehicle insertedVehicle = (Vehicle)this.template.insert((Object)entity, Duration.ofMinutes(10L));
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat((Object)insertedVehicle).isNotNull();
                soft.assertThat(insertedVehicle.getId()).isNotNull();
                soft.assertThat(insertedVehicle.getModel()).isEqualTo(entity.getModel());
            });
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("TTL operation not supported by this database: " + e.getMessage());
        }
    }
}

