/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.processingexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -9156519616224592459L;

    public JAXRSClientIT() {
        this.setContextRoot("/jaxrs_api_rs_processingexception_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorWithRuntimeExceptionTest() throws JAXRSCommonClient.Fault {
        IllegalStateException ile = new IllegalStateException("TCK exception");
        ProcessingException mpe = new ProcessingException((Throwable)ile);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ile), (String)"getCause does not work for ProcessingException and RuntimeException cause");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(ile.toString()), (String)"getMessage does not work for ProcessingException and RuntimeException cause");
    }

    @Test
    public void constructorWithCheckedExceptionTest() throws JAXRSCommonClient.Fault {
        IOException ioe = new IOException("TCK exception");
        ProcessingException mpe = new ProcessingException((Throwable)ioe);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ioe), (String)"getCause does not work for ProcessingException and CheckedException cause");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(ioe.toString()), (String)"getMessage does not work for ProcessingException and CheckedException cause");
    }

    @Test
    public void constructorWithNullThrowableTest() throws JAXRSCommonClient.Fault {
        ProcessingException mpe = new ProcessingException((Throwable)null);
        Assertions.assertTrue((mpe.getCause() == null ? 1 : 0) != 0, (String)"getCause does not work for ProcessingException and null cause");
        Assertions.assertTrue((mpe.getMessage() == null ? 1 : 0) != 0, (String)"getMessage does not work for ProcessingException and null cause");
    }

    @Test
    public void constructorWithNullThrowableNullMessageTest() throws JAXRSCommonClient.Fault {
        ProcessingException mpe = new ProcessingException((String)null, (Throwable)null);
        Assertions.assertTrue((mpe.getCause() == null ? 1 : 0) != 0, (String)"getCause does not work for ProcessingException and null cause and null message");
        Assertions.assertTrue((mpe.getMessage() == null ? 1 : 0) != 0, (String)"getMessage does not work for ProcessingException and null cause and null message");
    }

    @Test
    public void constructorWithNullThrowableNotNullMessageTest() throws JAXRSCommonClient.Fault {
        String msg = "TCK Message";
        ProcessingException mpe = new ProcessingException(msg, (Throwable)null);
        Assertions.assertTrue((mpe.getCause() == null ? 1 : 0) != 0, (String)"getCause does not work for ProcessingException and null cause and not null message");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(msg), (String)"getMessage does not work for ProcessingException and null cause and not null message");
    }

    @Test
    public void constructorWithRuntimeExceptionNullMessageTest() throws JAXRSCommonClient.Fault {
        IllegalStateException ise = new IllegalStateException("JAXRS TCK exception");
        ProcessingException mpe = new ProcessingException((String)null, (Throwable)ise);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ise), (String)"getCause does not work for ProcessingException and RuntimeException and null message");
        Assertions.assertTrue((mpe.getMessage() == null ? 1 : 0) != 0, (String)"getMessage does not work for ProcessingException and RuntimeException and null message");
    }

    @Test
    public void constructorWithCheckedExceptionNullMessageTest() throws JAXRSCommonClient.Fault {
        IOException ioe = new IOException("JAXRS TCK exception");
        ProcessingException mpe = new ProcessingException((String)null, (Throwable)ioe);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ioe), (String)"getCause does not work for ProcessingException and CheckedException and null message");
        Assertions.assertTrue((mpe.getMessage() == null ? 1 : 0) != 0, (String)"getMessage does not work for ProcessingException and CheckedException and null message");
    }

    @Test
    public void constructorWithRuntimeExceptionAndNotNullMessageTest() throws JAXRSCommonClient.Fault {
        String msg = "TCK Message";
        IllegalStateException ise = new IllegalStateException("JAXRS TCK exception");
        ProcessingException mpe = new ProcessingException(msg, (Throwable)ise);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ise), (String)"getCause does not work for ProcessingException and RuntimeException and not null message");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(msg), (String)"getMessage does not work for ProcessingException and RuntimeException and not null message");
    }

    @Test
    public void constructorWithCheckedExceptionAndNotNullMessageTest() throws JAXRSCommonClient.Fault {
        String msg = "TCK Message";
        IOException ioe = new IOException("JAXRS TCK exception");
        ProcessingException mpe = new ProcessingException(msg, (Throwable)ioe);
        Assertions.assertTrue((boolean)mpe.getCause().equals(ioe), (String)"getCause does not work for ProcessingException and CheckedException and not null message");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(msg), (String)"getMessage does not work for ProcessingException and CheckedException and not null message");
    }

    @Test
    public void constructorWithNotNullMessageTest() throws JAXRSCommonClient.Fault {
        String msg = "TCK Message";
        ProcessingException mpe = new ProcessingException(msg);
        Assertions.assertTrue((mpe.getCause() == null ? 1 : 0) != 0, (String)"getCause does not work for ProcessingException and not null message");
        Assertions.assertTrue((boolean)mpe.getMessage().equals(msg), (String)"getMessage does not work for ProcessingException and not null message");
    }

    @Test
    public void constructorWithNullMessageTest() throws JAXRSCommonClient.Fault {
        ProcessingException mpe = new ProcessingException((String)null);
        Assertions.assertTrue((mpe.getCause() == null ? 1 : 0) != 0, (String)"getCause does not work for ProcessingException and null message");
        Assertions.assertTrue((mpe.getMessage() == null ? 1 : 0) != 0, (String)"getMessage does not work for ProcessingException and null message");
    }
}

