/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.january.form.DiscreteEntry;
import org.eclipse.january.form.IEntryVisitor;

@XmlRootElement(name="FileEntry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FileEntry
extends DiscreteEntry
implements IResourceChangeListener {
    @XmlTransient
    protected IFile file;
    @XmlTransient
    protected IProject project;
    @XmlAttribute
    private String fileExtension;

    public FileEntry() {
        this.fileExtension = "";
    }

    public FileEntry(String fileType) {
        this.fileExtension = fileType;
    }

    public FileEntry(String ... files) {
        super(files);
        this.contextId = "org.eclipse.ice.client.widgets.FileEntry";
    }

    @Override
    public Object clone() {
        FileEntry entry = new FileEntry();
        entry.copy(this);
        return entry;
    }

    public void setProject(IProject projectSpace) {
        if (projectSpace != null) {
            this.project = projectSpace;
            this.generateAllowedValues();
            this.isModified = true;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    @Override
    public boolean setValue(String newValue) {
        if (super.setValue(newValue)) {
            if (this.project != null) {
                this.file = this.project.getFile(newValue);
            }
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public String getAbsoluteFilePath() {
        if (this.file != null) {
            return this.file.getLocation().toOSString();
        }
        return null;
    }

    @Override
    public boolean setValue(String ... values) {
        throw new UnsupportedOperationException("FileEntry only supports the storage of one String value, not many, selected from a list of files in the IProject space. Therefore, this operation is not supported.");
    }

    private void generateAllowedValues() {
        ArrayList<String> files = null;
        ArrayList<String> allFiles = null;
        if (this.project != null && this.project.isAccessible()) {
            allFiles = new ArrayList<String>();
            try {
                IResource[] resources = this.project.members();
                int i = 0;
                while (i < resources.length) {
                    if (resources[i].getType() == 1 && !resources[i].getName().startsWith(".")) {
                        allFiles.add(resources[i].getName());
                    }
                    ++i;
                }
                if (this.fileExtension != null && !this.fileExtension.isEmpty()) {
                    files = new ArrayList();
                    int size = allFiles.size();
                    int i2 = 0;
                    while (i2 < size) {
                        String fileName = (String)allFiles.get(i2);
                        if (fileName.endsWith(this.fileExtension)) {
                            files.add(fileName);
                        }
                        ++i2;
                    }
                } else {
                    files = allFiles;
                }
            }
            catch (CoreException e) {
                this.logger.info("FileEntry Message: Unable to load project files!");
                this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
            }
        }
        this.allowedValues = files;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject != null && otherObject instanceof FileEntry) {
            if (!super.equals(otherObject)) {
                return false;
            }
            FileEntry otherEntry = (FileEntry)otherObject;
            if (this.fileExtension.equals(otherEntry.fileExtension)) {
                return true;
            }
        }
        return false;
    }

    public void copy(FileEntry entity) {
        if (entity == null) {
            return;
        }
        super.copy(entity);
        this.allowedValues = entity.allowedValues;
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.fileExtension.hashCode();
        return hash;
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.visit(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.project != null && event.getType() == 1) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IProject p = delta.getResource().getProject();
                        if (p != null && p.getName().equals(FileEntry.this.project.getName())) {
                            FileEntry.this.generateAllowedValues();
                            FileEntry.this.notifyListeners();
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

