/**
 * generated by Xtext 2.9.1
 */
package org.eclipse.january.geometry.xtext.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.january.geometry.xtext.iGES.Data;
import org.eclipse.january.geometry.xtext.iGES.End;
import org.eclipse.january.geometry.xtext.iGES.Entry;
import org.eclipse.january.geometry.xtext.iGES.Global;
import org.eclipse.january.geometry.xtext.iGES.HString;
import org.eclipse.january.geometry.xtext.iGES.IGES;
import org.eclipse.january.geometry.xtext.iGES.PEntry;
import org.eclipse.january.geometry.xtext.iGES.Param;
import org.eclipse.january.geometry.xtext.iGES.Parameters;
import org.eclipse.january.geometry.xtext.iGES.Pointer;
import org.eclipse.january.geometry.xtext.iGES.Start;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#label-provider
 */
@SuppressWarnings("all")
public class IGESLabelProvider extends DefaultEObjectLabelProvider {
  @Inject
  public IGESLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  public String text(final IGES iges) {
    return "IGES file data";
  }
  
  public String text(final Start start) {
    return "Start Section";
  }
  
  public String text(final Global global) {
    return "Global params";
  }
  
  public String text(final Data data) {
    return "Data Entries";
  }
  
  public String text(final Parameters param) {
    return "Parameter Data";
  }
  
  public String text(final End end) {
    return "End Section";
  }
  
  public String text(final Entry e) {
    int _type = e.getType();
    String _typeName = this.getTypeName(_type);
    return (_typeName + " definition");
  }
  
  public String text(final PEntry e) {
    int _type = e.getType();
    String _typeName = this.getTypeName(_type);
    return (_typeName + " data");
  }
  
  public String text(final HString str) {
    String hol = str.getVal();
    int _indexOf = hol.indexOf("H");
    int _plus = (_indexOf + 1);
    return hol.substring(_plus);
  }
  
  public String text(final Pointer p) {
    int _val = p.getVal();
    return Integer.toString(_val);
  }
  
  public String text(final Param p) {
    double _val = p.getVal();
    return Double.toString(_val);
  }
  
  public String getTypeName(final int type) {
    String _switchResult = null;
    switch (type) {
      case 100:
        _switchResult = "Circular Arc";
        break;
      case 102:
        _switchResult = "Composite Curve";
        break;
      case 104:
        _switchResult = "Conic Arc";
        break;
      case 106:
        _switchResult = "Copious Data";
        break;
      case 108:
        _switchResult = "Plane";
        break;
      case 110:
        _switchResult = "Line";
        break;
      case 112:
        _switchResult = "P. Spline Curve";
        break;
      case 114:
        _switchResult = "P. Spline Surface";
        break;
      case 116:
        _switchResult = "Point";
        break;
      case 118:
        _switchResult = "Ruled Surface";
        break;
      case 120:
        _switchResult = "Surface of Revolution";
        break;
      case 122:
        _switchResult = "Tabulated Cylinder";
        break;
      case 123:
        _switchResult = "Direction";
        break;
      case 124:
        _switchResult = "Transformation Matrix";
        break;
      case 126:
        _switchResult = "Rat. B-Spline Curve";
        break;
      case 128:
        _switchResult = "Rat. B-Spline Surface";
        break;
      case 130:
        _switchResult = "Offset Curve";
        break;
      case 140:
        _switchResult = "Offset Surface";
        break;
      case 141:
        _switchResult = "Boundary";
        break;
      case 142:
        _switchResult = "Curve on a P. Surface";
        break;
      case 143:
        _switchResult = "Bounded Surface";
        break;
      case 144:
        _switchResult = "Trimmed Surface";
        break;
      case 150:
        _switchResult = "Block";
        break;
      case 152:
        _switchResult = "Right Angular Wedge";
        break;
      case 154:
        _switchResult = "Right Circ. Cylinder";
        break;
      case 156:
        _switchResult = "Right Circular Cone";
        break;
      case 158:
        _switchResult = "Sphere";
        break;
      case 160:
        _switchResult = "Torus";
        break;
      case 162:
        _switchResult = "Solid of Revolution";
        break;
      case 164:
        _switchResult = "Solid of L. Extrusion";
        break;
      case 168:
        _switchResult = "Ellipsoid";
        break;
      case 180:
        _switchResult = "Boolean Tree";
        break;
      case 186:
        _switchResult = "M. Solid B-Rep Object";
        break;
      case 190:
        _switchResult = "Plane Surface";
        break;
      case 192:
        _switchResult = "Right Cir. Cyl. Surface";
        break;
      case 194:
        _switchResult = "Right Cir. Con. Surface";
        break;
      case 196:
        _switchResult = "Spherical Surface";
        break;
      case 198:
        _switchResult = "Toroidal Surface";
        break;
      case 308:
        _switchResult = "Subfigure Definition";
        break;
      case 314:
        _switchResult = "Color definition";
        break;
      case 408:
        _switchResult = "Sing. Subfigure Instance";
        break;
      case 502:
        _switchResult = "Vertex List";
        break;
      case 504:
        _switchResult = "Edge List";
        break;
      case 508:
        _switchResult = "Loop";
        break;
      case 510:
        _switchResult = "Face";
        break;
      case 514:
        _switchResult = "Shell";
        break;
      default:
        _switchResult = "Unknown Entity";
        break;
    }
    return _switchResult;
  }
}
