/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.BinaryOperation;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.SingleInputBroadcastIterator;
import org.eclipse.january.dataset.UnaryOperation;

public class Operations {
    public static StringBuilder bracketIfNecessary(String a) {
        String name = a.trim();
        StringBuilder newName = new StringBuilder(name);
        if (name.contains("+") || name.contains("-") || name.contains("*") || name.contains("/") || name.contains("%") || name.contains("^") || name.contains("'")) {
            newName.insert(0, '(');
            newName.append(')');
        }
        return newName;
    }

    public static String createBinaryOperationName(String operator, String a, String b) {
        StringBuilder newName = Operations.bracketIfNecessary(a).append(operator).append((CharSequence)Operations.bracketIfNecessary(b));
        return newName.toString();
    }

    public static String createFunctionName(String function, String ... arguments) {
        StringBuilder name = new StringBuilder(function);
        name.append('(');
        int length = arguments.length - 1;
        int i = 0;
        while (i < length) {
            name.append(arguments[i]);
            name.append(", ");
            ++i;
        }
        name.append(arguments[length]);
        name.append(')');
        return name.toString();
    }

    private static long toLong(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return 0L;
        }
        return (long)d;
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset operate(UnaryOperation op, Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true, true, false);
        result = it.getOutput();
        it.setOutputDouble(result.hasFloatingPointElements() != false || da.isComplex() != false);
        is = result.getElementsPerItem();
        dt = result.getDType();
        as = da.getElementsPerItem();
        switch (dt) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        bdata[it.oIndex] = op.booleanOperate(it.aLong);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        v0 = bdata[it.oIndex] = z[0] != 0.0;
                    }
                }
                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        i8data[it.oIndex] = (byte)op.longOperate(it.aLong);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        i8data[it.oIndex] = (byte)Operations.toLong(z[0]);
                    }
                }
                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        i16data[it.oIndex] = (short)op.longOperate(it.aLong);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        i16data[it.oIndex] = (short)Operations.toLong(z[0]);
                    }
                }
                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        i32data[it.oIndex] = (int)op.longOperate(it.aLong);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        i32data[it.oIndex] = (int)Operations.toLong(z[0]);
                    }
                }
                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        i64data[it.oIndex] = op.longOperate(it.aLong);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        i64data[it.oIndex] = Operations.toLong(z[0]);
                    }
                }
                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ox = (byte)op.longOperate(it.aLong);
                            j = 0;
                            while (j < is) {
                                ai8data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong);
                            j = 1;
                            while (j < ms) {
                                ai8data[it.oIndex + j] = (byte)op.longOperate(da.getElementLongAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = (byte)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai8data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ox = (short)op.longOperate(it.aLong);
                            j = 0;
                            while (j < is) {
                                ai16data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong);
                            j = 1;
                            while (j < ms) {
                                ai16data[it.oIndex + j] = (short)op.longOperate(da.getElementLongAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = (short)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai16data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ox = (int)op.longOperate(it.aLong);
                            j = 0;
                            while (j < is) {
                                ai32data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong);
                            j = 1;
                            while (j < ms) {
                                ai32data[it.oIndex + j] = (int)op.longOperate(da.getElementLongAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = (int)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai32data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ox = op.longOperate(it.aLong);
                            j = 0;
                            while (j < is) {
                                ai64data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong);
                            j = 1;
                            while (j < ms) {
                                ai64data[it.oIndex + j] = op.longOperate(da.getElementLongAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai64data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        f32data[it.oIndex] = (float)op.doubleOperate(it.aDouble);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        f32data[it.oIndex] = (float)z[0];
                    }
                }
                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                if (!da.isComplex()) {
                    while (it.hasNext()) {
                        f64data[it.oIndex] = op.doubleOperate(it.aDouble);
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        f64data[it.oIndex] = z[0];
                    }
                }
                break;
            }
            case 500: {
                af32data = ((CompoundFloatDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ox = (float)op.doubleOperate(it.aDouble);
                            j = 0;
                            while (j < is) {
                                af32data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble);
                            j = 1;
                            while (j < ms) {
                                af32data[it.oIndex + j] = (float)op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = (float)z[0];
                        j = 0;
                        while (j < is) {
                            af32data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 600: {
                af64data = ((CompoundDoubleDataset)result).getData();
                if (!da.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble);
                        }
                    } else if (as == 1) {
                        while (it.hasNext()) {
                            ix = it.aDouble;
                            ox = op.doubleOperate(ix);
                            j = 0;
                            while (j < is) {
                                af64data[it.oIndex + j] = ox;
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble);
                            j = 1;
                            while (j < ms) {
                                af64data[it.oIndex + j] = op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j));
                                ++j;
                            }
                        }
                    }
                } else {
                    z = new double[2];
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                        ox = z[0];
                        j = 0;
                        while (j < is) {
                            af64data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                }
                break;
            }
            case 7: {
                c64data = ((ComplexFloatDataset)result).getData();
                z = new double[2];
                if (da.isComplex()) ** GOTO lbl347
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0);
                    c64data[it.oIndex] = (float)z[0];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                    c64data[it.oIndex] = (float)z[0];
                    c64data[it.oIndex + 1] = (float)z[1];
lbl347:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl348:
                // 1 sources

                break;
            }
            case 8: {
                c128data = ((ComplexDoubleDataset)result).getData();
                z = new double[2];
                if (da.isComplex()) ** GOTO lbl361
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0);
                    c128data[it.oIndex] = z[0];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                    c128data[it.oIndex] = z[0];
                    c128data[it.oIndex + 1] = z[1];
lbl361:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl362:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("operate does not support this dataset type");
            }
        }
        result.setName(op.toString(da.getName()));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset operate(BinaryOperation op, Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        result = it.getOutput();
        it.setOutputDouble(result.hasFloatingPointElements() != false || da.isComplex() != false || db.isComplex() != false);
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        switch (result.getDType()) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        bdata[it.oIndex] = op.booleanOperate(it.aLong, it.aLong);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        v0 = bdata[it.oIndex] = z[0] != 0.0;
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl32
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    v1 = bdata[it.oIndex] = z[0] != 0.0;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    v2 = bdata[it.oIndex] = z[0] != 0.0;
lbl32:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl33:
                // 1 sources

                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        i8data[it.oIndex] = (byte)op.longOperate(it.aLong, it.aLong);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        i8data[it.oIndex] = (byte)Operations.toLong(z[0]);
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl56
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i8data[it.oIndex] = (byte)Operations.toLong(z[0]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i8data[it.oIndex] = (byte)Operations.toLong(z[0]);
lbl56:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl57:
                // 1 sources

                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        i16data[it.oIndex] = (short)op.longOperate(it.aLong, it.aLong);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        i16data[it.oIndex] = (short)Operations.toLong(z[0]);
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl80
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i16data[it.oIndex] = (short)Operations.toLong(z[0]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i16data[it.oIndex] = (short)Operations.toLong(z[0]);
lbl80:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl81:
                // 1 sources

                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        i32data[it.oIndex] = (int)op.longOperate(it.aLong, it.aLong);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        i32data[it.oIndex] = (int)Operations.toLong(z[0]);
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl104
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i32data[it.oIndex] = (int)Operations.toLong(z[0]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i32data[it.oIndex] = (int)Operations.toLong(z[0]);
lbl104:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl105:
                // 1 sources

                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        i64data[it.oIndex] = op.longOperate(it.aLong, it.aLong);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        i64data[it.oIndex] = Operations.toLong(z[0]);
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl128
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i64data[it.oIndex] = Operations.toLong(z[0]);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    i64data[it.oIndex] = Operations.toLong(z[0]);
lbl128:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl129:
                // 1 sources

                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong, it.bLong);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai8data[it.oIndex + j] = (byte)op.longOperate(it.aLong, db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai8data[it.oIndex + j] = (byte)op.longOperate(da.getElementLongAbs(it.aIndex + j), it.bLong);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            ai8data[it.oIndex] = (byte)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai8data[it.oIndex + j] = (byte)op.longOperate(da.getElementLongAbs(it.aIndex + j), db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = (byte)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai8data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl200
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (byte)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (byte)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl200:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl201:
                // 1 sources

                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong, it.bLong);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai16data[it.oIndex + j] = (short)op.longOperate(it.aLong, db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai16data[it.oIndex + j] = (short)op.longOperate(da.getElementLongAbs(it.aIndex + j), it.bLong);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            ai16data[it.oIndex] = (short)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai16data[it.oIndex + j] = (short)op.longOperate(da.getElementLongAbs(it.aIndex + j), db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = (short)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai16data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl272
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (short)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (short)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl272:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl273:
                // 1 sources

                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong, it.bLong);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai32data[it.oIndex + j] = (int)op.longOperate(it.aLong, db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai32data[it.oIndex + j] = (int)op.longOperate(da.getElementLongAbs(it.aIndex + j), it.bLong);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            ai32data[it.oIndex] = (int)op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai32data[it.oIndex + j] = (int)op.longOperate(da.getElementLongAbs(it.aIndex + j), db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = (short)Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai32data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl344
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (short)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (short)Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl344:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl345:
                // 1 sources

                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong, it.bLong);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai64data[it.oIndex + j] = op.longOperate(it.aLong, db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai64data[it.oIndex + j] = op.longOperate(da.getElementLongAbs(it.aIndex + j), it.bLong);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            ai64data[it.oIndex] = op.longOperate(it.aLong, it.bLong);
                            j = 1;
                            while (j < ms) {
                                ai64data[it.oIndex + j] = op.longOperate(da.getElementLongAbs(it.aIndex + j), db.getElementLongAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = Operations.toLong(z[0]);
                        j = 0;
                        while (j < is) {
                            ai64data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl416
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = Operations.toLong(z[0]);
                    j = 0;
                    while (j < is) {
                        ai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl416:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl417:
                // 1 sources

                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        f32data[it.oIndex] = (float)op.doubleOperate(it.aDouble, it.bDouble);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        f32data[it.oIndex] = (float)z[0];
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl440
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    f32data[it.oIndex] = (float)z[0];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    f32data[it.oIndex] = (float)z[0];
lbl440:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl441:
                // 1 sources

                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    while (it.hasNext()) {
                        f64data[it.oIndex] = op.doubleOperate(it.aDouble, it.bDouble);
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        f64data[it.oIndex] = z[0];
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl464
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    f64data[it.oIndex] = z[0];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    f64data[it.oIndex] = z[0];
lbl464:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl465:
                // 1 sources

                break;
            }
            case 500: {
                af32data = ((CompoundFloatDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble, it.bDouble);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af32data[it.oIndex + j] = (float)op.doubleOperate(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af32data[it.oIndex + j] = (float)op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            af32data[it.oIndex] = (float)op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af32data[it.oIndex + j] = (float)op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = (float)z[0];
                        j = 0;
                        while (j < is) {
                            af32data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl536
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (float)z[0];
                    j = 0;
                    while (j < is) {
                        af32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = (float)z[0];
                    j = 0;
                    while (j < is) {
                        af32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl536:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl537:
                // 1 sources

                break;
            }
            case 600: {
                af64data = ((CompoundDoubleDataset)result).getData();
                if (!da.isComplex() && !db.isComplex()) {
                    if (is == 1) {
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble, it.bDouble);
                        }
                    } else if (as == 1 && bs != 1) {
                        ms = Math.min(is, bs);
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af64data[it.oIndex + j] = op.doubleOperate(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    } else if (as != 1 && bs == 1) {
                        ms = Math.min(is, as);
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af64data[it.oIndex + j] = op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                                ++j;
                            }
                        }
                    } else {
                        ms = Math.min(is, Math.min(as, bs));
                        while (it.hasNext()) {
                            af64data[it.oIndex] = op.doubleOperate(it.aDouble, it.bDouble);
                            j = 1;
                            while (j < ms) {
                                af64data[it.oIndex + j] = op.doubleOperate(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                                ++j;
                            }
                        }
                    }
                    break;
                }
                z = new double[2];
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        ox = z[0];
                        j = 0;
                        while (j < is) {
                            af64data[it.oIndex + j] = ox;
                            ++j;
                        }
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl608
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = z[0];
                    j = 0;
                    while (j < is) {
                        af64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    ox = z[0];
                    j = 0;
                    while (j < is) {
                        af64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl608:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl609:
                // 1 sources

                break;
            }
            case 7: {
                c64data = ((ComplexFloatDataset)result).getData();
                z = new double[2];
                if (!da.isComplex() && !db.isComplex()) ** GOTO lbl636
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        c64data[it.oIndex] = (float)z[0];
                        c64data[it.oIndex + 1] = (float)z[1];
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl631
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    c64data[it.oIndex] = (float)z[0];
                    c64data[it.oIndex + 1] = (float)z[1];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    c64data[it.oIndex] = (float)z[0];
                    c64data[it.oIndex + 1] = (float)z[1];
lbl631:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl632:
                // 1 sources

                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, 0.0);
                    c64data[it.oIndex] = (float)z[0];
                    c64data[it.oIndex + 1] = (float)z[1];
lbl636:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl637:
                // 1 sources

                break;
            }
            case 8: {
                c128data = ((ComplexDoubleDataset)result).getData();
                z = new double[2];
                if (!da.isComplex() && !db.isComplex()) ** GOTO lbl664
                if (!db.isComplex()) {
                    while (it.hasNext()) {
                        op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, 0.0);
                        c128data[it.oIndex] = z[0];
                        c128data[it.oIndex + 1] = z[1];
                    }
                    break;
                }
                if (da.isComplex()) ** GOTO lbl659
                while (it.hasNext()) {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    c128data[it.oIndex] = z[0];
                    c128data[it.oIndex + 1] = z[1];
                }
                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, da.getElementDoubleAbs(it.aIndex + 1), it.bDouble, db.getElementDoubleAbs(it.bIndex + 1));
                    c128data[it.oIndex] = z[0];
                    c128data[it.oIndex + 1] = z[1];
lbl659:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl660:
                // 1 sources

                break;
lbl-1000:
                // 1 sources

                {
                    op.complexOperate(z, it.aDouble, 0.0, it.bDouble, 0.0);
                    c128data[it.oIndex] = z[0];
                    c128data[it.oIndex + 1] = z[1];
lbl664:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl665:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("operate does not support this dataset type");
            }
        }
        result.setName(op.toString(da.getName(), db.getName()));
        return result;
    }

    public static class Addition
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L || b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a + b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a + b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra + rb;
            out[1] = ia + ib;
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "+";
        }
    }

    public static class Division
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L && b == 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return b == 0L ? 0L : a / b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a / b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            if (ib == 0.0) {
                out[0] = ra / rb;
                out[1] = ia / rb;
            } else if (rb == 0.0) {
                out[0] = ia / ib;
                out[1] = -ra / ib;
            } else if (Math.abs(rb) < Math.abs(ib)) {
                double q = rb / ib;
                double den = rb * q + ib;
                out[0] = (ra * q + ia) / den;
                out[1] = (ia * q - rb) / den;
            } else {
                double q = ib / rb;
                double den = ib * q + rb;
                out[0] = (ia * q + ra) / den;
                out[1] = (ia - ra * q) / den;
            }
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "/";
        }
    }

    public static class DivisionTowardsFloor
    extends Division {
        @Override
        public long longOperate(long a, long b) {
            if (b == 0L) {
                return 0L;
            }
            long ox = a / b;
            if (a != ox * b && a < 0L ^ b < 0L) {
                --ox;
            }
            return ox;
        }
    }

    public static class DivisionWithZero
    extends Division {
        @Override
        public double doubleOperate(double a, double b) {
            return b == 0.0 ? 0.0 : a / b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            if (ib == 0.0) {
                if (rb == 0.0) {
                    out[0] = 0.0;
                    out[1] = 0.0;
                } else {
                    out[0] = ra / rb;
                    out[1] = ia / rb;
                }
            } else if (rb == 0.0) {
                out[0] = ia / ib;
                out[1] = -ra / ib;
            } else if (Math.abs(rb) < Math.abs(ib)) {
                double q = rb / ib;
                double den = rb * q + ib;
                out[0] = (ra * q + ia) / den;
                out[1] = (ia * q - rb) / den;
            } else {
                double q = ib / rb;
                double den = ib * q + rb;
                out[0] = (ia * q + ra) / den;
                out[1] = (ia - ra * q) / den;
            }
        }
    }

    public static class Exponentiation
    extends BinaryOperation.Stub {
        @Override
        public double doubleOperate(double a, double b) {
            return Math.pow(a, b);
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            Complex c = new Complex(ra, ia);
            c = ib == 0.0 ? c.pow(rb) : c.pow(new Complex(rb, ib));
            out[0] = c.getReal();
            out[1] = c.getImaginary();
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "**";
        }
    }

    public static class Maximum
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a > b ? a != 0L : b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a > b ? a : b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a > b ? a : b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("select greater than does not support complex numbers");
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createFunctionName(this.toString(), a, b);
        }

        public String toString() {
            return "max";
        }
    }

    public static class Minimum
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a < b ? a != 0L : b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a < b ? a : b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a < b ? a : b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("select less than does not support complex numbers");
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createFunctionName(this.toString(), a, b);
        }

        public String toString() {
            return "min";
        }
    }

    public static class Multiplication
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L && b != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a * b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a * b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra * rb - ia * ib;
            out[1] = ra * ib + ia * rb;
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "*";
        }
    }

    public static class Negation
    implements UnaryOperation {
        @Override
        public boolean booleanOperate(long a) {
            return a == 0L;
        }

        @Override
        public long longOperate(long a) {
            return -a;
        }

        @Override
        public double doubleOperate(double a) {
            return -a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia) {
            out[0] = -ra;
            out[1] = -ia;
        }

        @Override
        public String toString(String a) {
            return Operations.createFunctionName(this.toString(), a);
        }

        public String toString() {
            return "-";
        }
    }

    public static class Remainder
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            throw new IllegalArgumentException("remainder does not support booleans");
        }

        @Override
        public long longOperate(long a, long b) {
            return b == 0L ? 0L : a % b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a % b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("remainder does not support complex numbers");
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "%";
        }
    }

    public static class Subtraction
    implements BinaryOperation {
        @Override
        public boolean booleanOperate(long a, long b) {
            return a != 0L || b == 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a - b;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a - b;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            out[0] = ra - rb;
            out[1] = ia - ib;
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }

        public String toString() {
            return "-";
        }
    }

    public static class UseBase
    implements BinaryOperation {
        protected boolean br;
        protected long lr;
        protected double dr;

        UseBase(boolean br, long lr, double dr) {
            this.br = br;
            this.lr = lr;
            this.dr = dr;
        }

        UseBase(Number r) {
            this.br = r.intValue() != 0;
            this.lr = r.longValue();
            this.dr = r.doubleValue();
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return false;
        }

        @Override
        public long longOperate(long a, long b) {
            return 0L;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return 0.0;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
        }

        @Override
        public String toString(String a, String b) {
            return Operations.createBinaryOperationName(this.toString(), a, b);
        }
    }

    public static class UseIfEqualTo
    extends UseBase {
        private double di;

        public UseIfEqualTo(boolean br, long lr, double dr, double di) {
            super(br, lr, dr);
            this.di = di;
        }

        public UseIfEqualTo(Number r) {
            super(r);
            this.di = 0.0;
        }

        public UseIfEqualTo(Complex z) {
            super(z.getReal());
            this.di = z.getImaginary();
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return a == b ? this.br : a != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a == b ? this.lr : a;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a == b ? this.dr : a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            if (ra == rb && ia == ib) {
                out[0] = this.dr;
                out[1] = this.di;
            } else {
                out[0] = ra;
                out[1] = ia;
            }
        }

        public String toString() {
            return "==";
        }
    }

    public static class UseIfGreaterThan
    extends UseBase {
        public UseIfGreaterThan(boolean br, long lr, double dr) {
            super(br, lr, dr);
        }

        public UseIfGreaterThan(Number r) {
            super(r);
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return a > b ? this.br : a != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a > b ? this.lr : a;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a > b ? this.dr : a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("replace greater than does not support complex numbers");
        }

        public String toString() {
            return ">";
        }
    }

    public static class UseIfGreaterThanOrEqualTo
    extends UseBase {
        public UseIfGreaterThanOrEqualTo(boolean br, long lr, double dr) {
            super(br, lr, dr);
        }

        public UseIfGreaterThanOrEqualTo(Number r) {
            super(r);
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return a >= b ? this.br : a != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a >= b ? this.lr : a;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a >= b ? this.dr : a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("replace greater than or equal to does not support complex numbers");
        }

        public String toString() {
            return ">";
        }
    }

    public static class UseIfLessThan
    extends UseBase {
        public UseIfLessThan(boolean br, long lr, double dr) {
            super(br, lr, dr);
        }

        public UseIfLessThan(Number r) {
            super(r);
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return a < b ? this.br : a != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a < b ? this.lr : a;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a < b ? this.dr : a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("replace less than does not support complex numbers");
        }

        public String toString() {
            return "<";
        }
    }

    public static class UseIfLessThanOrEqualTo
    extends UseBase {
        public UseIfLessThanOrEqualTo(boolean br, long lr, double dr) {
            super(br, lr, dr);
        }

        public UseIfLessThanOrEqualTo(Number r) {
            super(r);
        }

        @Override
        public boolean booleanOperate(long a, long b) {
            return a <= b ? this.br : a != 0L;
        }

        @Override
        public long longOperate(long a, long b) {
            return a <= b ? this.lr : a;
        }

        @Override
        public double doubleOperate(double a, double b) {
            return a <= b ? this.dr : a;
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia, double rb, double ib) {
            throw new IllegalArgumentException("replace less than or equal to does not support complex numbers");
        }

        public String toString() {
            return "<=";
        }
    }
}

