/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net.util;

import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(NetworkUtil.class);

    public static String calculateNetwork(String ipAddress, String netmask) {
        int ipAddressValue = 0;
        int netmaskValue = 0;
        StringTokenizer st = new StringTokenizer(ipAddress, ".");
        int i = 24;
        while (i >= 0) {
            ipAddressValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        st = new StringTokenizer(netmask, ".");
        i = 24;
        while (i >= 0) {
            netmaskValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        int network = ipAddressValue & netmaskValue;
        return NetworkUtil.dottedQuad(network);
    }

    public static String calculateBroadcast(String ipAddress, String netmask) {
        int ipAddressValue = 0;
        int netmaskValue = 0;
        StringTokenizer st = new StringTokenizer(ipAddress, ".");
        int i = 24;
        while (i >= 0) {
            ipAddressValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        st = new StringTokenizer(netmask, ".");
        i = 24;
        while (i >= 0) {
            netmaskValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        int network = ipAddressValue | ~netmaskValue;
        return NetworkUtil.dottedQuad(network);
    }

    public static String getNetmaskStringForm(int prefix) throws KuraException {
        if (prefix >= 0 && prefix <= 32) {
            int mask = ~((1 << 32 - prefix) - 1);
            return NetworkUtil.dottedQuad(mask);
        }
        throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"invalid prefix "});
    }

    public static short getNetmaskShortForm(String netmask) throws KuraException {
        if (netmask == null) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"netmask is null"});
        }
        int netmaskValue = 0;
        StringTokenizer st = new StringTokenizer(netmask, ".");
        int i = 24;
        while (i >= 0) {
            netmaskValue |= Integer.parseInt(st.nextToken()) << i;
            i -= 8;
        }
        boolean hitZero = false;
        int displayMask = Integer.MIN_VALUE;
        int count = 0;
        int c = 1;
        while (c <= 32) {
            if ((netmaskValue & displayMask) == 0) {
                hitZero = true;
            } else {
                if (hitZero) {
                    s_logger.error("received invalid mask: " + netmask);
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"received invalid mask: " + netmask});
                }
                ++count;
            }
            netmaskValue <<= 1;
            ++c;
        }
        return (short)count;
    }

    public static String dottedQuad(int ip) {
        StringBuffer sb = new StringBuffer(15);
        int shift = 24;
        while (shift > 0) {
            sb.append(Integer.toString(ip >>> shift & 0xFF));
            sb.append('.');
            shift -= 8;
        }
        sb.append(Integer.toString(ip & 0xFF));
        return sb.toString();
    }

    public static int convertIp4Address(String ipAddress) {
        String[] splitIpAddress = ipAddress.split("\\.");
        short[] addressBytes = new short[4];
        int i = 0;
        while (i < 4) {
            String octet = splitIpAddress[i];
            addressBytes[i] = Short.parseShort(octet);
            ++i;
        }
        return NetworkUtil.packIp4AddressBytes(addressBytes);
    }

    public static int packIp4AddressBytes(short[] bytes) {
        int val = 0;
        int i = 3;
        while (i >= 0) {
            val <<= 8;
            val |= bytes[i];
            --i;
        }
        return val;
    }

    public static short[] unpackIP4AddressInt(int address) {
        return new short[]{(short)(address & 0xFF), (short)(address >> 8 & 0xFF), (short)(address >> 16 & 0xFF), (short)(address >> 24 & 0xFF)};
    }

    public static byte[] convertIP6Address(String fullFormIP6Address) {
        byte[] retVal = new byte[16];
        String[] ip6Split = fullFormIP6Address.split(":");
        int i = 0;
        while (i < 8) {
            String octet = ip6Split[i];
            StringBuffer sb = new StringBuffer();
            while (sb.length() + octet.length() < 4) {
                sb.append("0");
            }
            sb.append(octet);
            retVal[i * 2] = (byte)Short.parseShort(sb.toString().substring(0, 2), 16);
            retVal[i * 2 + 1] = (byte)Short.parseShort(sb.toString().substring(2, 4), 16);
            ++i;
        }
        return retVal;
    }

    public static String convertIP6Address(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 16) {
            sb.append(Integer.toHexString(0xFF & bytes[i]));
            sb.append(Integer.toHexString(0xFF & bytes[i + 1]));
            if (i != 14) {
                sb.append(":");
            }
            i += 2;
        }
        return sb.toString();
    }

    public static String macToString(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            String octet = Integer.toHexString(mac[i] & 0xFF).toUpperCase();
            if (octet.length() == 1) {
                sb.append("0");
            }
            sb.append(octet);
            if (i != 5) {
                sb.append(":");
            }
            ++i;
        }
        return sb.toString();
    }

    public static byte[] macToBytes(String mac) {
        StringTokenizer st = new StringTokenizer(mac, ":");
        byte[] bytes = new byte[6];
        int i = 0;
        while (i < 6) {
            bytes[i] = (byte)Integer.parseInt(st.nextToken(), 16);
            ++i;
        }
        return bytes;
    }
}

