/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.ReadWriteLockDummy;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, 0, false, false);
    private final long persistenceId;
    protected final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    protected TableBase table;
    int position;
    private Index.IndexUse[] asArray;
    Object[] nullData;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;

    public IndexAVL(HsqlNameManager.HsqlName hsqlName, long l, TableBase tableBase, int[] nArray, boolean[] blArray, boolean[] blArray2, Type[] typeArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.persistenceId = l;
        this.name = hsqlName;
        this.colIndex = nArray;
        this.colTypes = typeArray;
        this.colDesc = blArray == null ? new boolean[nArray.length] : blArray;
        this.nullsLast = blArray2 == null ? new boolean[nArray.length] : blArray2;
        this.isPK = bl;
        this.isUnique = bl2;
        this.isConstraint = bl3;
        this.isForward = bl4;
        this.table = tableBase;
        this.colCheck = tableBase.getNewColumnCheckList();
        this.asArray = new Index.IndexUse[]{new Index.IndexUse(this, this.colIndex.length)};
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[nArray.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean bl5 = this.colIndex.length > 0;
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i] && !this.nullsLast[i]) continue;
            bl5 = false;
        }
        this.isSimpleOrder = bl5;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
        switch (tableBase.getTableType()) {
            case 4: 
            case 5: 
            case 7: {
                this.lock = new ReentrantReadWriteLock();
                break;
            }
            default: {
                this.lock = new ReadWriteLockDummy();
            }
        }
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer(64);
        stringBuffer.append("CREATE").append(' ');
        if (this.isUnique()) {
            stringBuffer.append("UNIQUE").append(' ');
        }
        stringBuffer.append("INDEX").append(' ');
        stringBuffer.append(this.getName().statementName);
        stringBuffer.append(' ').append("ON").append(' ');
        stringBuffer.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        stringBuffer.append(((Table)this.table).getColumnListSQL(this.colIndex, this.colIndex.length));
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public Index.IndexUse[] asArray() {
        return this.asArray;
    }

    @Override
    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int n) {
        this.position = n;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getColumnCount() {
        return this.colIndex.length;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.colIndex;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    @Override
    public void setTable(TableBase tableBase) {
        this.table = tableBase;
    }

    @Override
    public void setClustered(boolean bl) {
        this.isClustered = bl;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Session session, PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            long l = persistentStore.elementCount(session);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeUnique(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            long l = persistentStore.elementCountUnique(this);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] searchCost(Session session, PersistentStore persistentStore) {
        boolean bl = false;
        int n = 1;
        double[] dArray = new double[this.colIndex.length];
        int n2 = 0;
        int[] nArray = new int[1];
        this.readLock.lock();
        try {
            int n3;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            if (nodeAVL == null) {
                double[] dArray2 = dArray;
                return dArray2;
            }
            while ((nodeAVL2 = (nodeAVL = nodeAVL2).getLeft(persistentStore)) != null) {
                if (n2 == 4) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            while (true) {
                nodeAVL2 = this.next(persistentStore, nodeAVL, n2, 4, nArray);
                n2 = nArray[0];
                if (nodeAVL2 == null) break;
                this.compareRowForChange(session, nodeAVL.getData(persistentStore), nodeAVL2.getData(persistentStore), dArray);
                nodeAVL = nodeAVL2;
                ++n;
            }
            if (bl) {
                double[] dArray3 = new double[this.colIndex.length];
                int n4 = this.probeFactor(session, persistentStore, dArray3, true) + this.probeFactor(session, persistentStore, dArray3, false);
                for (n3 = 0; n3 < this.colIndex.length; ++n3) {
                    int n5 = n3;
                    dArray3[n5] = dArray3[n5] / 2.0;
                    int n6 = 0;
                    while ((double)n6 < dArray3[n3]) {
                        int n7 = n3;
                        dArray[n7] = dArray[n7] * 2.0;
                        ++n6;
                    }
                }
            }
            long l = persistentStore.elementCount();
            for (n3 = 0; n3 < this.colIndex.length; ++n3) {
                if (dArray[n3] == 0.0) {
                    dArray[n3] = 1.0;
                }
                dArray[n3] = (double)l / dArray[n3];
                if (!(dArray[n3] < 2.0)) continue;
                dArray[n3] = 2.0;
            }
            double[] dArray4 = dArray;
            return dArray4;
        }
        finally {
            this.readLock.unlock();
        }
    }

    int probeFactor(Session session, PersistentStore persistentStore, double[] dArray, boolean bl) {
        NodeAVL nodeAVL;
        int n = 0;
        NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
        if (nodeAVL == null) {
            return 0;
        }
        while (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            NodeAVL nodeAVL3 = nodeAVL2 = bl ? nodeAVL.getLeft(persistentStore) : nodeAVL.getRight(persistentStore);
            if (++n <= 4 || nodeAVL2 == null) continue;
            this.compareRowForChange(session, nodeAVL.getData(persistentStore), nodeAVL2.getData(persistentStore), dArray);
        }
        return n - 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeCount(Session session, PersistentStore persistentStore) {
        long l = 0L;
        this.readLock.lock();
        try {
            RowIterator rowIterator = this.firstRow(session, persistentStore, 0);
            while (rowIterator.hasNext()) {
                rowIterator.getNextRow();
                ++l;
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            boolean bl = this.getAccessor(persistentStore) == null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkNodes(NodeAVL nodeAVL) {
        this.writeLock.lock();
        try {
            NodeAVL nodeAVL2;
            NodeAVL nodeAVL3 = nodeAVL2 = nodeAVL;
            while (nodeAVL3 != null) {
                nodeAVL2 = nodeAVL3;
                nodeAVL3 = nodeAVL2.getLeft(null);
            }
            while (nodeAVL2 != null) {
                NodeAVL nodeAVL4;
                nodeAVL2 = nodeAVL4 = this.nextUnlink(nodeAVL2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private NodeAVL nextUnlink(NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = nodeAVL.getRight(null);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getLeft(null);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(null);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(null); nodeAVL != null && nodeAVL.isRight(nodeAVL2); nodeAVL = nodeAVL.getParent(null)) {
            nodeAVL.nRight = null;
            nodeAVL2.getRow(null).destroy();
            nodeAVL2.delete();
            nodeAVL2 = nodeAVL;
        }
        if (nodeAVL != null) {
            nodeAVL.nLeft = null;
        }
        nodeAVL2.getRow(null).destroy();
        nodeAVL2.delete();
        return nodeAVL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndex(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = null;
            for (nodeAVL = this.getAccessor(persistentStore); nodeAVL != null; nodeAVL = nodeAVL.getLeft(persistentStore)) {
                nodeAVL2 = nodeAVL;
                this.checkNodes(persistentStore, nodeAVL);
            }
            nodeAVL = nodeAVL2;
            while (nodeAVL2 != null) {
                this.checkNodes(persistentStore, nodeAVL2);
                nodeAVL2 = this.next(persistentStore, nodeAVL2);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    void checkNodes(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = nodeAVL.getLeft(persistentStore);
        NodeAVL nodeAVL3 = nodeAVL.getRight(persistentStore);
        if (nodeAVL2 != null && nodeAVL2.getBalance(persistentStore) == -2) {
            System.out.print("broken index - deleted");
        }
        if (nodeAVL3 != null && nodeAVL3.getBalance(persistentStore) == -2) {
            System.out.print("broken index -deleted");
        }
        if (nodeAVL2 != null && !nodeAVL.equals(nodeAVL2.getParent(persistentStore))) {
            System.out.print("broken index - no parent");
        }
        if (nodeAVL3 != null && !nodeAVL.equals(nodeAVL3.getParent(persistentStore))) {
            System.out.print("broken index - no parent");
        }
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public void compareRowForChange(Session session, Object[] objectArray, Object[] objectArray2, double[] dArray) {
        for (int i = 0; i < this.colIndex.length; ++i) {
            int n = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n == 0) continue;
            while (i < this.colIndex.length) {
                int n2 = i++;
                dArray[n2] = dArray[n2] + 1.0;
            }
        }
    }

    @Override
    public int compareRow(Session session, Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < this.colIndex.length; ++i) {
            boolean bl;
            int n = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n == 0) continue;
            if (this.isSimpleOrder) {
                return n;
            }
            boolean bl2 = bl = objectArray[this.colIndex[i]] == null || objectArray2[this.colIndex[i]] == null;
            if (this.colDesc[i] && !bl) {
                n = -n;
            }
            if (this.nullsLast[i] && bl) {
                n = -n;
            }
            return n;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row row, Row row2, boolean bl, int n) {
        Object[] objectArray = row.getData();
        Object[] objectArray2 = row2.getData();
        for (int i = n; i < this.colIndex.length; ++i) {
            boolean bl2;
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n2 == 0) continue;
            if (this.isSimpleOrder) {
                return n2;
            }
            boolean bl3 = bl2 = objectArray[this.colIndex[i]] == null || objectArray2[this.colIndex[i]] == null;
            if (this.colDesc[i] && !bl2) {
                n2 = -n2;
            }
            if (this.nullsLast[i] && bl2) {
                n2 = -n2;
            }
            return n2;
        }
        if (bl) {
            long l = row.getPos() - row2.getPos();
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }
        return 0;
    }

    int compareObject(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n, int n2) {
        return this.colTypes[n].compare(session, objectArray[this.colIndex[n]], objectArray2[nArray[n]], n2);
    }

    boolean hasNulls(Session session, Object[] objectArray) {
        if (this.colIndex.length == 1) {
            return objectArray[this.colIndex[0]] == null;
        }
        boolean bl = session == null ? true : session.database.sqlUniqueNulls;
        for (int i = 0; i < this.colIndex.length; ++i) {
            if (objectArray[this.colIndex[i]] == null) {
                if (!bl) continue;
                return true;
            }
            if (bl) continue;
            return false;
        }
        return !bl;
    }

    @Override
    public void insert(Session session, PersistentStore persistentStore, Row row) {
        boolean bl = true;
        int n = -1;
        boolean bl2 = !this.isUnique || this.hasNulls(session, row.getData());
        this.writeLock.lock();
        persistentStore.writeLock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            if (nodeAVL == null) {
                persistentStore.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                return;
            }
            do {
                RowAVL rowAVL;
                if ((n = this.compareRowForInsertOrDelete(session, row, rowAVL = nodeAVL.getRow(persistentStore), bl2, 0)) == 0 && session != null && !bl2 && session.database.txManager.isMVRows() && !this.isEqualReadable(session, persistentStore, nodeAVL)) {
                    bl2 = true;
                    n = this.compareRowForInsertOrDelete(session, row, rowAVL, bl2, this.colIndex.length);
                }
                if (n != 0) continue;
                Constraint constraint = null;
                if (this.isConstraint) {
                    constraint = ((Table)this.table).getUniqueConstraintForIndex(this);
                }
                if (constraint == null) {
                    throw Error.error(104, this.name.statementName);
                }
                throw constraint.getException(row.getData());
            } while ((nodeAVL = (nodeAVL2 = nodeAVL).child(persistentStore, bl = n < 0)) != null);
            nodeAVL2 = nodeAVL2.set(persistentStore, bl, ((RowAVL)row).getNode(this.position));
            this.balance(persistentStore, nodeAVL2, bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            persistentStore.writeUnlock();
            this.writeLock.unlock();
        }
    }

    @Override
    public void delete(Session session, PersistentStore persistentStore, Row row) {
        NodeAVL nodeAVL;
        if (!row.isInMemory()) {
            row = (Row)persistentStore.get((CachedObject)row, false);
        }
        if ((nodeAVL = ((RowAVL)row).getNode(this.position)) != null) {
            this.delete(persistentStore, nodeAVL);
        }
    }

    void delete(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return;
        }
        this.writeLock.lock();
        persistentStore.writeLock();
        try {
            NodeAVL nodeAVL2;
            NodeAVL nodeAVL3;
            int n;
            NodeAVL nodeAVL4;
            if (nodeAVL.getLeft(persistentStore) == null) {
                nodeAVL4 = nodeAVL.getRight(persistentStore);
            } else if (nodeAVL.getRight(persistentStore) == null) {
                nodeAVL4 = nodeAVL.getLeft(persistentStore);
            } else {
                NodeAVL nodeAVL5;
                NodeAVL nodeAVL6 = nodeAVL;
                nodeAVL = nodeAVL.getLeft(persistentStore);
                while ((nodeAVL5 = nodeAVL.getRight(persistentStore)) != null) {
                    nodeAVL = nodeAVL5;
                }
                nodeAVL4 = nodeAVL.getLeft(persistentStore);
                n = nodeAVL.getBalance(persistentStore);
                nodeAVL = nodeAVL.setBalance(persistentStore, nodeAVL6.getBalance(persistentStore));
                nodeAVL6 = nodeAVL6.setBalance(persistentStore, n);
                nodeAVL3 = nodeAVL.getParent(persistentStore);
                NodeAVL nodeAVL7 = nodeAVL6.getParent(persistentStore);
                if (nodeAVL6.isRoot(persistentStore)) {
                    persistentStore.setAccessor((Index)this, nodeAVL);
                }
                nodeAVL = nodeAVL.setParent(persistentStore, nodeAVL7);
                if (nodeAVL7 != null) {
                    nodeAVL7 = nodeAVL7.isRight(nodeAVL6) ? nodeAVL7.setRight(persistentStore, nodeAVL) : nodeAVL7.setLeft(persistentStore, nodeAVL);
                }
                if (nodeAVL6.equals(nodeAVL3)) {
                    if ((nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL)).isLeft(nodeAVL)) {
                        nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL6);
                        nodeAVL2 = nodeAVL6.getRight(persistentStore);
                        nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL2);
                    } else {
                        nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL6);
                        nodeAVL2 = nodeAVL6.getLeft(persistentStore);
                        nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL2);
                    }
                } else {
                    nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL3);
                    nodeAVL3 = nodeAVL3.setRight(persistentStore, nodeAVL6);
                    nodeAVL2 = nodeAVL6.getLeft(persistentStore);
                    NodeAVL nodeAVL8 = nodeAVL6.getRight(persistentStore);
                    nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL2);
                    nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL8);
                }
                nodeAVL.getRight(persistentStore).setParent(persistentStore, nodeAVL);
                nodeAVL.getLeft(persistentStore).setParent(persistentStore, nodeAVL);
                nodeAVL6 = nodeAVL6.setLeft(persistentStore, nodeAVL4);
                if (nodeAVL4 != null) {
                    nodeAVL4 = nodeAVL4.setParent(persistentStore, nodeAVL6);
                }
                nodeAVL = nodeAVL6 = nodeAVL6.setRight(persistentStore, null);
            }
            boolean bl = nodeAVL.isFromLeft(persistentStore);
            nodeAVL.replace(persistentStore, this, nodeAVL4);
            nodeAVL4 = nodeAVL.getParent(persistentStore);
            nodeAVL.delete();
            while (nodeAVL4 != null) {
                nodeAVL = nodeAVL4;
                n = bl ? 1 : -1;
                switch (nodeAVL.getBalance(persistentStore) * n) {
                    case -1: {
                        nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                        break;
                    }
                    case 0: {
                        nodeAVL = nodeAVL.setBalance(persistentStore, n);
                        return;
                    }
                    case 1: {
                        nodeAVL3 = nodeAVL.child(persistentStore, !bl);
                        int n2 = nodeAVL3.getBalance(persistentStore);
                        if (n2 * n >= 0) {
                            nodeAVL.replace(persistentStore, this, nodeAVL3);
                            nodeAVL2 = nodeAVL3.child(persistentStore, bl);
                            nodeAVL = nodeAVL.set(persistentStore, !bl, nodeAVL2);
                            nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL);
                            if (n2 == 0) {
                                nodeAVL = nodeAVL.setBalance(persistentStore, n);
                                nodeAVL3 = nodeAVL3.setBalance(persistentStore, -n);
                                return;
                            }
                            nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                            nodeAVL = nodeAVL3 = nodeAVL3.setBalance(persistentStore, 0);
                            break;
                        }
                        nodeAVL2 = nodeAVL3.child(persistentStore, bl);
                        nodeAVL.replace(persistentStore, this, nodeAVL2);
                        n2 = nodeAVL2.getBalance(persistentStore);
                        nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL2.child(persistentStore, !bl));
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL3);
                        nodeAVL = nodeAVL.set(persistentStore, !bl, nodeAVL2.child(persistentStore, bl));
                        nodeAVL2 = nodeAVL2.set(persistentStore, bl, nodeAVL);
                        nodeAVL = nodeAVL.setBalance(persistentStore, n2 == n ? -n : 0);
                        nodeAVL3 = nodeAVL3.setBalance(persistentStore, n2 == -n ? n : 0);
                        nodeAVL = nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                    }
                }
                bl = nodeAVL.isFromLeft(persistentStore);
                nodeAVL4 = nodeAVL.getParent(persistentStore);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            persistentStore.writeUnlock();
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean existsParent(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 40, 2, false);
        return nodeAVL != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int n, int n2, int n3, boolean bl, boolean[] blArray) {
        if (n3 == 74) {
            return this.lastRow(session, persistentStore, 0);
        }
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.defaultColMap, n, n3, 0, bl);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, n2, false, bl);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.colIndex, this.colIndex.length, 40, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 40, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore persistentStore) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(Session session, PersistentStore persistentStore, int n) {
        this.readLock.lock();
        try {
            Object object;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            while (session != null && nodeAVL != null && !session.database.txManager.canRead(session, persistentStore, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                nodeAVL = this.next(persistentStore, nodeAVL);
            }
            if (nodeAVL == null) {
                object = emptyIterator;
                return object;
            }
            object = new IndexRowIterator(session, persistentStore, this, nodeAVL, n, false, false);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            if (nodeAVL == null) {
                IndexRowIterator indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            IndexRowIterator indexRowIterator = new IndexRowIterator(null, persistentStore, this, nodeAVL, 0, false, false);
            return indexRowIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator lastRow(Session session, PersistentStore persistentStore, int n) {
        this.readLock.lock();
        try {
            Object object;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getRight(persistentStore);
            }
            while (session != null && nodeAVL != null && !session.database.txManager.canRead(session, persistentStore, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                nodeAVL = this.last(persistentStore, nodeAVL);
            }
            if (nodeAVL == null) {
                object = emptyIterator;
                return object;
            }
            object = new IndexRowIterator(session, persistentStore, this, nodeAVL, n, false, true);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    NodeAVL next(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n) {
        RowAVL rowAVL;
        if (nodeAVL == null) {
            return null;
        }
        if (n != 0) {
            return this.findDistinctNode(session, persistentStore, nodeAVL, n, false);
        }
        do {
            if ((nodeAVL = this.next(persistentStore, nodeAVL)) == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!session.database.txManager.canRead(session, persistentStore, rowAVL = nodeAVL.getRow(persistentStore), 0, null));
        return nodeAVL;
    }

    NodeAVL last(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n) {
        RowAVL rowAVL;
        if (nodeAVL == null) {
            return null;
        }
        if (n != 0) {
            return this.findDistinctNode(session, persistentStore, nodeAVL, n, true);
        }
        do {
            if ((nodeAVL = this.last(persistentStore, nodeAVL)) == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!session.database.txManager.canRead(session, persistentStore, rowAVL = nodeAVL.getRow(persistentStore), 0, null));
        return nodeAVL;
    }

    NodeAVL next(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        NodeAVL nodeAVL2 = (nodeAVL = rowAVL.getNode(this.position)).getRight(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getLeft(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isRight(nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    NodeAVL next(PersistentStore persistentStore, NodeAVL nodeAVL, int n, int n2, int[] nArray) {
        NodeAVL nodeAVL2;
        NodeAVL nodeAVL3 = nodeAVL2 = n == n2 ? null : nodeAVL.getRight(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            NodeAVL nodeAVL4 = nodeAVL2 = ++n == n2 ? null : nodeAVL.getLeft(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                if (++n == n2) {
                    nodeAVL2 = null;
                    continue;
                }
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            nArray[0] = n;
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        nodeAVL = nodeAVL.getParent(persistentStore);
        --n;
        while (nodeAVL != null && nodeAVL.isRight(nodeAVL2)) {
            nodeAVL2 = nodeAVL;
            nodeAVL = nodeAVL.getParent(persistentStore);
            --n;
        }
        nArray[0] = n;
        return nodeAVL;
    }

    NodeAVL last(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        NodeAVL nodeAVL2 = (nodeAVL = rowAVL.getNode(this.position)).getLeft(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getRight(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getRight(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isLeft(nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    boolean isEqualReadable(Session session, PersistentStore persistentStore, NodeAVL nodeAVL) {
        Object[] objectArray;
        NodeAVL nodeAVL2 = nodeAVL;
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        session.database.txManager.setTransactionInfo(persistentStore, rowAVL);
        if (session.database.txManager.canRead(session, persistentStore, rowAVL, 1, null)) {
            return true;
        }
        Object[] objectArray2 = nodeAVL.getData(persistentStore);
        while ((nodeAVL2 = this.last(persistentStore, nodeAVL2)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            rowAVL = nodeAVL2.getRow(persistentStore);
            session.database.txManager.setTransactionInfo(persistentStore, rowAVL);
            if (!session.database.txManager.canRead(session, persistentStore, rowAVL, 1, null)) continue;
            return true;
        }
        while ((nodeAVL2 = this.next(session, persistentStore, nodeAVL, 0)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            rowAVL = nodeAVL2.getRow(persistentStore);
            session.database.txManager.setTransactionInfo(persistentStore, rowAVL);
            if (!session.database.txManager.canRead(session, persistentStore, rowAVL, 1, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray, int n, int n2, int n3, boolean bl) {
        this.readLock.lock();
        try {
            NodeAVL nodeAVL = this.getAccessor(persistentStore);
            NodeAVL nodeAVL2 = null;
            NodeAVL nodeAVL3 = null;
            RowAVL rowAVL = null;
            if (n2 != 40 && n2 != 47) {
                --n;
                if (n2 == 44 || n2 == 45) {
                    bl = true;
                }
            }
            while (nodeAVL != null) {
                rowAVL = nodeAVL.getRow(persistentStore);
                int n4 = 0;
                if (n > 0) {
                    n4 = this.compareRowNonUnique(session, rowAVL.getData(), objectArray, nArray, n);
                }
                if (n4 == 0) {
                    switch (n2) {
                        case 40: 
                        case 47: {
                            nodeAVL3 = nodeAVL;
                            if (bl) {
                                nodeAVL2 = nodeAVL.getRight(persistentStore);
                                break;
                            }
                            nodeAVL2 = nodeAVL.getLeft(persistentStore);
                            break;
                        }
                        case 43: 
                        case 48: {
                            n4 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n, n2);
                            if (n4 <= 0) {
                                nodeAVL2 = nodeAVL.getRight(persistentStore);
                                break;
                            }
                            nodeAVL3 = nodeAVL;
                            nodeAVL2 = nodeAVL.getLeft(persistentStore);
                            break;
                        }
                        case 41: 
                        case 42: {
                            n4 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n, n2);
                            if (n4 < 0) {
                                nodeAVL2 = nodeAVL.getRight(persistentStore);
                                break;
                            }
                            nodeAVL3 = nodeAVL;
                            nodeAVL2 = nodeAVL.getLeft(persistentStore);
                            break;
                        }
                        case 44: {
                            n4 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n, n2);
                            if (n4 < 0) {
                                nodeAVL3 = nodeAVL;
                                nodeAVL2 = nodeAVL.getRight(persistentStore);
                                break;
                            }
                            nodeAVL2 = nodeAVL.getLeft(persistentStore);
                            break;
                        }
                        case 45: {
                            n4 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n, n2);
                            if (n4 <= 0) {
                                nodeAVL3 = nodeAVL;
                                nodeAVL2 = nodeAVL.getRight(persistentStore);
                                break;
                            }
                            nodeAVL2 = nodeAVL.getLeft(persistentStore);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (n4 < 0) {
                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                } else if (n4 > 0) {
                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                }
                if (nodeAVL2 == null) break;
                nodeAVL = nodeAVL2;
            }
            if (session == null) {
                NodeAVL nodeAVL4 = nodeAVL3;
                return nodeAVL4;
            }
            while (nodeAVL3 != null && !session.database.txManager.canRead(session, persistentStore, rowAVL = nodeAVL3.getRow(persistentStore), n3, this.colIndex)) {
                NodeAVL nodeAVL5 = nodeAVL3 = bl ? this.last(persistentStore, nodeAVL3) : this.next(persistentStore, nodeAVL3);
                if (nodeAVL3 == null) break;
                rowAVL = nodeAVL3.getRow(persistentStore);
                if (n <= 0 || this.compareRowNonUnique(session, rowAVL.getData(), objectArray, nArray, n) == 0) continue;
                nodeAVL3 = null;
                break;
            }
            NodeAVL nodeAVL6 = nodeAVL3;
            return nodeAVL6;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findDistinctNode(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n, boolean bl) {
        this.readLock.lock();
        try {
            NodeAVL nodeAVL2 = this.getAccessor(persistentStore);
            NodeAVL nodeAVL3 = null;
            NodeAVL nodeAVL4 = null;
            RowAVL rowAVL = null;
            Object[] objectArray = nodeAVL.getData(persistentStore);
            while (nodeAVL2 != null) {
                rowAVL = nodeAVL2.getRow(persistentStore);
                int n2 = 0;
                n2 = this.compareRowNonUnique(session, rowAVL.getData(), objectArray, this.colIndex, n);
                if (bl) {
                    if (n2 < 0) {
                        nodeAVL4 = nodeAVL2;
                        nodeAVL3 = nodeAVL2.getRight(persistentStore);
                    } else {
                        nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                    }
                } else if (n2 <= 0) {
                    nodeAVL3 = nodeAVL2.getRight(persistentStore);
                } else {
                    nodeAVL4 = nodeAVL2;
                    nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                }
                if (nodeAVL3 == null) break;
                nodeAVL2 = nodeAVL3;
            }
            if (session == null) {
                NodeAVL nodeAVL5 = nodeAVL4;
                return nodeAVL5;
            }
            while (nodeAVL4 != null && !session.database.txManager.canRead(session, persistentStore, rowAVL = nodeAVL4.getRow(persistentStore), 0, this.colIndex)) {
                nodeAVL4 = bl ? this.last(persistentStore, nodeAVL4) : this.next(persistentStore, nodeAVL4);
            }
            NodeAVL nodeAVL6 = nodeAVL4;
            return nodeAVL6;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void balance(PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl) {
        while (true) {
            int n = bl ? 1 : -1;
            switch (nodeAVL.getBalance(persistentStore) * n) {
                case 1: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                    return;
                }
                case 0: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, -n);
                    break;
                }
                case -1: {
                    NodeAVL nodeAVL2 = nodeAVL.child(persistentStore, bl);
                    if (nodeAVL2.getBalance(persistentStore) == -n) {
                        nodeAVL.replace(persistentStore, this, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL2.child(persistentStore, !bl));
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL);
                        nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                    } else {
                        NodeAVL nodeAVL3 = nodeAVL2.child(persistentStore, !bl);
                        nodeAVL.replace(persistentStore, this, nodeAVL3);
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL3.child(persistentStore, bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL3.child(persistentStore, !bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, !bl, nodeAVL);
                        int n2 = nodeAVL3.getBalance(persistentStore);
                        nodeAVL = nodeAVL.setBalance(persistentStore, n2 == -n ? n : 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, n2 == n ? -n : 0);
                        nodeAVL3 = nodeAVL3.setBalance(persistentStore, 0);
                    }
                    return;
                }
            }
            if (nodeAVL.isRoot(persistentStore)) {
                return;
            }
            bl = nodeAVL.isFromLeft(persistentStore);
            nodeAVL = nodeAVL.getParent(persistentStore);
        }
    }

    NodeAVL getAccessor(PersistentStore persistentStore) {
        NodeAVL nodeAVL = (NodeAVL)persistentStore.getAccessor(this);
        return nodeAVL;
    }

    IndexRowIterator getIterator(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl, boolean bl2) {
        if (nodeAVL == null) {
            return emptyIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, bl, bl2);
        return indexRowIterator;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore persistentStore, IndexAVL indexAVL, NodeAVL nodeAVL, int n, boolean bl, boolean bl2) {
            this.session = session;
            this.store = persistentStore;
            this.index = indexAVL;
            this.distinctCount = n;
            this.single = bl;
            this.reversed = bl2;
            if (indexAVL == null) {
                return;
            }
            this.nextnode = nodeAVL;
        }

        @Override
        public boolean hasNext() {
            return this.nextnode != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Row getNextRow() {
            if (this.nextnode == null) {
                this.release();
                return null;
            }
            NodeAVL nodeAVL = this.nextnode;
            if (this.single) {
                this.nextnode = null;
            } else {
                this.index.readLock.lock();
                this.store.writeLock();
                try {
                    this.nextnode = this.reversed ? this.index.last(this.session, this.store, this.nextnode, this.distinctCount) : this.index.next(this.session, this.store, this.nextnode, this.distinctCount);
                }
                finally {
                    this.store.writeUnlock();
                    this.index.readLock.unlock();
                }
            }
            this.lastrow = nodeAVL.getRow(this.store);
            return this.lastrow;
        }

        @Override
        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        @Override
        public void removeCurrent() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow);
        }

        @Override
        public void release() {
        }

        @Override
        public boolean setRowColumns(boolean[] blArray) {
            return false;
        }

        @Override
        public long getRowId() {
            return this.nextnode.getPos();
        }
    }
}

