/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import com.ibm.jusb.tools.swing.UsbIrpPanel;
import com.ibm.jusb.tools.swing.UsbPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.usb.UsbException;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import javax.usb.util.UsbUtil;

public class UsbPipePanel
extends UsbPanel {
    private JPanel buttonsPanel = new JPanel(new GridLayout(3, 2, 2, 2));
    private JPanel submitPanel = new JPanel(new BorderLayout());
    private JPanel openClosePanel = new JPanel();
    private JTextArea outputTextArea = new JTextArea();
    private JScrollPane outputScroll = new JScrollPane(this.outputTextArea);
    private Vector packetList = new Vector();
    private JList packetJList = new JList();
    private JPanel packetPanel = new JPanel();
    private JScrollPane packetListScroll = new JScrollPane(this.packetPanel);
    private Box submitBox = new Box(0);
    private JPanel submitButtonLeftPanel = new JPanel();
    private JPanel submitButtonRightPanel = new JPanel();
    private JPanel irpPanel = new JPanel();
    private CardLayout irpLayout = new CardLayout();
    private JButton openButton = new JButton("Open");
    private JButton closeButton = new JButton("Close");
    private JButton clearButton = new JButton("Clear");
    private JButton submitButton = new JButton("Submit");
    private JButton newPacketButton = new JButton("New");
    private JButton copyPacketButton = new JButton("Copy");
    private JButton removeButton = new JButton("Remove");
    private JButton upButton = new JButton("Up");
    private JButton downButton = new JButton("Down");
    private ActionListener openListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.open();
        }
    };
    private ActionListener closeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.close();
        }
    };
    private ActionListener clearListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.outputTextArea.setText("");
        }
    };
    private ActionListener submitListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.submit();
        }
    };
    private ActionListener newPacketListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.addPacket(new UsbIrpPanel());
        }
    };
    private ActionListener copyPacketListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.copyPacket();
        }
    };
    private ActionListener removeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.removePacket();
        }
    };
    private ActionListener upListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.upPacket();
        }
    };
    private ActionListener downListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbPipePanel.this.downPacket();
        }
    };
    private ListSelectionListener packetListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent lsE) {
            UsbPipePanel.this.updateSelection();
        }
    };
    private UsbPipeListener pipeListener = new UsbPipeListener(){

        public void dataEventOccurred(UsbPipeDataEvent updE) {
            UsbPipePanel.this.gotData(updE.getData());
        }

        public void errorEventOccurred(UsbPipeErrorEvent upeE) {
            UsbPipePanel.this.gotError(upeE.getUsbException());
        }
    };
    private UsbPipe usbPipe = null;

    public UsbPipePanel(UsbPipe pipe) {
        this.usbPipe = pipe;
        this.string = "UsbPipe";
        this.initPanels();
        this.refresh();
    }

    public UsbPipe getUsbPipe() {
        return this.usbPipe;
    }

    @Override
    protected void refresh() {
        this.clear();
        this.appendln(this.string);
        this.initText();
    }

    protected void initText() {
        this.appendln("Is Active : " + this.usbPipe.isActive());
        this.appendln("Is Open : " + this.usbPipe.isOpen());
    }

    protected void initPanels() {
        this.outputTextArea.setEditable(false);
        this.openButton.addActionListener(this.openListener);
        this.closeButton.addActionListener(this.closeListener);
        this.clearButton.addActionListener(this.clearListener);
        this.submitButton.addActionListener(this.submitListener);
        this.newPacketButton.addActionListener(this.newPacketListener);
        this.copyPacketButton.addActionListener(this.copyPacketListener);
        this.removeButton.addActionListener(this.removeListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
        this.packetJList.setSelectionMode(0);
        this.packetJList.addListSelectionListener(this.packetListListener);
        this.openClosePanel.add(this.openButton);
        this.openClosePanel.add(this.closeButton);
        this.openClosePanel.add(this.clearButton);
        this.buttonsPanel.add(this.upButton);
        this.buttonsPanel.add(this.newPacketButton);
        this.buttonsPanel.add(this.downButton);
        this.buttonsPanel.add(this.copyPacketButton);
        this.buttonsPanel.add(this.submitButton);
        this.buttonsPanel.add(this.removeButton);
        this.irpPanel.setLayout(this.irpLayout);
        this.packetPanel.add(this.packetJList);
        JPanel panel = new JPanel();
        this.submitPanel.add((Component)this.packetListScroll, "Center");
        panel = new JPanel();
        panel.add(this.buttonsPanel);
        this.submitPanel.add((Component)panel, "East");
        this.submitPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add(this.openClosePanel);
        this.add(this.outputScroll);
        this.add(this.submitPanel);
        this.add(Box.createVerticalGlue());
        this.add(this.irpPanel);
        this.refreshButtons();
    }

    protected void refreshButtons() {
        this.submitButton.setEnabled(this.packetList.size() > 0);
        this.upButton.setEnabled(this.packetList.size() > 0 && this.getSelectedIndex() > 0);
        this.downButton.setEnabled(this.packetList.size() > 0 && this.getSelectedIndex() != this.packetList.size() - 1);
        this.removeButton.setEnabled(this.packetList.size() > 0);
        this.copyPacketButton.setEnabled(this.packetList.size() > 0);
        this.newPacketButton.setEnabled(true);
    }

    protected int getSelectedIndex() {
        if (this.packetJList.isSelectionEmpty() && !this.packetList.isEmpty()) {
            this.packetJList.setSelectedIndex(0);
        }
        return this.packetJList.getSelectedIndex();
    }

    protected void updateSelection() {
        if (!this.packetList.isEmpty()) {
            this.irpLayout.show(this.irpPanel, this.packetList.get(this.getSelectedIndex()).toString());
        }
        this.validate();
        this.refreshButtons();
    }

    protected void open() {
        if (this.usbPipe.isOpen()) {
            return;
        }
        this.usbPipe.addUsbPipeListener(this.pipeListener);
        try {
            this.usbPipe.open();
            this.refresh();
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "Could not open UsbPipe : " + uE.getMessage());
        }
        catch (UsbNotActiveException unaE) {
            JOptionPane.showMessageDialog(null, "Could not open UsbPipe : " + unaE.getMessage());
        }
    }

    protected void close() {
        if (!this.usbPipe.isOpen()) {
            return;
        }
        this.usbPipe.removeUsbPipeListener(this.pipeListener);
        try {
            this.usbPipe.close();
            this.refresh();
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "Could not close UsbPipe : " + uE.getMessage());
        }
        catch (UsbNotActiveException unaE) {
            JOptionPane.showMessageDialog(null, "Could not close UsbPipe : " + unaE.getMessage());
        }
    }

    protected void submit() {
        UsbIrpPanel panel = null;
        try {
            for (int i = 0; i < this.packetList.size(); ++i) {
                panel = (UsbIrpPanel)this.packetList.get(i);
                panel.submit(this.usbPipe);
            }
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "UsbException while submitting " + panel + " : " + uE.getMessage());
        }
        catch (NumberFormatException nfE) {
            JOptionPane.showMessageDialog(null, "NumberFormatException in " + panel + " : " + nfE.getMessage());
        }
    }

    protected void addPacket(UsbIrpPanel newPanel) {
        int index = this.packetJList.getSelectedIndex();
        this.packetList.add(newPanel);
        this.packetJList.setListData(this.packetList);
        this.irpPanel.add((Component)newPanel, newPanel.toString());
        if (0 <= index) {
            this.packetJList.setSelectedIndex(index);
        }
        this.updateSelection();
        this.refreshButtons();
    }

    protected void copyPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        this.addPacket((UsbIrpPanel)((UsbIrpPanel)this.packetList.get(this.packetJList.getSelectedIndex())).clone());
    }

    protected void removePacket() {
        int index = this.packetJList.getSelectedIndex();
        if (0 <= index) {
            this.packetList.remove(index);
            this.packetJList.setListData(this.packetList);
            if (this.packetList.size() <= index) {
                --index;
            }
            if (0 <= index) {
                this.packetJList.setSelectedIndex(index);
            }
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void upPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        int index = this.packetJList.getSelectedIndex();
        if (0 < index) {
            this.packetList.set(index, this.packetList.set(index - 1, this.packetList.get(index)));
            this.packetJList.setListData(this.packetList);
            this.packetJList.setSelectedIndex(index - 1);
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void downPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        int index = this.packetJList.getSelectedIndex();
        if (this.packetList.size() > index + 1) {
            this.packetList.set(index, this.packetList.set(index + 1, this.packetList.get(index)));
            this.packetJList.setListData(this.packetList);
            this.packetJList.setSelectedIndex(index + 1);
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void gotData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.outputTextArea.append(UsbUtil.toHexString((byte)data[i]) + " ");
        }
        this.outputTextArea.append("\n");
        this.outputTextArea.setCaretPosition(this.outputTextArea.getText().length());
        this.validate();
    }

    protected void gotError(UsbException uE) {
        JOptionPane.showMessageDialog(null, "Got UsbPipeErrorEvent : " + uE.getMessage());
    }
}

