/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.ssl.SSLSocketFactoryWrapper;
import org.eclipse.kura.core.ssl.SslManagerServiceOptions;
import org.eclipse.kura.core.ssl.SslServiceListeners;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslManagerServiceImpl
implements SslManagerService,
ConfigurableComponent {
    private static final Logger s_logger = LoggerFactory.getLogger(SslManagerServiceImpl.class);
    private SystemService m_systemService;
    private SslServiceListeners m_sslServiceListeners;
    private ComponentContext m_ctx;
    private SslManagerServiceOptions m_options;

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        this.m_options = new SslManagerServiceOptions(properties);
        ServiceTracker listenersTracker = new ServiceTracker(componentContext.getBundleContext(), SslServiceListener.class, null);
        this.m_sslServiceListeners = new SslServiceListeners((ServiceTracker<SslServiceListener, SslServiceListener>)listenersTracker);
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("updated...: " + properties);
        this.m_options = new SslManagerServiceOptions(properties);
        this.m_sslServiceListeners.onConfigurationUpdated();
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        this.m_sslServiceListeners.close();
    }

    public SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        String ciphers = this.m_options.getSslCiphers();
        String protocol = this.m_options.getSslProtocol();
        String trustStore = this.m_options.getSslTrustStore();
        TrustManager[] tms = this.getTrustManagers(trustStore);
        String keyAlias = null;
        String keyStore = this.m_options.getSslKeyStore();
        char[] keyStorePwd = this.getKeyStorePassword();
        KeyManager[] kms = this.getKeyManagers(keyStore, keyStorePwd, keyAlias);
        return this.getSSLSocketFactory(protocol, ciphers, kms, tms);
    }

    public SSLSocketFactory getSSLSocketFactory(String keyAlias) throws GeneralSecurityException, IOException {
        String protocol = this.m_options.getSslProtocol();
        String ciphers = this.m_options.getSslCiphers();
        String trustStore = this.m_options.getSslTrustStore();
        TrustManager[] tms = this.getTrustManagers(trustStore);
        String keyStore = this.m_options.getSslKeyStore();
        char[] keyStorePwd = this.getKeyStorePassword();
        KeyManager[] kms = this.getKeyManagers(keyStore, keyStorePwd, keyAlias);
        return this.getSSLSocketFactory(protocol, ciphers, kms, tms);
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePwd, String keyAlias) throws GeneralSecurityException, IOException {
        TrustManager[] tms = this.getTrustManagers(trustStore);
        KeyManager[] kms = this.getKeyManagers(keyStore, keyStorePwd, keyAlias);
        return this.getSSLSocketFactory(protocol, ciphers, kms, tms);
    }

    public X509Certificate[] getTrustCertificates() throws GeneralSecurityException, IOException {
        TrustManager[] tms;
        X509Certificate[] cacerts = null;
        String trustStore = this.m_options.getSslTrustStore();
        TrustManager[] trustManagerArray = tms = this.getTrustManagers(trustStore);
        int n = tms.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                X509TrustManager x509tm = (X509TrustManager)tm;
                cacerts = x509tm.getAcceptedIssuers();
                break;
            }
            ++n2;
        }
        return cacerts;
    }

    public void installTrustCertificate(String alias, X509Certificate x509crt) throws GeneralSecurityException, IOException {
        InputStream tsReadStream = null;
        FileOutputStream tsOutStream = null;
        try {
            String trustStore = this.m_options.getSslTrustStore();
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            File fTrustStore = new File(trustStore);
            if (fTrustStore.exists()) {
                tsReadStream = new FileInputStream(trustStore);
                ts.load(tsReadStream, null);
            } else {
                ts.load(null, null);
            }
            ts.setCertificateEntry(alias, x509crt);
            char[] trustStorePwd = this.getTrustStorePassword();
            tsOutStream = new FileOutputStream(trustStore);
            ts.store(tsOutStream, trustStorePwd);
            tsOutStream.close();
        }
        finally {
            if (tsReadStream != null) {
                tsReadStream.close();
            }
            if (tsOutStream != null) {
                tsOutStream.close();
            }
        }
    }

    public void deleteTrustCertificate(String alias) throws GeneralSecurityException, IOException {
        InputStream tsReadStream = null;
        try {
            String trustStore = this.m_options.getSslTrustStore();
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            tsReadStream = new FileInputStream(trustStore);
            ts.load(tsReadStream, null);
            ts.deleteEntry(alias);
            ts.store(new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    try {
                        char[] trustStorePwd = SslManagerServiceImpl.this.getTrustStorePassword();
                        return new KeyStore.PasswordProtection(trustStorePwd);
                    }
                    catch (Exception e) {
                        s_logger.error("Error loading TrustStore password", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        finally {
            if (tsReadStream != null) {
                tsReadStream.close();
            }
        }
    }

    private SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, KeyManager[] kms, TrustManager[] tms) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx = null;
        if (protocol == null) {
            sslCtx = SSLContext.getDefault();
        } else {
            sslCtx = SSLContext.getInstance(protocol);
            sslCtx.init(kms, tms, null);
        }
        SSLSocketFactory sslSocketFactory = sslCtx.getSocketFactory();
        SSLSocketFactoryWrapper sfw = new SSLSocketFactoryWrapper(sslSocketFactory, ciphers, this.m_options.isSslHostnameVerification());
        return sfw;
    }

    private TrustManager[] getTrustManagers(String trustStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        InputStream tsReadStream = null;
        try {
            TrustManagerFactory tmf = null;
            if (trustStore != null) {
                File fTrustStore = new File(trustStore);
                if (fTrustStore.exists()) {
                    KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
                    tsReadStream = new FileInputStream(trustStore);
                    ts.load(tsReadStream, null);
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts);
                } else {
                    s_logger.info("Could not find trust store at {}. Using Java default.", (Object)trustStore);
                }
            }
            if (tmf == null) {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
            }
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
        finally {
            if (tsReadStream != null) {
                tsReadStream.close();
            }
        }
    }

    private KeyManager[] getKeyManagers(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore ks = this.getKeyStore(keyStore, keyStorePassword, keyAlias);
        KeyManager[] kms = null;
        if (ks != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePassword);
            kms = kmf.getKeyManagers();
        }
        return kms;
    }

    private KeyStore getKeyStore(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException {
        InputStream ksReadStream = null;
        try {
            KeyStore ks = null;
            if (keyStore != null) {
                File fKeyStore = new File(keyStore);
                if (fKeyStore.exists()) {
                    ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ksReadStream = new FileInputStream(keyStore);
                    ks.load(ksReadStream, null);
                    if (keyAlias != null) {
                        if (ks.containsAlias(keyAlias) && ks.isKeyEntry(keyAlias)) {
                            if (ks.size() > 1) {
                                KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(keyStorePassword);
                                KeyStore.Entry entry = ks.getEntry(keyAlias, pp);
                                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                                ks.load(null, null);
                                ks.setEntry(keyAlias, entry, pp);
                            }
                        } else {
                            s_logger.info("Could not find alias {} in key store at {}. Using Java default.", (Object)keyAlias, (Object)keyStore);
                            ks = null;
                        }
                    }
                } else {
                    s_logger.info("Could not find key store at {}. Using Java default.", (Object)keyStore);
                }
            }
            KeyStore keyStore2 = ks;
            return keyStore2;
        }
        finally {
            if (ksReadStream != null) {
                ksReadStream.close();
            }
        }
    }

    private char[] getKeyStorePassword() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
        return this.m_systemService.getJavaKeyStorePassword();
    }

    private char[] getTrustStorePassword() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
        return this.m_systemService.getJavaTrustStorePassword();
    }
}

