/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.comm.CommConnection;
import org.eclipse.kura.comm.CommURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommConnectionImpl
implements CommConnection {
    private static final Logger s_logger = LoggerFactory.getLogger(CommConnectionImpl.class);
    private String m_port;
    private int m_baudRate;
    private int m_dataBits;
    private int m_stopBits;
    private int m_parity;
    private int m_flowControl;
    private int m_timeout;
    private CommURI m_commUri;
    private SerialPort m_serialPort;
    private InputStream m_inputStream;
    private OutputStream m_outputStream;

    static {
        String kuraExtDir = System.getProperty("kura.ext.dir");
        if (kuraExtDir != null) {
            StringBuffer sb = new StringBuffer();
            String existingDirs = System.getProperty("java.ext.dirs");
            if (existingDirs != null) {
                if (!existingDirs.contains(kuraExtDir)) {
                    sb.append(existingDirs).append(":").append(kuraExtDir);
                    System.setProperty("java.ext.dirs", sb.toString());
                }
            } else {
                sb.append(kuraExtDir);
                System.setProperty("java.ext.dirs", sb.toString());
            }
        }
    }

    public CommConnectionImpl(CommURI commUri, int mode, boolean timeouts) throws IOException, NoSuchPortException, PortInUseException {
        this.m_commUri = commUri;
        this.m_serialPort = null;
        this.m_port = this.m_commUri.getPort();
        this.m_baudRate = this.m_commUri.getBaudRate();
        this.m_dataBits = this.m_commUri.getDataBits();
        this.m_stopBits = this.m_commUri.getStopBits();
        this.m_parity = this.m_commUri.getParity();
        this.m_flowControl = this.m_commUri.getFlowControl();
        this.m_timeout = this.m_commUri.getTimeout();
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.m_port);
        CommPort commPort = commPortIdentifier.open(this.getClass().getName(), this.m_timeout);
        if (commPort instanceof SerialPort) {
            this.m_serialPort = (SerialPort)commPort;
            try {
                this.m_serialPort.setSerialPortParams(this.m_baudRate, this.m_dataBits, this.m_stopBits, this.m_parity);
                this.m_serialPort.setFlowControlMode(this.m_flowControl);
            }
            catch (UnsupportedCommOperationException e) {
                e.printStackTrace();
            }
        } else {
            throw new IOException("Unsupported Port Type");
        }
    }

    public CommURI getURI() {
        return this.m_commUri;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (this.m_inputStream == null) {
            this.m_inputStream = this.m_serialPort.getInputStream();
        }
        return this.m_inputStream;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (this.m_outputStream == null) {
            this.m_outputStream = this.m_serialPort.getOutputStream();
        }
        return this.m_outputStream;
    }

    public synchronized void close() throws IOException {
        if (this.m_serialPort != null) {
            this.m_serialPort.notifyOnDataAvailable(false);
            this.m_serialPort.removeEventListener();
            if (this.m_inputStream != null) {
                this.m_inputStream.close();
                this.m_inputStream = null;
            }
            if (this.m_outputStream != null) {
                this.m_outputStream.close();
                this.m_outputStream = null;
            }
            this.m_serialPort.close();
            this.m_serialPort = null;
        }
    }

    public synchronized void sendMessage(byte[] message) throws KuraException, IOException {
        if (message != null) {
            s_logger.debug("sendMessage() - " + this.getBytesAsString(message));
            if (this.m_outputStream == null) {
                this.openOutputStream();
            }
        } else {
            throw new NullPointerException("Serial message is null");
        }
        this.m_outputStream.write(message, 0, message.length);
        this.m_outputStream.flush();
    }

    public synchronized byte[] sendCommand(byte[] command, int timeout) throws KuraException, IOException {
        if (command != null) {
            byte[] dataInBuffer;
            s_logger.debug("sendMessage() - " + this.getBytesAsString(command));
            if (this.m_outputStream == null) {
                this.openOutputStream();
            }
            if (this.m_inputStream == null) {
                this.openInputStream();
            }
            if ((dataInBuffer = this.flushSerialBuffer()) != null && dataInBuffer.length > 0) {
                s_logger.warn("eating bytes in the serial buffer input stream before sending command: " + this.getBytesAsString(dataInBuffer));
            }
            this.m_outputStream.write(command, 0, command.length);
            this.m_outputStream.flush();
            ByteBuffer buffer = this.getResponse(timeout);
            if (buffer != null) {
                byte[] response = new byte[buffer.limit()];
                buffer.get(response, 0, response.length);
                return response;
            }
            return null;
        }
        throw new NullPointerException("Serial command is null");
    }

    public synchronized byte[] sendCommand(byte[] command, int timeout, int demark) throws KuraException, IOException {
        if (command != null) {
            byte[] dataInBuffer;
            s_logger.debug("sendMessage() - " + this.getBytesAsString(command));
            if (this.m_outputStream == null) {
                this.openOutputStream();
            }
            if (this.m_inputStream == null) {
                this.openInputStream();
            }
            if ((dataInBuffer = this.flushSerialBuffer()) != null && dataInBuffer.length > 0) {
                s_logger.warn("eating bytes in the serial buffer input stream before sending command: " + this.getBytesAsString(dataInBuffer));
            }
            this.m_outputStream.write(command, 0, command.length);
            this.m_outputStream.flush();
            ByteBuffer buffer = this.getResponse(timeout, demark);
            if (buffer != null) {
                byte[] response = new byte[buffer.limit()];
                buffer.get(response, 0, response.length);
                return response;
            }
            return null;
        }
        throw new NullPointerException("Serial command is null");
    }

    public synchronized byte[] flushSerialBuffer() throws KuraException, IOException {
        ByteBuffer buffer = this.getResponse(50);
        if (buffer != null) {
            byte[] response = new byte[buffer.limit()];
            buffer.get(response, 0, response.length);
            return response;
        }
        return null;
    }

    private synchronized ByteBuffer getResponse(int timeout) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        Date start = new Date();
        while (this.m_inputStream.available() < 1 && new Date().getTime() - start.getTime() < (long)timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.m_inputStream.available() >= 1) {
            int c = this.m_inputStream.read();
            buffer.put((byte)c);
        }
        buffer.flip();
        return buffer.limit() > 0 ? buffer : null;
    }

    private synchronized ByteBuffer getResponse(int timeout, int demark) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        long start = System.currentTimeMillis();
        while (this.m_inputStream.available() < 1 && System.currentTimeMillis() - start < (long)timeout) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        start = System.currentTimeMillis();
        do {
            if (this.m_inputStream.available() <= 0) continue;
            start = System.currentTimeMillis();
            int c = this.m_inputStream.read();
            buffer.put((byte)c);
        } while (System.currentTimeMillis() - start < (long)demark);
        buffer.flip();
        return buffer.limit() > 0 ? buffer : null;
    }

    private String getBytesAsString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append("0x").append(Integer.toHexString(b)).append(" ");
            ++n2;
        }
        return sb.toString();
    }
}

