/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import com.ibm.jusb.tools.swing.UsbControlIrpPanel;
import com.ibm.jusb.tools.swing.UsbPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.UsbUtil;

public class UsbDevicePanel
extends UsbPanel {
    private JPanel clearPanel = new JPanel(new BorderLayout());
    private JTextArea outputTextArea = new JTextArea(3, 30);
    private JScrollPane outputScroll = new JScrollPane(this.outputTextArea);
    private Vector packetList = new Vector();
    private JList packetJList = new JList();
    private JPanel packetPanel = new JPanel();
    private JScrollPane packetListScroll = new JScrollPane(this.packetJList);
    private JPanel requestPanel = new JPanel();
    private CardLayout requestLayout = new CardLayout();
    private JPanel emptyPanel = new JPanel();
    private static final String EMPTY_PANEL = "Empty Panel";
    private JButton clearButton = new JButton("Clear");
    private JButton submitButton = new JButton("Submit");
    private JButton newPacketButton = new JButton("New");
    private JButton copyPacketButton = new JButton("Copy");
    private JButton removeButton = new JButton("Remove");
    private JButton upButton = new JButton("Up");
    private JButton downButton = new JButton("Down");
    private ActionListener clearListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.outputTextArea.setText("");
        }
    };
    private ActionListener submitListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.submit();
        }
    };
    private ActionListener newPacketListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.addPacket(new UsbControlIrpPanel());
        }
    };
    private ActionListener copyPacketListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.copyPacket();
        }
    };
    private ActionListener removeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.removePacket();
        }
    };
    private ActionListener upListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.upPacket();
        }
    };
    private ActionListener downListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent aE) {
            UsbDevicePanel.this.downPacket();
        }
    };
    private ListSelectionListener packetListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent lsE) {
            UsbDevicePanel.this.updateSelection();
        }
    };
    private UsbDeviceListener deviceListener = new UsbDeviceListener(){

        public void dataEventOccurred(UsbDeviceDataEvent uddE) {
            UsbDevicePanel.this.gotData(uddE.getData());
        }

        public void errorEventOccurred(UsbDeviceErrorEvent udeE) {
            UsbDevicePanel.this.gotError(udeE.getUsbException());
        }

        public void usbDeviceDetached(UsbDeviceEvent udE) {
            udE.getUsbDevice().removeUsbDeviceListener(UsbDevicePanel.this.deviceListener);
        }
    };
    protected UsbDevice usbDevice = null;

    public UsbDevicePanel() {
    }

    public UsbDevicePanel(UsbDevice device) {
        this.usbDevice = device;
        this.string = "UsbDevice";
        String product = null;
        try {
            product = this.usbDevice.getProductString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null != product) {
            this.string = this.string + " (" + product + ")";
        } else {
            String idvendor = UsbUtil.toHexString((short)this.usbDevice.getUsbDeviceDescriptor().idVendor());
            String idproduct = UsbUtil.toHexString((short)this.usbDevice.getUsbDeviceDescriptor().idProduct());
            this.string = this.string + " <" + idvendor + ":" + idproduct + ">";
        }
        this.initPanels();
        this.refresh();
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    @Override
    protected void refresh() {
        this.clear();
        this.appendln(this.string);
        this.initText();
    }

    protected void initText() {
        String manufacturer = null;
        String product = null;
        String serialNumber = null;
        try {
            manufacturer = this.usbDevice.getManufacturerString();
        }
        catch (Exception e) {
            manufacturer = "Error : " + e.getMessage();
        }
        try {
            product = this.usbDevice.getProductString();
        }
        catch (Exception e) {
            product = "Error : " + e.getMessage();
        }
        try {
            serialNumber = this.usbDevice.getSerialNumberString();
        }
        catch (Exception e) {
            serialNumber = "Error : " + e.getMessage();
        }
        if (null == manufacturer) {
            manufacturer = "<undefined>";
        }
        if (null == product) {
            product = "<undefined>";
        }
        if (null == serialNumber) {
            serialNumber = "<undefined>";
        }
        this.appendln("Manufacturer : " + manufacturer);
        this.appendln("Product : " + product);
        this.appendln("Serial Number : " + serialNumber);
        this.appendln("Speed : " + UsbUtil.getSpeedString((Object)this.usbDevice.getSpeed()));
        this.appendln("Is Configured : " + this.usbDevice.isConfigured());
        this.appendln("Active UsbConfiguration Number : " + UsbUtil.unsignedInt((byte)this.usbDevice.getActiveUsbConfigurationNumber()));
        this.append(this.usbDevice.getUsbDeviceDescriptor().toString());
    }

    protected void initPanels() {
        this.usbDevice.addUsbDeviceListener(this.deviceListener);
        this.outputTextArea.setEditable(false);
        this.clearButton.addActionListener(this.clearListener);
        this.submitButton.addActionListener(this.submitListener);
        this.newPacketButton.addActionListener(this.newPacketListener);
        this.copyPacketButton.addActionListener(this.copyPacketListener);
        this.removeButton.addActionListener(this.removeListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
        this.packetJList.setSelectionMode(0);
        this.packetJList.addListSelectionListener(this.packetListListener);
        this.clearPanel.add((Component)this.outputScroll, "Center");
        JPanel panel = new JPanel();
        panel.add(this.clearButton);
        this.clearPanel.add((Component)panel, "East");
        this.clearPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.requestPanel.setLayout(this.requestLayout);
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        JPanel insidePanel = new JPanel(new GridLayout(3, 2, 5, 5));
        insidePanel.add(this.upButton);
        insidePanel.add(this.newPacketButton);
        insidePanel.add(this.downButton);
        insidePanel.add(this.copyPacketButton);
        insidePanel.add(this.submitButton);
        insidePanel.add(this.removeButton);
        buttonsPanel.add(insidePanel);
        JPanel submitPanel = new JPanel(new BorderLayout());
        submitPanel.add((Component)this.packetListScroll, "Center");
        submitPanel.add((Component)buttonsPanel, "East");
        submitPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add(this.clearPanel);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(submitPanel);
        this.requestPanel.add((Component)this.emptyPanel, EMPTY_PANEL);
        this.add(this.requestPanel);
        this.refreshButtons();
    }

    protected void refreshButtons() {
        this.submitButton.setEnabled(this.packetList.size() > 0);
        this.upButton.setEnabled(this.packetList.size() > 0 && this.getSelectedIndex() > 0);
        this.downButton.setEnabled(this.packetList.size() > 0 && this.getSelectedIndex() != this.packetList.size() - 1);
        this.removeButton.setEnabled(this.packetList.size() > 0);
        this.copyPacketButton.setEnabled(this.packetList.size() > 0);
        this.newPacketButton.setEnabled(true);
    }

    protected int getSelectedIndex() {
        if (this.packetJList.isSelectionEmpty() && !this.packetList.isEmpty()) {
            this.packetJList.setSelectedIndex(0);
        }
        return this.packetJList.getSelectedIndex();
    }

    protected void updateSelection() {
        if (!this.packetList.isEmpty()) {
            this.requestLayout.show(this.requestPanel, this.packetList.get(this.getSelectedIndex()).toString());
        } else {
            this.requestLayout.show(this.requestPanel, EMPTY_PANEL);
        }
        this.validate();
        this.refreshButtons();
    }

    protected void submit() {
        UsbControlIrpPanel panel = null;
        try {
            for (int i = 0; i < this.packetList.size(); ++i) {
                panel = (UsbControlIrpPanel)this.packetList.get(i);
                panel.submit(this.usbDevice);
            }
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "UsbException while submitting " + panel + " : " + uE.getMessage());
        }
        catch (NumberFormatException nfE) {
            JOptionPane.showMessageDialog(null, "NumberFormatException in " + panel + " : " + nfE.getMessage());
        }
    }

    protected void addPacket(UsbControlIrpPanel newPanel) {
        int index = this.packetJList.getSelectedIndex();
        this.packetList.add(newPanel);
        this.packetJList.setListData(this.packetList);
        this.requestPanel.add((Component)newPanel, newPanel.toString());
        if (0 <= index) {
            this.packetJList.setSelectedIndex(index);
        }
        this.updateSelection();
        this.refreshButtons();
    }

    protected void copyPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        this.addPacket((UsbControlIrpPanel)((UsbControlIrpPanel)this.packetList.get(this.packetJList.getSelectedIndex())).clone());
    }

    protected void removePacket() {
        int index = this.packetJList.getSelectedIndex();
        if (0 <= index) {
            this.packetList.remove(index);
            this.packetJList.setListData(this.packetList);
            if (this.packetList.size() <= index) {
                --index;
            }
            if (0 <= index) {
                this.packetJList.setSelectedIndex(index);
            }
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void upPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        int index = this.packetJList.getSelectedIndex();
        if (0 < index) {
            this.packetList.set(index, this.packetList.set(index - 1, this.packetList.get(index)));
            this.packetJList.setListData(this.packetList);
            this.packetJList.setSelectedIndex(index - 1);
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void downPacket() {
        if (this.packetJList.isSelectionEmpty()) {
            return;
        }
        int index = this.packetJList.getSelectedIndex();
        if (this.packetList.size() > index + 1) {
            this.packetList.set(index, this.packetList.set(index + 1, this.packetList.get(index)));
            this.packetJList.setListData(this.packetList);
            this.packetJList.setSelectedIndex(index + 1);
            this.updateSelection();
        }
        this.refreshButtons();
    }

    protected void gotData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.outputTextArea.append(UsbUtil.toHexString((byte)data[i]) + " ");
        }
        this.outputTextArea.append("\n");
        this.outputTextArea.setCaretPosition(this.outputTextArea.getText().length());
        this.validate();
    }

    protected void gotError(UsbException uE) {
        JOptionPane.showMessageDialog(null, "Got UsbDeviceErrorEvent : " + uE.getMessage());
    }
}

