/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceListener;
import javax.usb.event.UsbPipeListener;

public class UsbUtil {
    public static short unsignedShort(byte by) {
        return (short)(0xFF & by);
    }

    public static int unsignedInt(byte by) {
        return 0xFF & by;
    }

    public static int unsignedInt(short s) {
        return 0xFFFF & s;
    }

    public static long unsignedLong(byte by) {
        return 0xFF & by;
    }

    public static long unsignedLong(short s) {
        return 0xFFFF & s;
    }

    public static long unsignedLong(int n) {
        return 0xFFFFFFFF & n;
    }

    public static short toShort(byte by, byte by2) {
        return (short)(0xFF00 & (short)(by << 8) | 0xFF & (short)by2);
    }

    public static int toInt(byte by, byte by2, byte by3, byte by4) {
        return UsbUtil.toInt(UsbUtil.toShort(by, by2), UsbUtil.toShort(by3, by4));
    }

    public static long toLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return UsbUtil.toLong(UsbUtil.toInt(by, by2, by3, by4), UsbUtil.toInt(by5, by6, by7, by8));
    }

    public static int toInt(short s, short s2) {
        return 0xFFFF0000 & s << 16 | 0xFFFF & s2;
    }

    public static long toLong(short s, short s2, short s3, short s4) {
        return UsbUtil.toLong(UsbUtil.toInt(s, s2), UsbUtil.toInt(s3, s4));
    }

    public static long toLong(int n, int n2) {
        return (long)n << 32 | 0xFFFFFFFFFFFFFFFFL & (long)n2;
    }

    public static String toHexString(byte by) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(by), '0', 2, 2);
    }

    public static String toHexString(short s) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(s), '0', 4, 4);
    }

    public static String toHexString(int n) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(n), '0', 8, 8);
    }

    public static String toHexString(long l) {
        return UsbUtil.toHexString(l, '0', 16, 16);
    }

    public static String toHexString(long l, char c, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        if (n2 < n) {
            return stringBuffer.toString();
        }
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, c);
        }
        return stringBuffer.substring(stringBuffer.length() - n);
    }

    public static String toHexString(String string, byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > byArray.length) {
            n = byArray.length;
        }
        if (n < 0) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + UsbUtil.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, short[] sArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > sArray.length) {
            n = sArray.length;
        }
        if (n < 0) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + UsbUtil.toHexString(sArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > nArray.length) {
            n = nArray.length;
        }
        if (n < 0) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + UsbUtil.toHexString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, long[] lArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > lArray.length) {
            n = lArray.length;
        }
        if (n < 0) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + UsbUtil.toHexString(lArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(String string, byte[] byArray) {
        return UsbUtil.toHexString(string, byArray, byArray.length);
    }

    public static String toHexString(String string, short[] sArray) {
        return UsbUtil.toHexString(string, sArray, sArray.length);
    }

    public static String toHexString(String string, int[] nArray) {
        return UsbUtil.toHexString(string, nArray, nArray.length);
    }

    public static String toHexString(String string, long[] lArray) {
        return UsbUtil.toHexString(string, lArray, lArray.length);
    }

    public static String getSpeedString(Object object) {
        if (UsbConst.DEVICE_SPEED_LOW == object) {
            return "Low";
        }
        if (UsbConst.DEVICE_SPEED_FULL == object) {
            return "Full";
        }
        if (UsbConst.DEVICE_SPEED_UNKNOWN == object) {
            return "Unknown";
        }
        if (null == object) {
            return "null";
        }
        return "Invalid";
    }

    public static UsbDevice synchronizedUsbDevice(UsbDevice usbDevice) {
        return new SynchronizedUsbDevice(usbDevice);
    }

    public static UsbPipe synchronizedUsbPipe(UsbPipe usbPipe) {
        return new SynchronizedUsbPipe(usbPipe);
    }

    public static class SynchronizedUsbPipe
    implements UsbPipe {
        public UsbPipe usbPipe = null;
        protected Object openLock = new Object();
        protected Object submitLock = new Object();

        public SynchronizedUsbPipe(UsbPipe usbPipe) {
            this.usbPipe = usbPipe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open() throws UsbException, UsbNotActiveException, UsbNotClaimedException {
            Object object = this.openLock;
            synchronized (object) {
                this.usbPipe.open();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws UsbException, UsbNotOpenException {
            Object object = this.openLock;
            synchronized (object) {
                this.usbPipe.close();
            }
        }

        @Override
        public boolean isActive() {
            return this.usbPipe.isActive();
        }

        @Override
        public boolean isOpen() {
            return this.usbPipe.isOpen();
        }

        @Override
        public UsbEndpoint getUsbEndpoint() {
            return this.usbPipe.getUsbEndpoint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int syncSubmit(byte[] byArray) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbPipe.syncSubmit(byArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsbIrp asyncSubmit(byte[] byArray) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbPipe.asyncSubmit(byArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(UsbIrp usbIrp) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.syncSubmit(usbIrp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(UsbIrp usbIrp) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.asyncSubmit(usbIrp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(List list) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.syncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(List list) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.asyncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abortAllSubmissions() throws UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.abortAllSubmissions();
            }
        }

        @Override
        public UsbIrp createUsbIrp() {
            return this.usbPipe.createUsbIrp();
        }

        @Override
        public UsbControlIrp createUsbControlIrp(byte by, byte by2, short s, short s2) {
            return this.usbPipe.createUsbControlIrp(by, by2, s, s2);
        }

        @Override
        public void addUsbPipeListener(UsbPipeListener usbPipeListener) {
            this.usbPipe.addUsbPipeListener(usbPipeListener);
        }

        @Override
        public void removeUsbPipeListener(UsbPipeListener usbPipeListener) {
            this.usbPipe.removeUsbPipeListener(usbPipeListener);
        }
    }

    public static class SynchronizedUsbDevice
    implements UsbDevice {
        public UsbDevice usbDevice = null;
        protected Object submitLock = new Object();
        protected Object listenerLock = new Object();

        public SynchronizedUsbDevice(UsbDevice usbDevice) {
            this.usbDevice = usbDevice;
        }

        @Override
        public UsbPort getParentUsbPort() {
            return this.usbDevice.getParentUsbPort();
        }

        @Override
        public boolean isUsbHub() {
            return this.usbDevice.isUsbHub();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getManufacturerString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getManufacturerString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSerialNumberString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getSerialNumberString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProductString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getProductString();
            }
        }

        @Override
        public Object getSpeed() {
            return this.usbDevice.getSpeed();
        }

        @Override
        public List getUsbConfigurations() {
            return this.usbDevice.getUsbConfigurations();
        }

        @Override
        public UsbConfiguration getUsbConfiguration(byte by) {
            return this.usbDevice.getUsbConfiguration(by);
        }

        @Override
        public boolean containsUsbConfiguration(byte by) {
            return this.usbDevice.containsUsbConfiguration(by);
        }

        @Override
        public byte getActiveUsbConfigurationNumber() {
            return this.usbDevice.getActiveUsbConfigurationNumber();
        }

        @Override
        public UsbConfiguration getActiveUsbConfiguration() {
            return this.usbDevice.getActiveUsbConfiguration();
        }

        @Override
        public boolean isConfigured() {
            return this.usbDevice.isConfigured();
        }

        @Override
        public UsbDeviceDescriptor getUsbDeviceDescriptor() {
            return this.usbDevice.getUsbDeviceDescriptor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsbStringDescriptor getUsbStringDescriptor(byte by) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getUsbStringDescriptor(by);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(byte by) throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getString(by);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(UsbControlIrp usbControlIrp) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.syncSubmit(usbControlIrp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(UsbControlIrp usbControlIrp) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.asyncSubmit(usbControlIrp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(List list) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.syncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(List list) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.asyncSubmit(list);
            }
        }

        @Override
        public UsbControlIrp createUsbControlIrp(byte by, byte by2, short s, short s2) {
            return this.usbDevice.createUsbControlIrp(by, by2, s, s2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUsbDeviceListener(UsbDeviceListener usbDeviceListener) {
            Object object = this.listenerLock;
            synchronized (object) {
                this.usbDevice.addUsbDeviceListener(usbDeviceListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUsbDeviceListener(UsbDeviceListener usbDeviceListener) {
            Object object = this.listenerLock;
            synchronized (object) {
                this.usbDevice.removeUsbDeviceListener(usbDeviceListener);
            }
        }
    }
}

