/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.store;

import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.core.data.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HouseKeeperTask
implements Runnable {
    private static final Logger s_logger = LoggerFactory.getLogger(HouseKeeperTask.class);
    private final int m_purgeAge;
    private boolean doRepair;
    private final DataStore m_store;

    public HouseKeeperTask(DataStore store, int purgeAge, boolean doRepair) {
        this.m_purgeAge = purgeAge;
        this.m_store = store;
        this.doRepair = doRepair;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            s_logger.info("HouseKeeperTask started.");
            if (this.doRepair) {
                s_logger.info("HouseKeeperTask: Check store...");
                this.m_store.repair();
            }
            s_logger.info("HouseKeeperTask: Delete confirmed messages...");
            this.m_store.deleteStaleMessages(this.m_purgeAge);
            s_logger.info("HouseKeeperTask ended.");
        }
        catch (KuraStoreException me) {
            s_logger.warn("HouseCleaningTask exception", (Throwable)me);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                s_logger.info("HouseCleaningTask stopped");
            }
            s_logger.warn("HouseCleaningTask exception", t);
        }
    }
}

