/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.util;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.kura.core.util.SafeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(ProcessUtil.class);
    private static final ExecutorService s_processExecutor = Executors.newSingleThreadExecutor();

    public static SafeProcess exec(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        int count = st.countTokens();
        String[] cmdArray = new String[count];
        int i = 0;
        while (i < count) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return ProcessUtil.exec(cmdArray);
    }

    public static SafeProcess exec(final String[] cmdarray) throws IOException {
        Future<SafeProcess> futureSafeProcess = s_processExecutor.submit(new Callable<SafeProcess>(){

            @Override
            public SafeProcess call() throws Exception {
                Thread.currentThread().setName("SafeProcessExecutor");
                SafeProcess safeProcess = new SafeProcess();
                safeProcess.exec(cmdarray);
                return safeProcess;
            }
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            s_logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Deprecated
    public static void close(SafeProcess proc) {
    }

    public static void destroy(SafeProcess proc) {
        proc.destroy();
    }
}

