/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.firewall;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.ui.firewall.ButtonBar;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.TextFieldValidator;
import org.eclipse.kura.web.shared.model.GwtFirewallOpenPortEntry;
import org.eclipse.kura.web.shared.model.GwtNetProtocol;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.shared.event.ModalHideHandler;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class OpenPortsTabUi
extends Composite
implements Tab,
ButtonBar.Listener {
    private static final String STATUS_TABLE_ROW = "status-table-row";
    private static OpenPortsTabUiUiBinder uiBinder = (OpenPortsTabUiUiBinder)GWT.create(OpenPortsTabUiUiBinder.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final ListDataProvider<GwtFirewallOpenPortEntry> openPortsDataProvider = new ListDataProvider();
    final SingleSelectionModel<GwtFirewallOpenPortEntry> selectionModel = new SingleSelectionModel();
    private boolean dirty;
    GwtFirewallOpenPortEntry editOpenPortEntry;
    GwtFirewallOpenPortEntry newOpenPortEntry;
    GwtFirewallOpenPortEntry openPortEntry;
    @UiField
    ButtonBar buttonBar;
    @UiField
    Alert notification;
    @UiField
    AlertDialog alertDialog;
    @UiField
    Modal openPortsForm;
    @UiField
    FormGroup groupPort;
    @UiField
    FormGroup groupPermittedNw;
    @UiField
    FormGroup groupPermittedI;
    @UiField
    FormGroup groupUnpermittedI;
    @UiField
    FormGroup groupPermittedMac;
    @UiField
    FormGroup groupSource;
    @UiField
    FormLabel labelPort;
    @UiField
    FormLabel labelProtocol;
    @UiField
    FormLabel labelPermitttedNw;
    @UiField
    FormLabel labelPermitttedI;
    @UiField
    FormLabel labelUnPermitttedI;
    @UiField
    FormLabel labelPermitttedMac;
    @UiField
    FormLabel labelsource;
    @UiField
    TextBox port;
    @UiField
    TextBox permittedNw;
    @UiField
    TextBox permittedI;
    @UiField
    TextBox unpermittedI;
    @UiField
    TextBox permittedMac;
    @UiField
    TextBox source;
    @UiField
    Tooltip tooltipPermittedI;
    @UiField
    Tooltip tooltipUnpermittedI;
    @UiField
    Button submit;
    @UiField
    Button cancel;
    @UiField
    Modal existingRule;
    @UiField
    Button close;
    @UiField
    ListBox protocol;
    private HandlerRegistration modalHideHandlerRegistration;
    @UiField
    CellTable<GwtFirewallOpenPortEntry> openPortsGrid = new CellTable();

    public OpenPortsTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.openPortsGrid.setSelectionModel(this.selectionModel);
        this.initTable();
        this.initNewRuleModal();
        this.initDuplicateRuleModal();
        this.buttonBar.setListener(this);
    }

    private void initDuplicateRuleModal() {
        this.close.addClickHandler(event -> this.existingRule.hide());
    }

    @Override
    public void refresh() {
        EntryClassUi.showWaitModal();
        this.openPortsDataProvider.getList().clear();
        this.notification.setVisible(false);
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                OpenPortsTabUi.this.gwtNetworkService.findDeviceFirewallOpenPorts(token, new AsyncCallback<List<GwtFirewallOpenPortEntry>>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught, OpenPortsTabUi.this.gwtNetworkService.getClass().getSimpleName());
                    }

                    public void onSuccess(List<GwtFirewallOpenPortEntry> result) {
                        for (GwtFirewallOpenPortEntry pair : result) {
                            OpenPortsTabUi.this.openPortsDataProvider.getList().add(pair);
                        }
                        OpenPortsTabUi.this.refreshTable();
                        OpenPortsTabUi.this.setVisibility();
                        (this).OpenPortsTabUi.this.buttonBar.setDirty(false);
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean b) {
        this.dirty = b;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private void initTable() {
        TextColumn<GwtFirewallOpenPortEntry> col1 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getPortRange() != null) {
                    return String.valueOf(object.getPortRange());
                }
                return "";
            }
        };
        col1.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col1, MSGS.firewallOpenPort());
        TextColumn<GwtFirewallOpenPortEntry> col2 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getProtocol() != null) {
                    return String.valueOf(object.getProtocol());
                }
                return "";
            }
        };
        col2.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col2, MSGS.firewallOpenPortProtocol());
        TextColumn<GwtFirewallOpenPortEntry> col3 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getPermittedNetwork() != null) {
                    return String.valueOf(object.getPermittedNetwork());
                }
                return "";
            }
        };
        col3.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col3, MSGS.firewallOpenPortPermittedNetwork());
        TextColumn<GwtFirewallOpenPortEntry> col4 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getPermittedInterfaceName() != null) {
                    return String.valueOf(object.getPermittedInterfaceName());
                }
                return "";
            }
        };
        col4.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col4, MSGS.firewallOpenPortPermittedInterfaceName());
        TextColumn<GwtFirewallOpenPortEntry> col5 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getUnpermittedInterfaceName() != null) {
                    return String.valueOf(object.getUnpermittedInterfaceName());
                }
                return "";
            }
        };
        col5.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col5, MSGS.firewallOpenPortUnpermittedInterfaceName());
        TextColumn<GwtFirewallOpenPortEntry> col6 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getPermittedMAC() != null) {
                    return String.valueOf(object.getPermittedMAC());
                }
                return "";
            }
        };
        col6.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col6, MSGS.firewallOpenPortPermittedMac());
        TextColumn<GwtFirewallOpenPortEntry> col7 = new TextColumn<GwtFirewallOpenPortEntry>(){

            public String getValue(GwtFirewallOpenPortEntry object) {
                if (object.getSourcePortRange() != null) {
                    return String.valueOf(object.getSourcePortRange());
                }
                return "";
            }
        };
        col7.setCellStyleNames(STATUS_TABLE_ROW);
        this.openPortsGrid.addColumn((Column)col7, MSGS.firewallOpenPortSourcePortRange());
        this.openPortsDataProvider.addDataDisplay(this.openPortsGrid);
    }

    private void refreshTable() {
        int size = this.openPortsDataProvider.getList().size();
        this.openPortsGrid.setVisibleRange(0, size);
        this.openPortsDataProvider.flush();
        this.openPortsGrid.redraw();
    }

    @Override
    public void onApply() {
        List intermediateList = this.openPortsDataProvider.getList();
        final ArrayList<GwtFirewallOpenPortEntry> updatedOpenPortConf = new ArrayList<GwtFirewallOpenPortEntry>();
        for (GwtFirewallOpenPortEntry entry : intermediateList) {
            updatedOpenPortConf.add(entry);
        }
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex, OpenPortsTabUi.this.gwtXSRFService.getClass().getName());
            }

            public void onSuccess(GwtXSRFToken token) {
                OpenPortsTabUi.this.gwtNetworkService.updateDeviceFirewallOpenPorts(token, updatedOpenPortConf, new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught, OpenPortsTabUi.this.gwtNetworkService.getClass().getSimpleName());
                    }

                    public void onSuccess(Void result) {
                        (this).OpenPortsTabUi.this.buttonBar.setDirty(false);
                        EntryClassUi.hideWaitModal();
                        OpenPortsTabUi.this.setDirty(false);
                    }
                });
            }
        });
    }

    @Override
    public void onCancel() {
        this.alertDialog.show(MSGS.deviceConfigDirty(), this::refresh);
    }

    @Override
    public void onCreate() {
        this.replaceModalHideHandler(evt -> {
            if (this.newOpenPortEntry != null) {
                if (!this.duplicateEntry(this.newOpenPortEntry)) {
                    this.openPortsDataProvider.getList().add(this.newOpenPortEntry);
                    this.refreshTable();
                    this.setVisibility();
                    this.buttonBar.setDirty(true);
                } else {
                    this.existingRule.show();
                }
            }
        });
        this.showModal(null);
    }

    @Override
    public void onEdit() {
        GwtFirewallOpenPortEntry selection = (GwtFirewallOpenPortEntry)this.selectionModel.getSelectedObject();
        if (selection == null) {
            return;
        }
        this.replaceModalHideHandler(evt -> {
            if (this.editOpenPortEntry != null) {
                GwtFirewallOpenPortEntry oldEntry = (GwtFirewallOpenPortEntry)this.selectionModel.getSelectedObject();
                this.openPortsDataProvider.getList().remove(this.selectionModel.getSelectedObject());
                this.refreshTable();
                if (!this.duplicateEntry(this.editOpenPortEntry)) {
                    this.openPortsDataProvider.getList().add(this.editOpenPortEntry);
                    this.openPortsDataProvider.flush();
                    this.buttonBar.setDirty(true);
                    this.editOpenPortEntry = null;
                    this.setVisibility();
                } else {
                    this.existingRule.show();
                    this.openPortsDataProvider.getList().add(oldEntry);
                    this.openPortsDataProvider.flush();
                }
                this.refreshTable();
            }
        });
        AlertDialog.Listener listener = () -> this.showModal((GwtFirewallOpenPortEntry)this.selectionModel.getSelectedObject());
        if (selection.getPortRange().equals("22")) {
            this.alertDialog.show(MSGS.firewallOpenPorts22(), listener);
        } else if (selection.getPortRange().equals("80")) {
            this.alertDialog.show(MSGS.firewallOpenPorts80(), listener);
        } else {
            this.showModal(selection);
        }
    }

    @Override
    public void onDelete() {
        GwtFirewallOpenPortEntry selection = (GwtFirewallOpenPortEntry)this.selectionModel.getSelectedObject();
        if (selection != null) {
            this.alertDialog.show(MSGS.firewallOpenPortDeleteConfirmation(String.valueOf(selection.getPortRange())), () -> {
                this.openPortsDataProvider.getList().remove(this.selectionModel.getSelectedObject());
                this.refreshTable();
                this.buttonBar.setDirty(true);
                this.setVisibility();
                this.setDirty(true);
            });
        }
    }

    private void initNewRuleModal() {
        this.cancel.setText(MSGS.cancelButton());
        this.cancel.addClickHandler(event -> {
            this.openPortsForm.hide();
            this.openPortEntry = null;
            this.editOpenPortEntry = null;
            this.newOpenPortEntry = null;
        });
        this.submit.setText(MSGS.submitButton());
        this.submit.addClickHandler(event -> {
            this.checkFieldsValues();
            if (this.groupPort.getValidationState() == ValidationState.ERROR || this.groupPermittedNw.getValidationState() == ValidationState.ERROR || this.groupPermittedI.getValidationState() == ValidationState.ERROR || this.groupUnpermittedI.getValidationState() == ValidationState.ERROR || this.groupPermittedMac.getValidationState() == ValidationState.ERROR || this.groupSource.getValidationState() == ValidationState.ERROR) {
                return;
            }
            this.openPortEntry = new GwtFirewallOpenPortEntry();
            this.openPortEntry.setPortRange(this.port.getText());
            this.openPortEntry.setProtocol(this.protocol.getSelectedItemText());
            this.openPortEntry.setPermittedNetwork(OpenPortsTabUi.validOrDefault(this.permittedNw.getText(), "0.0.0.0/0"));
            this.openPortEntry.setPermittedInterfaceName(OpenPortsTabUi.validOrDefault(this.permittedI.getText(), null));
            this.openPortEntry.setUnpermittedInterfaceName(OpenPortsTabUi.validOrDefault(this.unpermittedI.getText(), null));
            this.openPortEntry.setPermittedMAC(OpenPortsTabUi.validOrDefault(this.permittedMac.getText(), null));
            this.openPortEntry.setSourcePortRange(OpenPortsTabUi.validOrDefault(this.source.getText(), null));
            if (this.submit.getId().equals("new")) {
                this.newOpenPortEntry = this.openPortEntry;
                this.editOpenPortEntry = null;
            } else if (this.submit.getId().equals("edit")) {
                this.editOpenPortEntry = this.openPortEntry;
                this.newOpenPortEntry = null;
            }
            this.setDirty(true);
            this.openPortsForm.hide();
        });
    }

    private static String validOrDefault(String str, String defaultValue) {
        if (str == null || str.trim().isEmpty()) {
            return defaultValue;
        }
        return str;
    }

    private void showModal(GwtFirewallOpenPortEntry existingEntry) {
        if (existingEntry == null) {
            this.openPortsForm.setTitle(MSGS.firewallOpenPortFormInformation());
        } else {
            this.openPortsForm.setTitle(MSGS.firewallOpenPortFormUpdate(String.valueOf(existingEntry.getPortRange())));
        }
        this.setModalFieldsLabels();
        this.setModalFieldsValues(existingEntry);
        this.setModalFieldsTooltips();
        this.setModalFieldsHandlers();
        if (existingEntry == null) {
            this.submit.setId("new");
        } else {
            this.submit.setId("edit");
        }
        this.openPortsForm.show();
    }

    private void setModalFieldsHandlers() {
        this.permittedI.addChangeHandler(event -> {
            if (!this.permittedI.getText().trim().isEmpty()) {
                this.unpermittedI.clear();
                this.unpermittedI.setEnabled(false);
            } else {
                this.unpermittedI.setEnabled(true);
            }
        });
        this.unpermittedI.addChangeHandler(event -> {
            if (!this.unpermittedI.getText().trim().isEmpty()) {
                this.permittedI.clear();
                this.permittedI.setEnabled(false);
            } else {
                this.permittedI.setEnabled(true);
            }
        });
        this.port.addBlurHandler(event -> {
            if (!this.port.getText().trim().matches(TextFieldValidator.FieldType.PORT_RANGE.getRegex()) && this.port.getText().trim().length() != 0 || this.port.getText() == null || "".equals(this.port.getText().trim())) {
                this.groupPort.setValidationState(ValidationState.ERROR);
            } else {
                this.groupPort.setValidationState(ValidationState.NONE);
            }
        });
        this.permittedNw.addBlurHandler(event -> {
            if (!this.permittedNw.getText().trim().matches(TextFieldValidator.FieldType.NETWORK.getRegex()) && this.permittedNw.getText().trim().length() > 0) {
                this.groupPermittedNw.setValidationState(ValidationState.ERROR);
            } else {
                this.groupPermittedNw.setValidationState(ValidationState.NONE);
            }
        });
        this.permittedI.addBlurHandler(event -> {
            if (!this.permittedI.getText().trim().matches(TextFieldValidator.FieldType.ALPHANUMERIC.getRegex()) && this.permittedI.getText().trim().length() > 0) {
                this.groupPermittedI.setValidationState(ValidationState.ERROR);
            } else {
                this.groupPermittedI.setValidationState(ValidationState.NONE);
            }
        });
        this.unpermittedI.addBlurHandler(event -> {
            if (!this.unpermittedI.getText().trim().matches(TextFieldValidator.FieldType.ALPHANUMERIC.getRegex()) && this.unpermittedI.getText().trim().length() > 0) {
                this.groupUnpermittedI.setValidationState(ValidationState.ERROR);
            } else {
                this.groupPermittedI.setValidationState(ValidationState.NONE);
            }
        });
        this.permittedMac.addBlurHandler(event -> {
            if (!this.permittedMac.getText().trim().matches(TextFieldValidator.FieldType.MAC_ADDRESS.getRegex()) && this.permittedMac.getText().trim().length() > 0) {
                this.groupPermittedMac.setValidationState(ValidationState.ERROR);
            } else {
                this.groupPermittedMac.setValidationState(ValidationState.NONE);
            }
        });
        this.source.addBlurHandler(event -> {
            if (!this.source.getText().trim().matches(TextFieldValidator.FieldType.PORT_RANGE.getRegex()) && this.source.getText().trim().length() > 0) {
                this.groupSource.setValidationState(ValidationState.ERROR);
            } else {
                this.groupSource.setValidationState(ValidationState.NONE);
            }
        });
    }

    private void setModalFieldsTooltips() {
        this.tooltipPermittedI.setTitle(MSGS.firewallOpenPortFormPermittedInterfaceToolTip());
        this.tooltipPermittedI.reconfigure();
        this.tooltipUnpermittedI.setTitle(MSGS.firewallOpenPortFormUnpermittedInterfaceToolTip());
        this.tooltipUnpermittedI.reconfigure();
    }

    private void setModalFieldsValues(GwtFirewallOpenPortEntry existingEntry) {
        if (existingEntry != null) {
            this.port.setText(String.valueOf(existingEntry.getPortRange()));
            this.protocol.setSelectedIndex(existingEntry.getProtocol().equals(GwtNetProtocol.tcp.name()) ? 0 : 1);
            this.permittedNw.setText(existingEntry.getPermittedNetwork());
            this.permittedI.setText(existingEntry.getPermittedInterfaceName());
            this.unpermittedI.setText(existingEntry.getUnpermittedInterfaceName());
            this.permittedMac.setText(existingEntry.getPermittedMAC());
            this.source.setText(existingEntry.getSourcePortRange());
        } else {
            this.port.setText("");
            this.protocol.setSelectedIndex(0);
            this.permittedNw.setText("");
            this.permittedI.setText("");
            this.permittedI.setEnabled(true);
            this.unpermittedI.setText("");
            this.unpermittedI.setEnabled(true);
            this.permittedMac.setText("");
            this.source.setText("");
        }
    }

    private void setModalFieldsLabels() {
        this.labelPort.setText(String.valueOf(MSGS.firewallOpenPortFormPort()) + "*");
        this.labelProtocol.setText(MSGS.firewallOpenPortFormProtocol());
        this.protocol.clear();
        this.protocol.addItem(GwtNetProtocol.tcp.name());
        this.protocol.addItem(GwtNetProtocol.udp.name());
        this.labelPermitttedNw.setText(MSGS.firewallOpenPortFormPermittedNetwork());
        this.labelPermitttedI.setText(MSGS.firewallOpenPortFormPermittedInterfaceName());
        this.labelUnPermitttedI.setText(MSGS.firewallOpenPortFormUnpermittedInterfaceName());
        this.labelPermitttedMac.setText(MSGS.firewallOpenPortFormPermittedMac());
        this.labelsource.setText(MSGS.firewallOpenPortFormSourcePortRange());
    }

    private void checkFieldsValues() {
        if (this.port.getText().trim().isEmpty()) {
            this.groupPort.setValidationState(ValidationState.ERROR);
        }
    }

    private boolean duplicateEntry(GwtFirewallOpenPortEntry openPortEntry) {
        List entries = this.openPortsDataProvider.getList();
        if (entries != null && openPortEntry != null) {
            for (GwtFirewallOpenPortEntry entry : entries) {
                Map<String, Object> savedEntry = entry.getProperties();
                Map<String, Object> newEntry = openPortEntry.getProperties();
                if (!newEntry.equals(savedEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private void setVisibility() {
        if (this.openPortsDataProvider.getList().isEmpty()) {
            this.openPortsGrid.setVisible(false);
            this.notification.setVisible(true);
            this.notification.setText(MSGS.firewallOpenPortTableNoPorts());
        } else {
            this.openPortsGrid.setVisible(true);
            this.notification.setVisible(false);
        }
    }

    private void replaceModalHideHandler(ModalHideHandler hideHandler) {
        if (this.modalHideHandlerRegistration != null) {
            this.modalHideHandlerRegistration.removeHandler();
        }
        this.modalHideHandlerRegistration = this.openPortsForm.addHideHandler(hideHandler);
    }

    static interface OpenPortsTabUiUiBinder
    extends UiBinder<Widget, OpenPortsTabUi> {
    }
}

