/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.cloudlet.serialization.response;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.internal.asset.cloudlet.serialization.response.AbstractResponse;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;

public class ChannelOperationResponse
extends AbstractResponse {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();

    private ChannelStatus getChannelStatus(ChannelRecord record) {
        ChannelStatus status = record.getChannelStatus();
        if (status == null || status.getChannelFlag() == ChannelFlag.FAILURE && status.getExceptionMessage() == null) {
            status = new ChannelStatus(ChannelFlag.FAILURE, "Unknown error", null);
        }
        return status;
    }

    public void reportAllFailed(String assetName, Iterator<String> channelNames, String errorMessage) {
        JsonObject assetObject = Json.object();
        assetObject.add("name", assetName);
        JsonArray channels = new JsonArray();
        channelNames.forEachRemaining(channelName -> {
            JsonObject channelObject = Json.object();
            channelObject.add("name", channelName);
            channelObject.add("timestamp", System.currentTimeMillis());
            channelObject.add("error", errorMessage);
            channels.add((JsonValue)channelObject);
        });
        assetObject.add("channels", (JsonValue)channels);
        this.serialized.add((JsonValue)assetObject);
    }

    public void reportResult(String assetName, List<ChannelRecord> list) {
        JsonObject assetObject = Json.object();
        assetObject.add("name", assetName);
        JsonArray channels = new JsonArray();
        for (ChannelRecord record : list) {
            JsonObject channelObject = Json.object();
            channelObject.add("name", record.getChannelName());
            long timestamp = record.getTimestamp();
            if (timestamp == 0L) {
                timestamp = System.currentTimeMillis();
            }
            channelObject.add("timestamp", timestamp);
            ChannelStatus status = this.getChannelStatus(record);
            TypedValue value = record.getValue();
            if (ChannelFlag.SUCCESS == status.getChannelFlag() && value != null) {
                DataType type = value.getType();
                String stringValue = DataType.BYTE_ARRAY == type ? BASE64_ENCODER.encodeToString((byte[])value.getValue()) : value.getValue().toString();
                channelObject.add("value", stringValue);
                channelObject.add("type", type.toString());
            } else {
                channelObject.add("error", status.getExceptionMessage());
            }
            channels.add((JsonValue)channelObject);
        }
        assetObject.add("channels", (JsonValue)channels);
        this.serialized.add((JsonValue)assetObject);
    }
}

