/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Designate;
import org.eclipse.kura.configuration.metatype.MetaData;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.core.configuration.metatype.Tmetadata;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.util.StringUtil;
import org.eclipse.kura.core.util.IOUtil;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtil {
    private static final Logger logger = LoggerFactory.getLogger(ComponentUtil.class);

    public static Map<String, Tmetadata> getMetadata(BundleContext ctx, Bundle bnd) {
        HashMap<String, Tmetadata> bundleMetadata = new HashMap<String, Tmetadata>();
        ServiceReference ref = ctx.getServiceReference(MetaTypeService.class);
        MetaTypeService metaTypeService = (MetaTypeService)ctx.getService(ref);
        try {
            MetaTypeInformation mti = metaTypeService.getMetaTypeInformation(bnd);
            if (mti != null) {
                ArrayList<String> pids = new ArrayList<String>();
                pids.addAll(Arrays.asList(mti.getPids()));
                pids.addAll(Arrays.asList(mti.getFactoryPids()));
                if (pids != null) {
                    for (String pid : pids) {
                        try {
                            Tmetadata metadata = ComponentUtil.readMetadata(bnd, pid);
                            if (metadata == null) continue;
                            bundleMetadata.put(pid, metadata);
                        }
                        catch (Exception e) {
                            logger.warn("Error loading Metadata for pid " + pid, (Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            ctx.ungetService(ref);
        }
        return bundleMetadata;
    }

    public static Designate getDesignate(Tmetadata metadata, String pid) {
        if (metadata == null || pid == null) {
            return null;
        }
        List<Designate> designates = metadata.getDesignate();
        if (designates == null) {
            return null;
        }
        for (Designate designate : designates) {
            if (pid.equals(designate.getPid())) {
                return designate;
            }
            if (!pid.equals(designate.getFactoryPid())) continue;
            return designate;
        }
        return null;
    }

    public static OCD getOCD(Tmetadata metadata, String pid) {
        if (metadata.getOCD() != null && !metadata.getOCD().isEmpty()) {
            for (OCD ocd : metadata.getOCD()) {
                if (ocd.getId() == null || !ocd.getId().equals(pid)) continue;
                return ocd;
            }
        }
        return null;
    }

    public static Map<String, OCD> getObjectClassDefinition(BundleContext ctx, Bundle bnd) {
        String[] pids;
        HashMap<String, OCD> bundleDefaults = new HashMap<String, OCD>();
        ServiceReference ref = ctx.getServiceReference(MetaTypeService.class);
        MetaTypeService metaTypeService = (MetaTypeService)ctx.getService(ref);
        MetaTypeInformation mti = metaTypeService.getMetaTypeInformation(bnd);
        if (mti != null && (pids = mti.getPids()) != null) {
            String[] stringArray = pids;
            int n = pids.length;
            int n2 = 0;
            while (n2 < n) {
                String pid = stringArray[n2];
                Tocd ocd = null;
                try {
                    ocd = ComponentUtil.readObjectClassDefinition(bnd, pid);
                    if (ocd != null) {
                        bundleDefaults.put(pid, ocd);
                    }
                }
                catch (Exception e) {
                    logger.warn("Error loading OCD for pid " + pid, (Throwable)e);
                }
                ++n2;
            }
        }
        return bundleDefaults;
    }

    public static ObjectClassDefinition getObjectClassDefinition(BundleContext ctx, String pid) {
        ServiceReference ref = ctx.getServiceReference(MetaTypeService.class);
        MetaTypeService metaTypeService = (MetaTypeService)ctx.getService(ref);
        MetaTypeInformation mti = metaTypeService.getMetaTypeInformation(ctx.getBundle());
        ObjectClassDefinition ocd = null;
        try {
            if (mti != null) {
                ocd = mti.getObjectClassDefinition(pid, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return ocd;
    }

    public static Tmetadata readMetadata(Bundle bundle, String pid) throws IOException, Exception, XMLStreamException, FactoryConfigurationError {
        Tmetadata metaData = null;
        StringBuilder sbMetatypeXmlName = new StringBuilder();
        sbMetatypeXmlName.append("OSGI-INF/metatype/").append(pid).append(".xml");
        String metatypeXmlName = sbMetatypeXmlName.toString();
        String metatypeXml = IOUtil.readResource((Bundle)bundle, (String)metatypeXmlName);
        if (metatypeXml != null) {
            metaData = ComponentUtil.unmarshal(metatypeXml, Tmetadata.class);
        }
        return metaData;
    }

    public static OCD readObjectClassDefinition(URL resourceUrl) throws IOException, XMLStreamException, FactoryConfigurationError, Exception {
        OCD ocd = null;
        String metatypeXml = IOUtil.readResource((URL)resourceUrl);
        if (metatypeXml != null) {
            MetaData metaData = ComponentUtil.unmarshal(metatypeXml, MetaData.class);
            if (metaData.getOCD() != null && !metaData.getOCD().isEmpty()) {
                ocd = (OCD)metaData.getOCD().get(0);
            } else {
                logger.warn("Cannot find OCD for component with url: {}", (Object)resourceUrl.toString());
            }
        }
        return ocd;
    }

    public static Tocd readObjectClassDefinition(String pid) throws IOException, Exception, XMLStreamException, FactoryConfigurationError {
        Tocd ocd = null;
        StringBuilder sbMetatypeXmlName = new StringBuilder();
        sbMetatypeXmlName.append("OSGI-INF/metatype/").append(pid).append(".xml");
        String metatypeXmlName = sbMetatypeXmlName.toString();
        String metatypeXml = IOUtil.readResource((String)metatypeXmlName);
        if (metatypeXml != null) {
            Tmetadata metaData = ComponentUtil.unmarshal(metatypeXml, Tmetadata.class);
            if (metaData.getOCD() != null && !metaData.getOCD().isEmpty()) {
                ocd = (Tocd)metaData.getOCD().get(0);
            } else {
                logger.warn("Cannot find OCD for component with pid: {}", (Object)pid);
            }
        }
        return ocd;
    }

    public static Tocd readObjectClassDefinition(Bundle bundle, String pid) throws IOException, Exception, XMLStreamException, FactoryConfigurationError {
        Tmetadata metaData;
        Tocd ocd = null;
        StringBuilder sbMetatypeXmlName = new StringBuilder();
        sbMetatypeXmlName.append("OSGI-INF/metatype/").append(pid).append(".xml");
        String metatypeXmlName = sbMetatypeXmlName.toString();
        String metatypeXml = IOUtil.readResource((Bundle)bundle, (String)metatypeXmlName);
        if (metatypeXml != null && (metaData = ComponentUtil.unmarshal(metatypeXml, Tmetadata.class)).getOCD() != null && !metaData.getOCD().isEmpty()) {
            ocd = (Tocd)metaData.getOCD().get(0);
        }
        return ocd;
    }

    public static Map<String, Object> getDefaultProperties(OCD ocd, ComponentContext ctx) {
        List attrDefs;
        HashMap<String, Object> defaults = null;
        defaults = new HashMap<String, Object>();
        if (ocd != null && (attrDefs = ocd.getAD()) != null) {
            for (AD attrDef : attrDefs) {
                String id = attrDef.getId();
                Object defaultValue = ComponentUtil.getDefaultValue(attrDef, ctx);
                if (defaults.get(id) != null || defaultValue == null) continue;
                defaults.put(id, defaultValue);
            }
        }
        return defaults;
    }

    private static Object getDefaultValue(AD attrDef, ComponentContext ctx) {
        String defaultValue = attrDef.getDefault();
        if (defaultValue == null || defaultValue.length() == 0) {
            return null;
        }
        Object[] objectValues = null;
        Scalar type = attrDef.getType();
        if (type != null) {
            String[] defaultValues = new String[]{defaultValue};
            int cardinality = attrDef.getCardinality();
            if (cardinality != 0 || cardinality != 1 || cardinality != -1) {
                defaultValues = StringUtil.splitValues(defaultValue);
            }
            if ((objectValues = ComponentUtil.getObjectValue(type, defaultValues, ctx)) != null && (cardinality == 0 || cardinality == 1 || cardinality == -1)) {
                return objectValues[0];
            }
        } else {
            logger.warn("Unknown type for attribute {}", (Object)attrDef.getId());
        }
        return objectValues;
    }

    private static Object[] getObjectValue(Scalar type, String[] defaultValues, ComponentContext ctx) {
        ArrayList<Comparable<Boolean>> values = new ArrayList<Comparable<Boolean>>();
        switch (type) {
            case BOOLEAN: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    values.add(Boolean.valueOf(value));
                    ++n2;
                }
                return values.toArray(new Boolean[0]);
            }
            case BYTE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    values.add(Byte.valueOf(value));
                    ++n3;
                }
                return values.toArray(new Byte[0]);
            }
            case CHAR: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n4 = 0;
                while (n4 < n) {
                    String value = stringArray[n4];
                    values.add(Character.valueOf(value.charAt(0)));
                    ++n4;
                }
                return values.toArray(new Character[0]);
            }
            case DOUBLE: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n5 = 0;
                while (n5 < n) {
                    String value = stringArray[n5];
                    values.add(Double.valueOf(value));
                    ++n5;
                }
                return values.toArray(new Double[0]);
            }
            case FLOAT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n6 = 0;
                while (n6 < n) {
                    String value = stringArray[n6];
                    values.add(Float.valueOf(value));
                    ++n6;
                }
                return values.toArray(new Float[0]);
            }
            case INTEGER: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n7 = 0;
                while (n7 < n) {
                    String value = stringArray[n7];
                    values.add(Integer.valueOf(value));
                    ++n7;
                }
                return values.toArray(new Integer[0]);
            }
            case LONG: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n8 = 0;
                while (n8 < n) {
                    String value = stringArray[n8];
                    values.add(Long.valueOf(value));
                    ++n8;
                }
                return values.toArray(new Long[0]);
            }
            case SHORT: {
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n9 = 0;
                while (n9 < n) {
                    String value = stringArray[n9];
                    values.add(Short.valueOf(value));
                    ++n9;
                }
                return values.toArray(new Short[0]);
            }
            case PASSWORD: {
                ServiceReference sr = ctx.getBundleContext().getServiceReference(CryptoService.class);
                CryptoService cryptoService = (CryptoService)ctx.getBundleContext().getService(sr);
                String[] stringArray = defaultValues;
                int n = defaultValues.length;
                int n10 = 0;
                while (n10 < n) {
                    String value = stringArray[n10];
                    try {
                        values.add((Comparable<Boolean>)new Password(cryptoService.encryptAes(value.toCharArray())));
                    }
                    catch (Exception exception) {
                        values.add((Comparable<Boolean>)new Password(value));
                    }
                    ++n10;
                }
                return values.toArray(new Password[0]);
            }
            case STRING: {
                return defaultValues;
            }
        }
        return null;
    }

    private static ServiceReference<Unmarshaller>[] getXmlUnmarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)FrameworkUtil.getBundle(ComponentUtil.class).getBundleContext(), Unmarshaller.class, (String)filterString);
    }

    private static void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)FrameworkUtil.getBundle(ComponentUtil.class).getBundleContext(), refs);
    }

    protected static <T> T unmarshal(String string, Class<T> clazz) throws KuraException {
        Object result;
        block7: {
            result = null;
            ServiceReference<Unmarshaller>[] unmarshallerSRs = ComponentUtil.getXmlUnmarshallers();
            try {
                try {
                    ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
                    int n = unmarshallerSRs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                        Unmarshaller unmarshaller = (Unmarshaller)FrameworkUtil.getBundle(ComponentUtil.class).getBundleContext().getService(unmarshallerSR);
                        result = unmarshaller.unmarshal(string, clazz);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    logger.warn("Failed to extract persisted configuration.");
                    ComponentUtil.ungetServiceReferences(unmarshallerSRs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                ComponentUtil.ungetServiceReferences(unmarshallerSRs);
                throw throwable;
            }
            ComponentUtil.ungetServiceReferences(unmarshallerSRs);
        }
        if (result == null) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{"value"});
        }
        return (T)result;
    }
}

