/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.wifi;

import java.util.Arrays;
import java.util.List;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiBgscanModule;
import org.eclipse.kura.net.wifi.WifiChannel;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class WifiConfig
implements NetConfig {
    private WifiMode mode;
    private String ssid;
    private int[] channels;
    private WifiSecurity security;
    private WifiCiphers pairwiseCiphers;
    private WifiCiphers groupCiphers;
    private Password passkey;
    private String hwMode;
    private WifiRadioMode radioMode;
    private boolean broadcast;
    private WifiBgscan bgscan;
    private boolean pingAccessPoint = false;
    private boolean ignoreSSID;
    private String driver;
    List<WifiChannel> channelFrequencies;
    private String wifiCountryCode;

    public WifiConfig() {
    }

    public WifiConfig(WifiMode mode, String ssid, int[] channels, WifiSecurity security, String passkey, String hwMode, boolean broadcast, WifiBgscan bgscan) {
        this.mode = mode;
        this.ssid = ssid;
        this.channels = channels;
        this.security = security;
        this.passkey = new Password(passkey);
        this.hwMode = hwMode;
        this.broadcast = broadcast;
        this.bgscan = bgscan;
        this.channelFrequencies = null;
        this.wifiCountryCode = null;
    }

    public WifiMode getMode() {
        return this.mode;
    }

    public void setMode(WifiMode mode) {
        this.mode = mode;
    }

    public String getSSID() {
        return this.ssid;
    }

    public void setSSID(String ssid) {
        this.ssid = ssid;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int[] getChannels() {
        return this.channels;
    }

    public void setChannels(int[] channels) {
        this.channels = channels;
    }

    public WifiSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WifiSecurity security) {
        this.security = security;
    }

    public WifiCiphers getPairwiseCiphers() {
        return this.pairwiseCiphers;
    }

    public void setPairwiseCiphers(WifiCiphers pairwise) {
        this.pairwiseCiphers = pairwise;
    }

    public WifiCiphers getGroupCiphers() {
        return this.groupCiphers;
    }

    public void setGroupCiphers(WifiCiphers group) {
        this.groupCiphers = group;
    }

    public Password getPasskey() {
        return this.passkey;
    }

    public void setPasskey(String key) {
        Password psswd;
        this.passkey = psswd = new Password(key);
    }

    public String getHardwareMode() {
        return this.hwMode;
    }

    public void setHardwareMode(String hwMode) {
        this.hwMode = hwMode;
    }

    public WifiRadioMode getRadioMode() {
        return this.radioMode;
    }

    public void setRadioMode(WifiRadioMode radioMode) {
        this.radioMode = radioMode;
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public WifiBgscan getBgscan() {
        return this.bgscan;
    }

    public void setBgscan(WifiBgscan bgscan) {
        this.bgscan = bgscan;
    }

    public boolean pingAccessPoint() {
        return this.pingAccessPoint;
    }

    public void setPingAccessPoint(boolean pingAP) {
        this.pingAccessPoint = pingAP;
    }

    public boolean ignoreSSID() {
        return this.ignoreSSID;
    }

    public void setIgnoreSSID(boolean ignoreSSID) {
        this.ignoreSSID = ignoreSSID;
    }

    public String getWifiCountryCode() {
        return this.wifiCountryCode;
    }

    public void setWifiCountryCode(String wifiCountryCode) {
        this.wifiCountryCode = wifiCountryCode;
    }

    public List<WifiChannel> getChannelFrequencies() {
        return this.channelFrequencies;
    }

    public void setChannelFrequencies(List<WifiChannel> channelFrequencies) {
        this.channelFrequencies = channelFrequencies;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 29 * result + (this.ssid == null ? 0 : this.ssid.hashCode());
        result = 29 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 29 * result + (this.wifiCountryCode == null ? 0 : this.wifiCountryCode.hashCode());
        if (this.channels != null) {
            int[] nArray = this.channels;
            int n = this.channels.length;
            int n2 = 0;
            while (n2 < n) {
                int channel = nArray[n2];
                result = 29 * result + channel;
                ++n2;
            }
        } else {
            result *= 29;
        }
        if (this.channelFrequencies != null) {
            for (WifiChannel wc : this.channelFrequencies) {
                result = 29 * result + wc.hashCode();
            }
        } else {
            result *= 29;
        }
        result = 29 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 29 * result + (this.passkey == null ? 0 : this.passkey.hashCode());
        result = 29 * result + (this.hwMode == null ? 0 : this.hwMode.hashCode());
        result = 29 * result + (this.radioMode == null ? 0 : this.radioMode.hashCode());
        result = 29 * result + (this.broadcast ? 1021 : 1031);
        result = 29 * result + (this.pairwiseCiphers == null ? 0 : WifiCiphers.getCode(this.pairwiseCiphers));
        result = 29 * result + (this.groupCiphers == null ? 0 : WifiCiphers.getCode(this.groupCiphers));
        if (this.bgscan != null) {
            result = 29 * result + (this.bgscan.getModule() == null ? 0 : WifiBgscanModule.getCode(this.bgscan.getModule()));
            result = 29 * result + this.bgscan.getRssiThreshold();
            result = 29 * result + this.bgscan.getShortInterval();
            result = 29 * result + this.bgscan.getLongInterval();
        } else {
            result *= 29;
        }
        result = 29 * result + (this.pingAccessPoint ? 1 : 0);
        result = 29 * result + (this.ignoreSSID ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WifiConfig)) {
            return false;
        }
        WifiConfig other = (WifiConfig)obj;
        if (!this.compare((Object)this.mode, (Object)other.mode)) {
            return false;
        }
        if (!this.compare(this.ssid, other.ssid)) {
            return false;
        }
        if (!this.compare(this.driver, other.driver)) {
            return false;
        }
        if (!Arrays.equals(this.channels, other.channels)) {
            return false;
        }
        if (!this.compare(this.wifiCountryCode, other.wifiCountryCode)) {
            return false;
        }
        if (!this.compare((Object)this.security, (Object)other.security)) {
            return false;
        }
        if (!this.compare((Object)this.pairwiseCiphers, (Object)other.pairwiseCiphers)) {
            return false;
        }
        if (!this.compare((Object)this.groupCiphers, (Object)other.groupCiphers)) {
            return false;
        }
        if (!this.compare(this.passkey.toString(), other.passkey.toString())) {
            return false;
        }
        if (!this.compare(this.hwMode, other.hwMode)) {
            return false;
        }
        if (!this.compare((Object)this.radioMode, (Object)other.radioMode)) {
            return false;
        }
        if (!this.compare(this.bgscan, other.bgscan)) {
            return false;
        }
        if (this.broadcast != other.broadcast) {
            return false;
        }
        if (this.pingAccessPoint != other.pingAccessPoint()) {
            return false;
        }
        return this.ignoreSSID == other.ignoreSSID();
    }

    private boolean compare(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    @Override
    public boolean isValid() {
        return this.mode != null;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("WifiConfig [");
        if (this.mode != null) {
            sb.append("mode: ").append((Object)this.mode).append(" :: ");
        }
        if (this.ssid != null) {
            sb.append("ssid: ").append(this.ssid).append(" :: ");
        }
        sb.append("ignoreSSID: ").append(this.ignoreSSID).append(" :: ");
        if (this.driver != null) {
            sb.append("driver: ").append(this.driver).append(" :: ");
        }
        if (this.channels != null && this.channels.length > 0) {
            sb.append("channels: ");
            i = 0;
            while (i < this.channels.length) {
                sb.append(this.channels[i]);
                if (i + i < this.channels.length) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append(" :: ");
        }
        if (this.security != null) {
            sb.append("security: ").append((Object)this.security).append(" :: ");
        }
        if (this.pairwiseCiphers != null) {
            sb.append("pairwiseCiphers: ").append((Object)this.pairwiseCiphers).append(" :: ");
        }
        if (this.groupCiphers != null) {
            sb.append("groupCiphers: ").append((Object)this.groupCiphers).append(" :: ");
        }
        if (this.passkey != null) {
            sb.append("passkey: ").append(this.passkey).append(" :: ");
        }
        if (this.hwMode != null) {
            sb.append("hwMode: ").append(this.hwMode).append(" :: ");
        }
        if (this.radioMode != null) {
            sb.append("radioMode: ").append((Object)this.radioMode).append(" :: ");
        }
        sb.append("broadcast: ").append(this.broadcast).append(" :: ");
        if (this.bgscan != null) {
            sb.append("bgscan: ").append(this.bgscan).append(" :: ");
        }
        if (this.wifiCountryCode != null) {
            sb.append("countryCode: ").append(this.wifiCountryCode).append(" :: ");
        }
        if (this.channelFrequencies != null) {
            sb.append("channelFrequencies: ");
            i = 0;
            for (WifiChannel wc : this.channelFrequencies) {
                sb.append(wc);
                if (i++ == this.channelFrequencies.size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

