/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.base;

import java.util.Iterator;
import java.util.Objects;
import org.eclipse.kura.annotation.Nullable;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String join(CharSequence delimiter, Iterable<?> tokens) {
        Objects.requireNonNull(delimiter, "Delimiter cannot be null.");
        Objects.requireNonNull(tokens, "Iterable elements cannot be null.");
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = tokens.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(delimiter);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }
}

