/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraProcessExecutionErrorException;
import org.eclipse.kura.core.system.SuperSystemService;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.system.ExtendedProperties;
import org.eclipse.kura.system.SystemResourceInfo;
import org.eclipse.kura.system.SystemResourceType;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemServiceImpl
extends SuperSystemService
implements SystemService {
    private static final String PROPERTY_PROVIDER_SUFFIX = ".provider";
    private static final String DMIDECODE_COMMAND = "dmidecode -t system";
    private static final String SPACES_REGEX = ":\\s+";
    private static final String BIN_SH = "/bin/sh";
    private static final String LINUX_2_6_34_12_WR4_3_0_0_STANDARD = "2.6.34.12-WR4.3.0.0_standard";
    private static final String LINUX_2_6_34_9_WR4_2_0_0_STANDARD = "2.6.34.9-WR4.2.0.0_standard";
    private static final Logger logger = LoggerFactory.getLogger(SystemServiceImpl.class);
    private static final String CLOUDBEES_SECURITY_SETTINGS_PATH = "/private/eurotech/settings-security.xml";
    private static final String LOG4J_CONFIGURATION = "log4j.configuration";
    private static final String DPA_CONFIGURATION = "dpa.configuration";
    private static final String KURA_PATH = "/opt/eclipse/kura";
    private static final String OS_WINDOWS = "windows";
    private static boolean onCloudbees = false;
    private Properties kuraProperties;
    private ComponentContext componentContext;
    private NetworkService networkService;
    private CommandExecutorService executorService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.networkService = null;
    }

    public void setExecutorService(CommandExecutorService executorService) {
        this.executorService = executorService;
    }

    public void unsetExecutorService(CommandExecutorService executorService) {
        this.executorService = null;
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        AccessController.doPrivileged(() -> {
            try {
                onCloudbees = new File(CLOUDBEES_SECURITY_SETTINGS_PATH).exists();
                return null;
            }
            catch (Exception exception) {
                logger.warn("Unable to execute privileged in SystemService");
                return null;
            }
        });
        Properties kuraDefaults = new Properties();
        boolean updateTriggered = false;
        try {
            File directory;
            if (System.getProperty("kura.configuration") != null && System.getProperty("kura.configuration").trim().equals("file:kura/kura.properties")) {
                System.setProperty("kura.configuration", "file:/opt/eclipse/kura/framework/kura.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.properties location");
            }
            if (System.getProperty(DPA_CONFIGURATION) != null && System.getProperty(DPA_CONFIGURATION).trim().equals("kura/dpa.properties")) {
                System.setProperty(DPA_CONFIGURATION, "/opt/eclipse/kura/packages/dpa.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid dpa.properties location");
            }
            if (System.getProperty(LOG4J_CONFIGURATION) != null && System.getProperty(LOG4J_CONFIGURATION).trim().equals("file:kura/log4j.properties")) {
                System.setProperty(LOG4J_CONFIGURATION, "file:/opt/eclipse/kura/user/log4j.properties");
                updateTriggered = true;
                logger.warn("Overridding invalid log4j.properties location");
            }
            String kuraHome = System.getProperty("kura.home");
            String kuraFrameworkConfig = System.getProperty("kura.framework.config");
            String kuraUserConfig = System.getProperty("kura.user.config");
            String kuraConfig = System.getProperty("kura.configuration");
            String kuraProps = this.readResource("kura.properties");
            if (kuraProps != null) {
                kuraDefaults.load(new StringReader(kuraProps));
                logger.info("Loaded Jar Resource kura.properties.");
            } else if (kuraConfig != null) {
                this.loadKuraDefaults(kuraDefaults, kuraConfig);
            } else if (kuraFrameworkConfig != null) {
                File kuraPropsFile = new File(String.valueOf(kuraFrameworkConfig) + File.separator + "kura.properties");
                if (kuraPropsFile.exists()) {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (FileReader fr = new FileReader(kuraPropsFile);){
                        kuraDefaults.load(fr);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    logger.info("Loaded File kura.properties: {}", (Object)kuraPropsFile);
                } else {
                    logger.warn("File does not exist: {}", (Object)kuraPropsFile);
                }
            } else {
                logger.error("Could not locate kura.properties file");
            }
            if (kuraHome == null) {
                kuraHome = kuraDefaults.getProperty("kura.home");
            }
            if (kuraFrameworkConfig == null) {
                kuraFrameworkConfig = kuraDefaults.getProperty("kura.framework.config");
            }
            if (kuraUserConfig == null) {
                kuraUserConfig = kuraDefaults.getProperty("kura.user.config");
            }
            Properties kuraCustomProps = new Properties();
            String kuraCustomConfig = System.getProperty("kura.custom.configuration");
            String kuraCustomProperties = this.readResource("kura_custom.properties");
            if (kuraCustomProperties != null) {
                kuraCustomProps.load(new StringReader(kuraCustomProperties));
                logger.info("Loaded Jar Resource: {}", (Object)"kura_custom.properties");
            } else if (kuraCustomConfig != null) {
                this.loadKuraCustom(kuraCustomProps, kuraCustomConfig);
            } else if (kuraUserConfig != null) {
                File kuraCustomPropsFile = new File(String.valueOf(kuraUserConfig) + File.separator + "kura_custom.properties");
                if (kuraCustomPropsFile.exists()) {
                    try (FileReader reader = new FileReader(kuraCustomPropsFile);){
                        kuraCustomProps.load(reader);
                    }
                    logger.info("Loaded File {}: {}", (Object)"kura_custom.properties", (Object)kuraCustomPropsFile);
                } else {
                    logger.warn("File does not exist: {}", (Object)kuraCustomPropsFile);
                }
            } else {
                logger.info("Did not locate a kura_custom.properties file in {}", (Object)kuraUserConfig);
            }
            kuraDefaults.putAll((Map<?, ?>)kuraCustomProps);
            if (kuraDefaults.getProperty("kura.home") != null && kuraDefaults.getProperty("kura.home").trim().equals("kura")) {
                kuraDefaults.setProperty("kura.home", KURA_PATH);
                updateTriggered = true;
                logger.warn("Overridding invalid kura.home location");
            }
            if (kuraDefaults.getProperty("kura.plugins") != null && kuraDefaults.getProperty("kura.plugins").trim().equals("kura/plugins")) {
                kuraDefaults.setProperty("kura.plugins", "/opt/eclipse/kura/plugins");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.plugins location");
            }
            if (kuraDefaults.getProperty("kura.packages") != null && kuraDefaults.getProperty("kura.packages").trim().equals("kura/packages")) {
                kuraDefaults.setProperty("kura.packages", "/opt/eclipse/kura/data/packages");
                updateTriggered = true;
                logger.warn("Overridding invalid kura.packages location");
            }
            if (updateTriggered && ((directory = new File(KURA_PATH).getAbsoluteFile()).exists() || directory.mkdirs())) {
                String oldDir = System.getProperty("user.dir");
                if (System.setProperty("user.dir", directory.getAbsolutePath()) != null) {
                    logger.warn("Changed working directory to /opt/eclipse/kura from {}", (Object)oldDir);
                }
            }
            this.kuraProperties = new Properties(kuraDefaults);
            if (onCloudbees) {
                this.kuraProperties.put("os.name", "Linux (Cloudbees)");
            }
            Boolean hasNetAdmin = Boolean.valueOf(this.kuraProperties.getProperty("kura.have.net.admin", "true"));
            this.kuraProperties.put("kura.have.net.admin", hasNetAdmin);
            logger.info("Kura has net admin? {}", (Object)hasNetAdmin);
            String webInterfaceEnabled = this.kuraProperties.getProperty("kura.have.web.inter", "true");
            this.kuraProperties.put("kura.have.web.inter", webInterfaceEnabled);
            logger.info("Is Kura web interface enabled? {}", (Object)webInterfaceEnabled);
            String kuraVersion = this.kuraProperties.getProperty("kura.version", "version-unknown");
            this.kuraProperties.put("kura.version", kuraVersion);
            logger.info("Kura version? {}", (Object)kuraVersion);
            if (System.getProperty("kura.name") != null) {
                this.kuraProperties.put("kura.name", System.getProperty("kura.name"));
            }
            if (System.getProperty("kura.version") != null) {
                this.kuraProperties.put("kura.version", System.getProperty("kura.version"));
            }
            if (System.getProperty("kura.device.name") != null) {
                this.kuraProperties.put("kura.device.name", System.getProperty("kura.device.name"));
            }
            if (System.getProperty("kura.platform") != null) {
                this.kuraProperties.put("kura.platform", System.getProperty("kura.platform"));
            }
            if (System.getProperty("kura.model.id") != null) {
                this.kuraProperties.put("kura.model.id", System.getProperty("kura.model.id"));
            }
            if (System.getProperty("kura.model.name") != null) {
                this.kuraProperties.put("kura.model.name", System.getProperty("kura.model.name"));
            }
            if (System.getProperty("kura.partNumber") != null) {
                this.kuraProperties.put("kura.partNumber", System.getProperty("kura.partNumber"));
            }
            if (System.getProperty("kura.serialNumber") != null) {
                this.kuraProperties.put("kura.serialNumber", System.getProperty("kura.serialNumber"));
            }
            if (System.getProperty("kura.bios.version") != null) {
                this.kuraProperties.put("kura.bios.version", System.getProperty("kura.bios.version"));
            }
            if (System.getProperty("kura.firmware.version") != null) {
                this.kuraProperties.put("kura.firmware.version", System.getProperty("kura.firmware.version"));
            }
            if (System.getProperty("kura.primary.network.interface") != null) {
                this.kuraProperties.put("kura.primary.network.interface", System.getProperty("kura.primary.network.interface"));
            }
            if (System.getProperty("kura.home") != null) {
                this.kuraProperties.put("kura.home", System.getProperty("kura.home"));
            }
            if (System.getProperty("kura.framework.config") != null) {
                this.kuraProperties.put("kura.framework.config", System.getProperty("kura.framework.config"));
            }
            if (System.getProperty("kura.user.config") != null) {
                this.kuraProperties.put("kura.user.config", System.getProperty("kura.user.config"));
            }
            if (System.getProperty("kura.plugins") != null) {
                this.kuraProperties.put("kura.plugins", System.getProperty("kura.plugins"));
            }
            if (System.getProperty("kura.packages") != null) {
                this.kuraProperties.put("kura.packages", System.getProperty("kura.packages"));
            }
            if (System.getProperty("kura.data") != null) {
                this.kuraProperties.put("kura.data", System.getProperty("kura.data"));
            }
            if (System.getProperty("kura.tmp") != null) {
                this.kuraProperties.put("kura.tmp", System.getProperty("kura.tmp"));
            }
            if (System.getProperty("kura.snapshots") != null) {
                this.kuraProperties.put("kura.snapshots", System.getProperty("kura.snapshots"));
            }
            if (System.getProperty("kura.snapshots.count") != null) {
                this.kuraProperties.put("kura.snapshots.count", System.getProperty("kura.snapshots.count"));
            }
            if (System.getProperty("kura.have.net.admin") != null) {
                this.kuraProperties.put("kura.have.net.admin", System.getProperty("kura.have.net.admin"));
            }
            if (System.getProperty("kura.have.web.inter") != null) {
                this.kuraProperties.put("kura.have.web.inter", System.getProperty("kura.have.web.inter"));
            }
            if (System.getProperty("kura.style.dir") != null) {
                this.kuraProperties.put("kura.style.dir", System.getProperty("kura.style.dir"));
            }
            if (System.getProperty("kura.wifi.top.channel") != null) {
                this.kuraProperties.put("kura.wifi.top.channel", System.getProperty("kura.wifi.top.channel"));
            }
            if (System.getProperty("kura.ssl.keyStorePassword") != null) {
                this.kuraProperties.put("kura.ssl.keyStorePassword", System.getProperty("kura.ssl.keyStorePassword"));
            }
            if (System.getProperty("kura.ssl.trustStorePassword") != null) {
                this.kuraProperties.put("kura.ssl.trustStorePassword", System.getProperty("kura.ssl.trustStorePassword"));
            }
            if (System.getProperty("file.command.zip.max.size") != null) {
                this.kuraProperties.put("file.command.zip.max.size", System.getProperty("file.command.zip.max.size"));
            }
            if (System.getProperty("file.command.zip.max.number") != null) {
                this.kuraProperties.put("file.command.zip.max.number", System.getProperty("file.command.zip.max.number"));
            }
            if (System.getProperty("os.arch") != null) {
                this.kuraProperties.put("os.arch", System.getProperty("os.arch"));
            }
            if (System.getProperty("os.name") != null) {
                this.kuraProperties.put("os.name", System.getProperty("os.name"));
            }
            if (System.getProperty("os.version") != null) {
                this.kuraProperties.put("os.version", this.getOsVersion());
            }
            if (System.getProperty("os.distribution") != null) {
                this.kuraProperties.put("os.distribution", System.getProperty("os.distribution"));
            }
            if (System.getProperty("os.distribution.version") != null) {
                this.kuraProperties.put("os.distribution.version", System.getProperty("os.distribution.version"));
            }
            if (System.getProperty("java.runtime.version") != null) {
                this.kuraProperties.put("java.runtime.version", System.getProperty("java.runtime.version"));
            }
            if (System.getProperty("java.runtime.name") != null) {
                this.kuraProperties.put("java.runtime.name", System.getProperty("java.runtime.name"));
            }
            if (System.getProperty("java.vm.name") != null) {
                this.kuraProperties.put("java.vm.name", System.getProperty("java.vm.name"));
            }
            if (System.getProperty("java.vm.version") != null) {
                this.kuraProperties.put("java.vm.version", System.getProperty("java.vm.version"));
            }
            if (System.getProperty("java.vm.info") != null) {
                this.kuraProperties.put("java.vm.info", System.getProperty("java.vm.info"));
            }
            if (System.getProperty("org.osgi.framework.vendor") != null) {
                this.kuraProperties.put("org.osgi.framework.vendor", System.getProperty("org.osgi.framework.vendor"));
            }
            if (System.getProperty("org.osgi.framework.version") != null) {
                this.kuraProperties.put("org.osgi.framework.version", System.getProperty("org.osgi.framework.version"));
            }
            if (System.getProperty("java.home") != null) {
                this.kuraProperties.put("java.home", System.getProperty("java.home"));
            }
            if (System.getProperty("file.separator") != null) {
                this.kuraProperties.put("file.separator", System.getProperty("file.separator"));
            }
            if (System.getProperty("console.device.management.service.ignore") != null) {
                this.kuraProperties.put("console.device.management.service.ignore", System.getProperty("console.device.management.service.ignore"));
            }
            if (System.getProperty("db.service.hsqldb.url") != null) {
                this.kuraProperties.put("db.service.hsqldb.url", System.getProperty("db.service.hsqldb.url"));
            }
            if (System.getProperty("db.service.hsqldb.cache_rows") != null) {
                this.kuraProperties.put("db.service.hsqldb.cache_rows", System.getProperty("db.service.hsqldb.cache_rows"));
            }
            if (System.getProperty("db.service.hsqldb.lob_file_scale") != null) {
                this.kuraProperties.put("db.service.hsqldb.lob_file_scale", System.getProperty("db.service.hsqldb.lob_file_scale"));
            }
            if (System.getProperty("db.service.hsqldb.defrag_limit") != null) {
                this.kuraProperties.put("db.service.hsqldb.defrag_limit", System.getProperty("db.service.hsqldb.defrag_limit"));
            }
            if (System.getProperty("db.service.hsqldb.log_data") != null) {
                this.kuraProperties.put("db.service.hsqldb.log_data", System.getProperty("db.service.hsqldb.log_data"));
            }
            if (System.getProperty("db.service.hsqldb.log_size") != null) {
                this.kuraProperties.put("db.service.hsqldb.log_size", System.getProperty("db.service.hsqldb.log_size"));
            }
            if (System.getProperty("db.service.hsqldb.nio_data_file") != null) {
                this.kuraProperties.put("db.service.hsqldb.nio_data_file", System.getProperty("db.service.hsqldb.nio_data_file"));
            }
            if (System.getProperty("db.service.hsqldb.write_delay_millis") != null) {
                this.kuraProperties.put("db.service.hsqldb.write_delay_millis", System.getProperty("db.service.hsqldb.write_delay_millis"));
            }
            if (System.getProperty("cpu.version") != null) {
                this.kuraProperties.put("cpu.version", System.getProperty("cpu.version"));
            }
            if (System.getProperty("kura.command.user") != null) {
                this.kuraProperties.put("kura.command.user", System.getProperty("kura.command.user"));
            }
            if (this.getKuraHome() == null) {
                logger.error("Did not initialize kura.home");
            } else {
                logger.info("Kura home directory is {}", (Object)this.getKuraHome());
                SystemServiceImpl.createDirIfNotExists(this.getKuraHome());
            }
            if (this.getKuraFrameworkConfigDirectory() == null) {
                logger.error("Did not initialize kura.framework.config");
            } else {
                logger.info("Kura framework configuration directory is {}", (Object)this.getKuraFrameworkConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraFrameworkConfigDirectory());
            }
            if (this.getKuraUserConfigDirectory() == null) {
                logger.error("Did not initialize kura.user.config");
            } else {
                logger.info("Kura user configuration directory is {}", (Object)this.getKuraUserConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraUserConfigDirectory());
            }
            if (this.getKuraSnapshotsDirectory() == null) {
                logger.error("Did not initialize kura.snapshots");
            } else {
                logger.info("Kura snapshots directory is {}", (Object)this.getKuraSnapshotsDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraSnapshotsDirectory());
            }
            if (this.getKuraTemporaryConfigDirectory() == null) {
                logger.error("Did not initialize kura.tmp");
            } else {
                logger.info("Kura tmp directory is {}", (Object)this.getKuraTemporaryConfigDirectory());
                SystemServiceImpl.createDirIfNotExists(this.getKuraTemporaryConfigDirectory());
            }
            logger.info("Kura version {} is starting", (Object)this.getKuraVersion());
        }
        catch (IOException e) {
            throw new ComponentException("Error loading default properties", (Throwable)e);
        }
    }

    private void loadKuraCustom(Properties kuraCustomProps, String kuraCustomConfig) {
        try {
            URL kuraConfigUrl = new URL(kuraCustomConfig);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = kuraConfigUrl.openStream();){
                kuraCustomProps.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            logger.info("Loaded URL kura_custom.properties: {}", (Object)kuraCustomConfig);
        }
        catch (Exception e) {
            logger.warn("Could not open kuraCustomConfig URL: ", (Throwable)e);
        }
    }

    private void loadKuraDefaults(Properties kuraDefaults, String kuraConfig) {
        try {
            URL kuraConfigUrl = new URL(kuraConfig);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = kuraConfigUrl.openStream();){
                kuraDefaults.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            logger.info("Loaded URL kura.properties: {}", (Object)kuraConfig);
        }
        catch (Exception e) {
            logger.warn("Could not open kuraConfig URL", (Throwable)e);
        }
    }

    protected String readResource(String resource) throws IOException {
        if (resource == null) {
            return null;
        }
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (resourceUrl == null) {
            return null;
        }
        return IOUtils.toString((URL)resourceUrl);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = null;
        this.kuraProperties = null;
    }

    public void updated(Map<String, Object> properties) {
    }

    public Properties getProperties() {
        return this.kuraProperties;
    }

    public String getPrimaryMacAddress() {
        String primaryNetworkInterfaceName = this.getPrimaryNetworkInterfaceName();
        if ("Mac OS X".equals(this.getOsName())) {
            return this.getPrimaryMacAddressOSX(primaryNetworkInterfaceName);
        }
        if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) {
            return this.getPrimaryMacAddressWindows(primaryNetworkInterfaceName);
        }
        return this.getPrimaryMacAddressLinux(primaryNetworkInterfaceName);
    }

    private String getPrimaryMacAddressOSX(String primaryNetworkInterfaceName) {
        String macAddress = null;
        try {
            logger.info("executing: ifconfig and looking for {}", (Object)primaryNetworkInterfaceName);
            List<String> out = Arrays.asList(SystemServiceImpl.runSystemCommand("ifconfig", false, this.executorService).split("\\r?\\n"));
            ListIterator<String> iterator = out.listIterator();
            while (iterator.hasNext()) {
                String[] splitLine;
                String line = iterator.next();
                if (!line.startsWith(primaryNetworkInterfaceName)) continue;
                line = iterator.next();
                if (line == null) {
                    throw new IOException("Null input!");
                }
                if (!line.trim().startsWith("ether")) {
                    line = iterator.next();
                }
                if ((splitLine = line.split(" ")).length <= 0) continue;
                macAddress = splitLine[1].toUpperCase();
            }
        }
        catch (IOException e) {
            logger.error("Failed to get network interfaces", (Throwable)e);
        }
        return macAddress;
    }

    private String getPrimaryMacAddressWindows(String primaryNetworkInterfaceName) {
        String macAddress = null;
        try {
            logger.info("executing: InetAddress.getLocalHost {}", (Object)primaryNetworkInterfaceName);
            InetAddress ip = InetAddress.getLocalHost();
            InetAddress ip2 = this.getPrimaryIPWindows("eth");
            if (ip2 == null) {
                ip2 = this.getPrimaryIPWindows("wlan");
            }
            if (ip2 != null) {
                ip = ip2;
            }
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            macAddress = SystemServiceImpl.hardwareAddressToString(mac);
            logger.info("macAddress {}", (Object)macAddress);
        }
        catch (SocketException | UnknownHostException e) {
            logger.error(e.getLocalizedMessage());
        }
        return macAddress;
    }

    private String getPrimaryMacAddressLinux(String primaryNetworkInterfaceName) {
        List interfaces = null;
        try {
            interfaces = this.networkService.getNetworkInterfaces();
        }
        catch (KuraException e) {
            logger.error("Failed to get network interfaces", (Throwable)e);
            return null;
        }
        Optional<NetInterface> primaryInterface = interfaces.stream().filter(iface -> !Objects.isNull(iface.getName())).filter(iface -> primaryNetworkInterfaceName.equals(iface.getName().split("@")[0])).findFirst();
        if (primaryInterface.isPresent()) {
            return SystemServiceImpl.hardwareAddressToString(primaryInterface.get().getHardwareAddress());
        }
        return null;
    }

    private InetAddress getPrimaryIPWindows(String prefix) throws SocketException {
        InetAddress ip = null;
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            Enumeration<InetAddress> ips;
            NetworkInterface network = networks.nextElement();
            if (!network.getName().startsWith(prefix) || !(ips = network.getInetAddresses()).hasMoreElements()) continue;
            ip = ips.nextElement();
            break;
        }
        return ip;
    }

    public String getPrimaryNetworkInterfaceName() {
        Optional<String> propertyValue = this.getProperty("kura.primary.network.interface");
        if (propertyValue.isPresent()) {
            return propertyValue.get();
        }
        if ("Mac OS X".equals(this.getOsName())) {
            return "en0";
        }
        if ("Linux".equals(this.getOsName())) {
            return "eth0";
        }
        if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) {
            return OS_WINDOWS;
        }
        logger.error("Unsupported platform");
        return null;
    }

    public String getPlatform() {
        return this.getProperty("kura.platform").orElse(null);
    }

    public String getOsArch() {
        Optional<String> override = this.getProperty("os.arch");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("os.arch");
    }

    public String getOsName() {
        Optional<String> override = this.getProperty("os.name");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("os.name");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOsVersion() {
        Optional<String> override = this.getProperty("os.version");
        if (override.isPresent()) {
            return override.get();
        }
        StringBuilder sbOsVersion = new StringBuilder();
        sbOsVersion.append(System.getProperty("os.version"));
        if (!"Linux".equals(this.getOsName())) return sbOsVersion.toString();
        File linuxKernelVersion = null;
        linuxKernelVersion = new File("/proc/sys/kernel/version");
        if (!linuxKernelVersion.exists()) return sbOsVersion.toString();
        StringBuilder kernelVersionData = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileReader fr = new FileReader(linuxKernelVersion);
                try {
                    try (BufferedReader in = new BufferedReader(fr);){
                        String tempLine = null;
                        while ((tempLine = in.readLine()) != null) {
                            kernelVersionData.append(" ");
                            kernelVersionData.append(tempLine);
                        }
                        sbOsVersion.append(kernelVersionData.toString());
                    }
                    if (fr == null) return sbOsVersion.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return sbOsVersion.toString();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Failed to get OS version", (Throwable)e);
        }
        return sbOsVersion.toString();
    }

    public String getOsDistro() {
        return this.getProperty("os.distribution").orElse(null);
    }

    public String getOsDistroVersion() {
        return this.getProperty("os.distribution.version").orElse(null);
    }

    public String getJavaVendor() {
        Optional<String> override = this.getProperty("java.runtime.name");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVersion() {
        Optional<String> override = this.getProperty("java.runtime.version");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.runtime.version");
    }

    public String getJavaVmName() {
        Optional<String> override = this.getProperty("java.vm.name");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.vm.name");
    }

    public String getJavaVmVersion() {
        Optional<String> override = this.getProperty("java.vm.version");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.vm.version");
    }

    public String getJavaVmInfo() {
        Optional<String> override = this.getProperty("java.vm.info");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.vm.info");
    }

    public String getOsgiFwName() {
        Optional<String> override = this.getProperty("org.osgi.framework.vendor");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("org.osgi.framework.vendor");
    }

    public String getOsgiFwVersion() {
        Optional<String> override = this.getProperty("org.osgi.framework.version");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("org.osgi.framework.version");
    }

    public int getNumberOfProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public String getFileSeparator() {
        Optional<String> override = this.getProperty("file.separator");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("file.separator");
    }

    public String getJavaHome() {
        Optional<String> override = this.getProperty("java.home");
        if (override.isPresent()) {
            return override.get();
        }
        return System.getProperty("java.home");
    }

    public String getKuraName() {
        return this.getProperty("kura.name").orElse(null);
    }

    public String getKuraVersion() {
        return this.getProperty("kura.version").orElse(null);
    }

    public String getKuraMarketplaceCompatibilityVersion() {
        Optional<String> override = this.getProperty("kura.marketplace.compatibility.version");
        String marketplaceCompatibilityVersion = override.isPresent() ? override.get() : this.getKuraVersion();
        return marketplaceCompatibilityVersion.replaceAll("KURA[-_ ]", "").replaceAll("[-_]", ".");
    }

    public String getKuraFrameworkConfigDirectory() {
        return this.getProperty("kura.framework.config").orElse(null);
    }

    public String getKuraUserConfigDirectory() {
        return this.getProperty("kura.user.config").orElse(null);
    }

    public String getKuraHome() {
        return this.getProperty("kura.home").orElse(null);
    }

    public String getKuraPluginsDirectory() {
        return this.getProperty("kura.plugins").orElse(null);
    }

    public String getKuraDataDirectory() {
        return this.getProperty("kura.data").orElse(null);
    }

    public String getKuraTemporaryConfigDirectory() {
        return this.getProperty("kura.tmp").orElse(null);
    }

    public String getKuraSnapshotsDirectory() {
        return this.getProperty("kura.snapshots").orElse(null);
    }

    public int getKuraSnapshotsCount() {
        int iMaxCount = 10;
        Optional<String> maxCount = this.getProperty("kura.snapshots.count");
        if (maxCount.isPresent() && maxCount.get().trim().length() > 0) {
            try {
                iMaxCount = Integer.parseInt(maxCount.get());
            }
            catch (NumberFormatException nfe) {
                logger.error("Error - Invalid kura.snapshots.count setting. Using default.", (Throwable)nfe);
            }
        }
        return iMaxCount;
    }

    public int getKuraWifiTopChannel() {
        Optional<String> topWifiChannel = this.getProperty("kura.wifi.top.channel");
        if (topWifiChannel.isPresent() && topWifiChannel.get().trim().length() > 0) {
            return Integer.parseInt(topWifiChannel.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The last wifi channel is not defined for this system - setting fake value.");
        }
        return Integer.MAX_VALUE;
    }

    public String getKuraStyleDirectory() {
        return this.getProperty("kura.style.dir").orElse(null);
    }

    public String getKuraWebEnabled() {
        return this.getProperty("kura.have.web.inter").orElse(null);
    }

    public int getFileCommandZipMaxUploadSize() {
        Optional<String> commandMaxUpload = this.getProperty("file.command.zip.max.size");
        if (commandMaxUpload.isPresent() && commandMaxUpload.get().trim().length() > 0) {
            return Integer.parseInt(commandMaxUpload.get());
        }
        logger.warn("Maximum command line upload size not available. Set default to 100 MB");
        return 100;
    }

    public int getFileCommandZipMaxUploadNumber() {
        Optional<String> commandMaxFilesUpload = this.getProperty("file.command.zip.max.number");
        if (commandMaxFilesUpload.isPresent() && commandMaxFilesUpload.get().trim().length() > 0) {
            return Integer.parseInt(commandMaxFilesUpload.get());
        }
        logger.warn("Missing the parameter that specifies the maximum number of files uploadable using the command servlet. Set default to 1024 files");
        return 1024;
    }

    public String getBiosVersion() {
        String[] cmds;
        String biosTmp;
        Optional<String> override = this.getProperty("kura.bios.version");
        if (override.isPresent()) {
            return override.get();
        }
        String biosVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName())) {
            if (LINUX_2_6_34_9_WR4_2_0_0_STANDARD.equals(this.getOsVersion()) || LINUX_2_6_34_12_WR4_3_0_0_STANDARD.equals(this.getOsVersion())) {
                biosVersion = SystemServiceImpl.runSystemCommand("eth_vers_bios", false, this.executorService);
            } else {
                String biosTmp2 = SystemServiceImpl.runSystemCommand("dmidecode -s bios-version", false, this.executorService);
                if (biosTmp2.length() > 0 && !biosTmp2.contains("Permission denied")) {
                    biosVersion = biosTmp2;
                }
            }
        } else if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds2 = new String[]{BIN_SH, "-c", "system_profiler SPHardwareDataType | grep 'Boot ROM'"};
            String biosTmp3 = SystemServiceImpl.runSystemCommand(cmds2, true, this.executorService);
            if (biosTmp3.contains(": ")) {
                biosVersion = biosTmp3.split(SPACES_REGEX)[1];
            }
        } else if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS) && (biosTmp = SystemServiceImpl.runSystemCommand(cmds = new String[]{"wmic", "bios", "get", "smbiosbiosversion"}, false, this.executorService)).contains("SMBIOSBIOSVersion")) {
            biosVersion = biosTmp.split("SMBIOSBIOSVersion\\s+")[1];
            biosVersion = biosVersion.trim();
        }
        return biosVersion;
    }

    public String getDeviceName() {
        String displayTmp;
        Optional<String> override = this.getProperty("kura.device.name");
        if (override.isPresent()) {
            return override.get();
        }
        String deviceName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String displayTmp2 = SystemServiceImpl.runSystemCommand("scutil --get ComputerName", false, this.executorService);
            if (displayTmp2.length() > 0) {
                deviceName = displayTmp2;
            }
        } else if (("Linux".equals(this.getOsName()) || "Linux (Cloudbees)".equals(this.getOsName()) || this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) && (displayTmp = SystemServiceImpl.runSystemCommand("hostname", false, this.executorService)).length() > 0) {
            deviceName = displayTmp;
        }
        return deviceName;
    }

    public String getFirmwareVersion() {
        Optional<String> override = this.getProperty("kura.firmware.version");
        if (override.isPresent()) {
            return override.get();
        }
        String fwVersion = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && this.getOsVersion() != null) {
            if (this.getOsVersion().startsWith(LINUX_2_6_34_9_WR4_2_0_0_STANDARD) || this.getOsVersion().startsWith(LINUX_2_6_34_12_WR4_3_0_0_STANDARD)) {
                fwVersion = String.valueOf(SystemServiceImpl.runSystemCommand("eth_vers_cpld", false, this.executorService)) + " " + SystemServiceImpl.runSystemCommand("eth_vers_uctl", false, this.executorService);
            } else if (this.getOsVersion().startsWith("3.0.35-12.09.01+yocto")) {
                fwVersion = SystemServiceImpl.runSystemCommand("eth_vers_avr", false, this.executorService);
            }
        }
        return fwVersion;
    }

    public String getModelId() {
        String[] cmds;
        String biosTmp;
        Optional<String> override = this.getProperty("kura.model.id");
        if (override.isPresent()) {
            return override.get();
        }
        String modelId = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String modelTmp = SystemServiceImpl.runSystemCommand("sysctl -b hw.model", false, this.executorService);
            if (modelTmp.length() > 0) {
                modelId = modelTmp;
            }
        } else if ("Linux".equals(this.getOsName())) {
            String modelTmp = SystemServiceImpl.runSystemCommand(DMIDECODE_COMMAND, false, this.executorService);
            if (modelTmp.contains("Version: ")) {
                modelId = modelTmp.split("Version:\\s+")[1].split("\n")[0];
            }
        } else if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS) && (biosTmp = SystemServiceImpl.runSystemCommand(cmds = new String[]{"wmic", "baseboard", "get", "Version"}, false, this.executorService)).contains("Version")) {
            modelId = biosTmp.split("Version\\s+")[1];
            modelId = modelId.trim();
        }
        return modelId;
    }

    public String getModelName() {
        String[] cmds;
        String biosTmp;
        Optional<String> override = this.getProperty("kura.model.name");
        if (override.isPresent()) {
            return override.get();
        }
        String modelName = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds2 = new String[]{BIN_SH, "-c", "system_profiler SPHardwareDataType | grep 'Model Name'"};
            String modelTmp = SystemServiceImpl.runSystemCommand(cmds2, true, this.executorService);
            if (modelTmp.contains(": ")) {
                modelName = modelTmp.split(SPACES_REGEX)[1];
            }
        } else if ("Linux".equals(this.getOsName())) {
            String modelTmp = SystemServiceImpl.runSystemCommand(DMIDECODE_COMMAND, false, this.executorService);
            if (modelTmp.contains("Product Name: ")) {
                modelName = modelTmp.split("Product Name:\\s+")[1].split("\n")[0];
            }
        } else if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS) && (biosTmp = SystemServiceImpl.runSystemCommand(cmds = new String[]{"wmic", "baseboard", "get", "Product"}, false, this.executorService)).contains("Product")) {
            modelName = biosTmp.split("Product\\s+")[1];
            modelName = modelName.trim();
        }
        return modelName;
    }

    public String getPartNumber() {
        Optional<String> override = this.getProperty("kura.partNumber");
        if (override.isPresent()) {
            return override.get();
        }
        String partNumber = "UNSUPPORTED";
        if ("Linux".equals(this.getOsName()) && (LINUX_2_6_34_9_WR4_2_0_0_STANDARD.equals(this.getOsVersion()) || LINUX_2_6_34_12_WR4_3_0_0_STANDARD.equals(this.getOsVersion()))) {
            partNumber = String.valueOf(SystemServiceImpl.runSystemCommand("eth_partno_bsp", false, this.executorService)) + " " + SystemServiceImpl.runSystemCommand("eth_partno_epr", false, this.executorService);
        }
        return partNumber;
    }

    public String getSerialNumber() {
        String[] cmds;
        String biosTmp;
        Optional<String> override = this.getProperty("kura.serialNumber");
        if (override.isPresent()) {
            return override.get();
        }
        String serialNum = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            String[] cmds2 = new String[]{BIN_SH, "-c", "system_profiler SPHardwareDataType | grep 'Serial Number'"};
            String serialTmp = SystemServiceImpl.runSystemCommand(cmds2, true, this.executorService);
            if (serialTmp.contains(": ")) {
                serialNum = serialTmp.split(SPACES_REGEX)[1];
            }
        } else if ("Linux".equals(this.getOsName())) {
            String serialTmp = SystemServiceImpl.runSystemCommand(DMIDECODE_COMMAND, false, this.executorService);
            if (serialTmp.contains("Serial Number: ")) {
                serialNum = serialTmp.split("Serial Number:\\s+")[1].split("\n")[0];
            }
        } else if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS) && (biosTmp = SystemServiceImpl.runSystemCommand(cmds = new String[]{"wmic", "bios", "get", "SerialNumber"}, false, this.executorService)).contains("SerialNumber")) {
            serialNum = biosTmp.split("SerialNumber\\s+")[1];
            serialNum = serialNum.trim();
        }
        return serialNum;
    }

    public char[] getJavaKeyStorePassword() {
        Optional<String> keyStorePwd = this.getProperty("kura.ssl.keyStorePassword");
        if (keyStorePwd.isPresent()) {
            return keyStorePwd.get().toCharArray();
        }
        return new char[0];
    }

    public char[] getJavaTrustStorePassword() {
        Optional<String> trustStorePwd = this.getProperty("kura.ssl.trustStorePassword");
        if (trustStorePwd.isPresent()) {
            return trustStorePwd.get().toCharArray();
        }
        return new char[0];
    }

    public Bundle[] getBundles() {
        if (this.componentContext == null) {
            return null;
        }
        return this.componentContext.getBundleContext().getBundles();
    }

    public List<SystemResourceInfo> getSystemPackages() throws KuraProcessExecutionErrorException {
        CommandStatus apkStatus;
        CommandStatus rpmStatus;
        ArrayList<SystemResourceInfo> packagesInfo = new ArrayList<SystemResourceInfo>();
        CommandStatus debStatus = this.execute(new String[]{"dpkg-query", "-W"});
        if (debStatus.getExitStatus().isSuccessful() && ((ByteArrayOutputStream)debStatus.getOutputStream()).size() > 0) {
            this.parseSystemPackages(packagesInfo, debStatus, SystemResourceType.DEB);
        }
        if ((rpmStatus = this.execute(new String[]{"rpm", "-qa", "--queryformat", "'%{NAME} %{VERSION}-%{RELEASE}\n'"})).getExitStatus().isSuccessful() && ((ByteArrayOutputStream)rpmStatus.getOutputStream()).size() > 0) {
            this.parseSystemPackages(packagesInfo, rpmStatus, SystemResourceType.RPM);
        }
        if ((apkStatus = this.execute(new String[]{"apk", "list", "-I", "|", "awk", "'{ print $1 }'"})).getExitStatus().isSuccessful() && ((ByteArrayOutputStream)apkStatus.getOutputStream()).size() > 0) {
            this.parseSystemPackages(packagesInfo, apkStatus, SystemResourceType.APK);
        }
        if (!(debStatus.getExitStatus().isSuccessful() || rpmStatus.getExitStatus().isSuccessful() || apkStatus.getExitStatus().isSuccessful())) {
            throw new KuraProcessExecutionErrorException((Object)"Failed to retrieve system packages.");
        }
        return packagesInfo;
    }

    private void parseSystemPackages(List<SystemResourceInfo> packagesInfo, CommandStatus status, SystemResourceType type) {
        String[] packages = new String(((ByteArrayOutputStream)status.getOutputStream()).toByteArray(), Charsets.UTF_8).split("\n");
        Arrays.asList(packages).stream().forEach(p -> {
            String[] fields = p.split("\\s+");
            if (fields.length >= 2) {
                packagesInfo.add(new SystemResourceInfo(fields[0], fields[1], type));
            } else {
                String[] nameAndVersion = this.getApkNameAndVersion(fields[0]);
                packagesInfo.add(new SystemResourceInfo(nameAndVersion[0], nameAndVersion[1], type));
            }
        });
    }

    private String[] getApkNameAndVersion(String fullName) {
        String[] split = fullName.split("-");
        StringBuilder name = new StringBuilder();
        StringBuilder version = new StringBuilder();
        int matchIndex = 1000;
        Pattern pattern = Pattern.compile("^([0-9]+.?)");
        int i = 0;
        while (i < split.length) {
            String s = split[i];
            if (i > 0 && i < matchIndex) {
                if (pattern.matcher(s).lookingAt()) {
                    version.append(s);
                    matchIndex = i;
                } else {
                    name.append("-");
                    name.append(s);
                }
            }
            if (i > matchIndex) {
                version.append("-");
                version.append(s);
            }
            ++i;
        }
        return new String[]{String.valueOf(split[0]) + name.toString(), version.toString()};
    }

    private CommandStatus execute(String[] commandLine) {
        Command command = new Command(commandLine);
        command.setExecuteInAShell(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        command.setErrorStream((OutputStream)err);
        command.setOutputStream((OutputStream)out);
        CommandStatus status = this.executorService.execute(command);
        if (logger.isDebugEnabled()) {
            logger.debug("execute command {} :: exited with code - {}", (Object)command, (Object)status.getExitStatus().getExitCode());
            logger.debug("execute stderr {}", (Object)new String(err.toByteArray(), Charsets.UTF_8));
            logger.debug("execute stdout {}", (Object)new String(out.toByteArray(), Charsets.UTF_8));
        }
        return status;
    }

    public List<String> getDeviceManagementServiceIgnore() {
        String[] servicesArray;
        Optional<String> servicesToIgnore = this.getProperty("console.device.management.service.ignore");
        List<String> services = new ArrayList<String>();
        if (servicesToIgnore.isPresent() && !servicesToIgnore.get().trim().isEmpty() && (servicesArray = servicesToIgnore.get().split(",")) != null && servicesArray.length > 0) {
            services = Arrays.asList(servicesArray);
        }
        return services;
    }

    private static void createDirIfNotExists(String fileName) {
        File file = new File(fileName);
        if (!file.exists() && !file.mkdirs()) {
            logger.error("Failed to create the temporary configuration directory: {}", (Object)fileName);
            if (Boolean.getBoolean("org.eclipse.kura.core.dontExitOnFailure")) {
                throw new RuntimeException(String.format("Failed to create the temporary configuration directory: %s", fileName));
            }
            System.exit(-1);
        }
    }

    public String getHostname() {
        String hostname = "UNKNOWN";
        if ("Mac OS X".equals(this.getOsName())) {
            hostname = SystemServiceImpl.runSystemCommand("scutil --get ComputerName", false, this.executorService);
        } else if ("Linux".equals(this.getOsName()) || "Linux (Cloudbees)".equals(this.getOsName()) || this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) {
            hostname = SystemServiceImpl.runSystemCommand("hostname", false, this.executorService);
        }
        return hostname;
    }

    public String getNetVirtualDevicesConfig() {
        String status = NetInterfaceStatus.netIPv4StatusDisabled.name();
        String virtualDefaultConfig = this.kuraProperties.getProperty("kura.net.virtual.devices.config");
        if (virtualDefaultConfig != null && virtualDefaultConfig.equalsIgnoreCase("unmanaged")) {
            status = NetInterfaceStatus.netIPv4StatusUnmanaged.name();
        }
        return status;
    }

    private static String hardwareAddressToString(byte[] macAddress) {
        if (macAddress == null) {
            return "N/A";
        }
        if (macAddress.length != 6) {
            throw new IllegalArgumentException("macAddress is invalid");
        }
        StringJoiner sj = new StringJoiner(":");
        byte[] byArray = macAddress;
        int n = macAddress.length;
        int n2 = 0;
        while (n2 < n) {
            byte item = byArray[n2];
            sj.add(String.format("%02X", item));
            ++n2;
        }
        return sj.toString();
    }

    public String getCpuVersion() {
        Optional<String> override = this.getProperty("cpu.version");
        if (override.isPresent()) {
            return override.get();
        }
        if ("Linux".equals(this.getOsName())) {
            try {
                return SystemServiceImpl.probeCpuVersionLinux();
            }
            catch (Exception exception) {}
        }
        return "unknown";
    }

    private static String probeCpuVersionLinux() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/cpuinfo"));){
            String line;
            while ((line = reader.readLine()) != null) {
                String key;
                int separatorIndex = line.indexOf(58);
                if (separatorIndex == -1 || !(key = line.substring(0, separatorIndex).trim()).equals("model name")) continue;
                return line.substring(separatorIndex + 1).trim();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("Could not retrieve cpu version");
    }

    protected Optional<String> getProperty(String key) {
        String result;
        String prop = this.kuraProperties.getProperty(key);
        if (prop != null) {
            return Optional.of(prop);
        }
        String externalProvider = this.kuraProperties.getProperty(String.valueOf(key) + PROPERTY_PROVIDER_SUFFIX);
        if (externalProvider != null && (result = this.processCommandOutput(SystemServiceImpl.runSystemCommand(externalProvider, true, this.executorService))) != null && !result.isEmpty()) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private String processCommandOutput(String result) {
        if (result == null) {
            return null;
        }
        String trimmed = result.trim();
        if (trimmed.isEmpty()) {
            return trimmed;
        }
        int i = trimmed.length() - 1;
        while (i > 0) {
            if (trimmed.charAt(i) != '\n') break;
            --i;
        }
        return trimmed.substring(0, i + 1);
    }

    public Optional<ExtendedProperties> getExtendedProperties() {
        return Optional.empty();
    }

    public String getCommandUser() {
        Optional<String> override = this.getProperty("kura.command.user");
        if (override.isPresent()) {
            return override.get();
        }
        return "unknown";
    }

    public boolean isLegacyBluetoothBeaconScan() {
        Optional<String> override = this.getProperty("kura.legacy.bluetooth.beacon.scan");
        if (override.isPresent()) {
            return Boolean.parseBoolean(override.get());
        }
        return false;
    }
}

