/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.impl.DefaultConsumer;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.camel.cloud.KuraCloudEndpoint;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.message.KuraPayload;

public class KuraCloudConsumer
extends DefaultConsumer
implements CloudClientListener {
    private final CloudClient cloudClient;

    public KuraCloudConsumer(Endpoint endpoint, Processor processor, CloudClient cloudClient) {
        super(endpoint, processor);
        this.cloudClient = cloudClient;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.debug("Starting CloudClientListener.");
        this.cloudClient.addCloudClientListener((CloudClientListener)this);
        if (this.cloudClient.isConnected()) {
            this.performSubscribe();
        }
    }

    protected void doStop() throws Exception {
        try {
            this.cloudClient.unsubscribe(this.getEndpoint().getTopic());
        }
        catch (Exception e) {
            this.log.info("Failed to unsubscribe", (Throwable)e);
        }
        this.cloudClient.removeCloudClientListener((CloudClientListener)this);
        this.log.debug("Stopping CloudClientListener.");
        super.doStop();
    }

    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        this.onInternalMessageArrived(deviceId, appTopic, msg, qos, retain, true);
    }

    public void onMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        this.onInternalMessageArrived(deviceId, appTopic, msg, qos, retain, false);
    }

    public void onConnectionLost() {
        this.log.debug("Executing empty 'onConnectionLost' callback.");
    }

    public void onConnectionEstablished() {
        this.log.debug("Executing 'onConnectionEstablished'.");
        this.performSubscribe();
    }

    private void performSubscribe() {
        try {
            this.log.debug("Perform subscribe: {} / {}", (Object)this.cloudClient, (Object)this.getEndpoint().getTopic());
            this.cloudClient.subscribe(this.getEndpoint().getTopic(), 0);
        }
        catch (KuraException e) {
            this.log.warn("Failed to subscribe", (Throwable)e);
        }
    }

    public void onMessageConfirmed(int messageId, String appTopic) {
        this.log.debug("Executing empty 'onMessageConfirmed' callback with message ID {} and application topic {}.", (Object)messageId, (Object)appTopic);
    }

    public void onMessagePublished(int messageId, String appTopic) {
        this.log.debug("Executing empty 'onMessagePublished' callback with message ID {} and application topic {}.", (Object)messageId, (Object)appTopic);
    }

    private void onInternalMessageArrived(String deviceId, String appTopic, KuraPayload message, int qos, boolean retain, boolean control) {
        this.log.debug("Received message with deviceId {}, application topic {}.", (Object)deviceId, (Object)appTopic);
        Exchange exchange = ExchangeBuilder.anExchange((CamelContext)this.getEndpoint().getCamelContext()).withBody((Object)message).withHeader("CamelKuraCloudService.topic", (Object)appTopic).withHeader("CamelKuraCloudService.deviceId", (Object)deviceId).withHeader("CamelKuraCloudService.qos", (Object)qos).withHeader("CamelKuraCloudService.control", (Object)control).withHeader("CamelKuraCloudService.retain", (Object)retain).build();
        exchange.setFromEndpoint((Endpoint)this.getEndpoint());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.handleException("Error while processing an incoming message:", e);
        }
    }

    public KuraCloudEndpoint getEndpoint() {
        return (KuraCloudEndpoint)super.getEndpoint();
    }
}

