/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.kura.message.KuraAlertSeverity;
import org.eclipse.kura.message.KuraAlertStatus;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KuraAlertPayload
extends KuraPayload {
    public static final String CODE_METRIC_NAME = "alert_code";
    public static final String SEVERITY_METRIC_NAME = "alert_severity";
    public static final String STATUS_METRIC_NAME = "alert_status";
    public static final String MESSAGE_METRIC_NAME = "alert_message";
    public static final String CREATION_TIMESTAMP_METRIC_NAME = "alert_creation_date";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

    public KuraAlertPayload(String code, KuraAlertSeverity severity, KuraAlertStatus status) {
        this.setCode(code);
        this.setSeverity(severity);
        this.setStatus(status);
    }

    public void setCode(String code) {
        super.addMetric(CODE_METRIC_NAME, this.validateCode(code));
    }

    public void setSeverity(KuraAlertSeverity severity) {
        super.addMetric(SEVERITY_METRIC_NAME, severity.name());
    }

    public void setStatus(KuraAlertStatus status) {
        super.addMetric(STATUS_METRIC_NAME, status.name());
    }

    public void setCreationTimestamp(Date date) {
        super.addMetric(CREATION_TIMESTAMP_METRIC_NAME, date.toString());
    }

    public void setMessage(String message) {
        if (message == null) {
            super.removeMetric(MESSAGE_METRIC_NAME);
        } else {
            super.addMetric(MESSAGE_METRIC_NAME, message);
        }
    }

    public String getCode() {
        return (String)this.getMetric(CODE_METRIC_NAME);
    }

    public KuraAlertSeverity getSeverity() {
        return KuraAlertSeverity.valueOf((String)this.getMetric(SEVERITY_METRIC_NAME));
    }

    public KuraAlertStatus getStatus() {
        return KuraAlertStatus.valueOf((String)this.getMetric(STATUS_METRIC_NAME));
    }

    public String getMessage() {
        Object rawMessage = this.getMetric(MESSAGE_METRIC_NAME);
        if (rawMessage instanceof String) {
            return (String)rawMessage;
        }
        return null;
    }

    public Date getCreationTimestamp() {
        try {
            return DATE_FORMAT.parse((String)this.getMetric(CREATION_TIMESTAMP_METRIC_NAME));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addMetric(String name, Object value) {
        if (CODE_METRIC_NAME.equals(name)) {
            this.setCode((String)value);
            return;
        }
        if (MESSAGE_METRIC_NAME.equals(name)) {
            this.setMessage((String)value);
            return;
        }
        if (CREATION_TIMESTAMP_METRIC_NAME.equals(name)) {
            this.setCreationTimestamp((Date)value);
            return;
        }
        if (SEVERITY_METRIC_NAME.equals(name)) {
            KuraAlertSeverity.valueOf((String)value);
        } else if (STATUS_METRIC_NAME.equals(name)) {
            KuraAlertStatus.valueOf((String)value);
        }
        super.addMetric(name, value);
    }

    private String validateCode(String code) {
        String trimmed = code.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("alert code cannot be empty");
        }
        return trimmed;
    }
}

