/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import org.tigris.mtoolkit.iagent.internal.pmp.PMPAnswer;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPData;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPEventsManager;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPInputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPOutputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;
import org.tigris.mtoolkit.iagent.internal.pmp.RemoteMethodImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.RemoteObjectImpl;
import org.tigris.mtoolkit.iagent.pmp.EventListener;
import org.tigris.mtoolkit.iagent.pmp.PMPConnection;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.pmp.RemoteObject;

class Connection
implements PMPConnection {
    protected PMPInputStream is;
    protected PMPOutputStream os;
    protected PMPSessionThread reader;
    protected boolean connected = false;
    protected PMPEventsManager evMngr;

    public Connection(PMPInputStream is, PMPOutputStream os, PMPSessionThread reader) {
        this.is = is;
        this.os = os;
        this.reader = reader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws PMPException {
        PMPAnswer answer = new PMPAnswer(this.reader);
        try {
            this.os.begin(answer);
            this.os.write(PMPSessionThread.CONNECT);
            PMPData.writeInt(this.is.timeout, this.os);
            this.os.end(true);
            answer.get(this.is.timeout == 0 ? 10000 : this.is.timeout);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PMPException(ex.getMessage(), ex);
        }
        try {
            if (!answer.connected) {
                String errMsg = "Can't Connect To Server: " + answer.errMsg;
                this.disconnect(errMsg);
                throw new PMPException(errMsg);
            }
            this.connected = true;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            answer.free();
            throw throwable;
        }
        {
            Object var3_6 = null;
            answer.free();
            return;
        }
    }

    public void disconnect(String errMsg) {
        if (!this.connected) {
            this.dump("already disconnected ...");
            return;
        }
        this.reader.disconnect(errMsg, true);
    }

    protected void disconnected(String errMsg) {
        errMsg = errMsg == null ? new String() : errMsg;
        this.dump("Connection: disconnecting " + errMsg);
        this.connected = false;
        this.postDisconnectedEvent(errMsg);
        this.evMngr = null;
    }

    protected void postDisconnectedEvent(String errMsg) {
        if (this.evMngr != null) {
            this.evMngr.postEvent("framework_disconnected_event", this);
            this.evMngr.stopEvents();
            this.reader.debug("Connection: Events manager stopped.");
        }
    }

    public RemoteObject getReference(String clazz, String filter) throws PMPException {
        PMPAnswer answer = new PMPAnswer(this.reader);
        try {
            this.os.begin(answer);
            this.os.write(PMPSessionThread.GET_REF);
            PMPData.writeString(clazz, this.os);
            PMPData.writeString(filter, this.os);
            this.os.end(true);
            answer.get(this.is.timeout);
        }
        catch (Exception ioExc) {
            this.os.unlock();
            throw new PMPException(ioExc.toString(), ioExc);
        }
        if (answer.errMsg != null) {
            String errMsg = answer.errMsg;
            answer.free();
            throw new PMPException(errMsg);
        }
        RemoteObjectImpl toReturn = new RemoteObjectImpl(answer.objID, this);
        answer.free();
        return toReturn;
    }

    public RemoteObject getReference(String clazz, String filter, long bid) throws PMPException {
        PMPAnswer answer = new PMPAnswer(this.reader);
        short msgID = 0;
        try {
            msgID = this.os.begin(answer);
            this.os.write(PMPSessionThread.GET_REF_BY_ID);
            PMPData.writeString(clazz, this.os);
            PMPData.writeString(filter, this.os);
            PMPData.writeLong(bid, this.os);
            this.os.end(true);
            answer.get(this.is.timeout);
        }
        catch (Exception ioExc) {
            if (msgID >= 100) {
                this.os.unlock();
            }
            throw new PMPException(ioExc.toString(), ioExc);
        }
        if (answer.errMsg != null) {
            String errMsg = answer.errMsg;
            answer.free();
            throw new PMPException(errMsg);
        }
        RemoteObjectImpl toReturn = new RemoteObjectImpl(answer.objID, this);
        answer.free();
        return toReturn;
    }

    protected RemoteMethodImpl[] getMethods(RemoteObjectImpl ro) throws PMPException {
        PMPAnswer answer = new PMPAnswer(this.reader);
        answer.connection = ro.c;
        int msgID = 0;
        try {
            answer.requestingRObj = ro;
            msgID = this.os.begin(answer);
            this.os.write(PMPSessionThread.GET_METHOD);
            PMPData.writeInt(ro.IOR, this.os);
            PMPData.writeString(new String(), this.os);
            this.os.end(true);
            answer.get(this.is.timeout);
            if (answer.errMsg != null) {
                throw new PMPException(answer.errMsg);
            }
            RemoteMethodImpl[] remoteMethodImplArray = answer.methods;
            Object var5_5 = null;
            answer.free();
            return remoteMethodImplArray;
        }
        catch (Exception exc) {
            try {
                if (msgID >= 100) {
                    this.os.unlock();
                }
                throw exc instanceof PMPException ? (PMPException)exc : new PMPException(exc.toString(), exc);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                answer.free();
                throw throwable;
            }
        }
    }

    protected RemoteMethodImpl getMethod(RemoteObjectImpl ro, String name, String[] argTypes) throws PMPException {
        PMPAnswer answer = new PMPAnswer(this.reader);
        short msgID = 0;
        if (argTypes == null) {
            argTypes = new String[]{};
        }
        try {
            msgID = this.os.begin(answer);
            this.os.write(PMPSessionThread.GET_METHOD);
            PMPData.writeInt(ro.IOR, this.os);
            PMPData.writeString(name, this.os);
            PMPData.writeInt(argTypes.length, this.os);
            int i = 0;
            while (i < argTypes.length) {
                PMPData.writeString(argTypes[i], this.os);
                ++i;
            }
            this.os.end(true);
            answer.get(this.is.timeout);
        }
        catch (Exception exc) {
            if (msgID >= 100) {
                this.os.unlock();
            }
            answer.free();
            throw new PMPException(exc.toString(), exc);
        }
        if (answer.errMsg != null) {
            String errMsg = answer.errMsg;
            answer.free();
            throw new PMPException(errMsg);
        }
        try {
            RemoteMethodImpl remoteMethodImpl = new RemoteMethodImpl(name, answer.returnType, argTypes, ro.c, answer.methodID, ro);
            Object var6_9 = null;
            answer.free();
            return remoteMethodImpl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            answer.free();
            throw throwable;
        }
    }

    protected boolean dispose(int objID) {
        boolean locked = false;
        try {
            this.os.begin(null);
            locked = true;
            this.os.write(PMPSessionThread.DISPOSE);
            PMPData.writeInt(objID, this.os);
            this.os.end(true);
            return true;
        }
        catch (Exception exception) {
            if (locked) {
                this.os.unlock();
            }
            return false;
        }
    }

    protected Object invoke(Object[] args, String[] argTypes, boolean serflag, int objID, int methodID, String expReturnType, ClassLoader loader, boolean changed, Connection cr) throws PMPException {
        int msgID;
        PMPAnswer answer;
        block25: {
            answer = new PMPAnswer(this.reader);
            answer.loader = loader;
            answer.returnType = changed ? expReturnType : new String();
            msgID = 0;
            answer.expectsReturn = !expReturnType.equals(PMPData.TYPES1[8]) && !expReturnType.equals(PMPData.TYPES2[8]);
            msgID = this.os.begin(answer);
            boolean haveRefs = false;
            if (args == null) {
                args = new Object[argTypes.length];
            }
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof RemoteObjectImpl) {
                    haveRefs = true;
                    break;
                }
                ++i;
            }
            if (haveRefs) {
                this.os.write(PMPSessionThread.INVOKE_R);
            } else {
                this.os.write(PMPSessionThread.INVOKE);
            }
            PMPData.writeInt(objID, this.os);
            PMPData.writeInt(methodID, this.os);
            this.os.write(serflag ? 0 : 1);
            if (args.length != argTypes.length) {
                throw new PMPException("Incorrect arguments");
            }
            i = 0;
            while (i < args.length) {
                String className = null;
                try {
                    int pos = argTypes[i].indexOf(46);
                    if (pos == -1) {
                        className = this.getClassName(argTypes[i]);
                    }
                    if (className == null) {
                        className = argTypes[i];
                    }
                }
                catch (Exception exception) {
                    this.os.unlock();
                    msgID = 0;
                    throw new PMPException("Can't Load Argument Type: " + argTypes[i]);
                }
                if (className.equals("org.tigris.mtoolkit.iagent.pmp.RemoteObject")) {
                    int tmpID = this.addRemoteObject(args[i]);
                    RemoteObjectImpl objImpl = new RemoteObjectImpl(tmpID, null);
                    if (haveRefs) {
                        this.os.write(1);
                    }
                    PMPData.writeObject(objImpl, this.os, true);
                } else if (args[i] instanceof RemoteObjectImpl) {
                    if (haveRefs) {
                        this.os.write(0);
                    }
                    PMPData.writeInt(((RemoteObjectImpl)args[i]).IOR, this.os);
                } else {
                    if (haveRefs) {
                        this.os.write(1);
                    }
                    PMPData.writeObject(args[i], this.os, true);
                }
                ++i;
            }
            this.os.end(true);
            answer.get(this.is.timeout);
            if (answer.errMsg != null) {
                throw new PMPException("Error Invoking Method: " + answer.errMsg);
            }
            if (answer.expectsReturn) break block25;
            Object var17_18 = null;
            answer.free();
            return null;
        }
        try {
            Object object = serflag ? answer.obj : (answer.objID > 0 ? new RemoteObjectImpl(answer.objID, cr) : null);
            Object var17_19 = null;
            answer.free();
            return object;
        }
        catch (Exception exc) {
            try {
                this.dump(exc);
                if (msgID >= 100) {
                    this.os.unlock();
                }
                throw exc instanceof PMPException ? (PMPException)exc : new PMPException(exc.toString(), exc);
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                answer.free();
                throw throwable;
            }
        }
    }

    private String getClassName(String name) {
        return name.equals(PMPData.TYPES1[0]) ? PMPData.TYPES2[0] : (name.equals(PMPData.TYPES1[4]) ? PMPData.TYPES2[4] : (name.equals(PMPData.TYPES1[3]) ? PMPData.TYPES2[3] : (name.equals(PMPData.TYPES1[1]) ? PMPData.TYPES2[1] : (name.equals(PMPData.TYPES1[2]) ? PMPData.TYPES2[2] : (name.equals(PMPData.TYPES1[5]) ? PMPData.TYPES2[5] : (name.equals(PMPData.TYPES1[6]) ? PMPData.TYPES2[6] : (name.equals(PMPData.TYPES1[8]) ? PMPData.TYPES2[8] : (name.equals(PMPData.TYPES1[7]) ? PMPData.TYPES2[7] : null))))))));
    }

    protected void dump(String s) {
        this.reader.debug(s);
    }

    protected void dumpnnl(String s) {
        this.reader.debug(s);
    }

    protected void dump(Exception t) {
        this.reader.error(new String(), t);
    }

    private int addRemoteObject(Object obj) {
        Class[] interfaces = new Class[]{obj.getClass()};
        return this.reader.addRemoteObject(obj, interfaces);
    }

    protected void ping() {
        block2: {
            boolean locked = false;
            try {
                this.os.begin(null);
                locked = true;
                this.os.write(PMPSessionThread.PING);
                this.os.end(true);
            }
            catch (Exception exception) {
                if (!locked) break block2;
                this.os.unlock();
            }
        }
    }

    public void addEventListener(EventListener el, String[] eventTypes) throws IllegalArgumentException {
        if (el == null) {
            throw new IllegalArgumentException("Can't add null listener");
        }
        if (this.evMngr == null) {
            this.evMngr = new PMPEventsManager(this.reader);
            this.reader.debug("Connection: Start events manager.");
            this.evMngr.start();
        }
        if (eventTypes != null && eventTypes.length != 0) {
            int i = 0;
            while (i < eventTypes.length) {
                this.evMngr.addEventListener(el, eventTypes[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Incorrect event types");
        }
    }

    public void removeEventListener(EventListener el, String[] eventTypes) throws IllegalArgumentException {
        if (el == null) {
            throw new IllegalArgumentException("Can't remove null listener");
        }
        if (this.evMngr == null) {
            return;
        }
        if (eventTypes != null && eventTypes.length != 0) {
            int i = 0;
            while (i < eventTypes.length) {
                this.evMngr.removeEventListener(el, eventTypes[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Incorrect event types");
        }
    }

    public String getSessionID() {
        return this.reader.sessionID;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

