/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.config;

import io.moquette.BrokerConstants;
import io.moquette.server.config.IConfig;
import java.util.Map;
import java.util.Properties;

public class MemoryConfig
implements IConfig {
    private final Properties m_properties = new Properties();

    public MemoryConfig(Properties properties) {
        this.createDefaults();
        for (Map.Entry<Object, Object> entrySet : properties.entrySet()) {
            this.m_properties.put(entrySet.getKey(), entrySet.getValue());
        }
    }

    private void createDefaults() {
        this.m_properties.put("port", Integer.toString(1883));
        this.m_properties.put("host", "0.0.0.0");
        this.m_properties.put("websocket_port", Integer.toString(8080));
        this.m_properties.put("password_file", "");
        this.m_properties.put("persistent_store", BrokerConstants.DEFAULT_PERSISTENT_PATH);
        this.m_properties.put("allow_anonymous", (Object)true);
        this.m_properties.put("authenticator_class", "");
        this.m_properties.put("authorizator_class", "");
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }
}

