/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.Map;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpProducerBuilder;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.jms.util.LRUCache;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAnonymousFallbackProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAnonymousFallbackProducer.class);
    private static final IdGenerator producerIdGenerator = new IdGenerator();
    private final AnonymousProducerCache producerCache;
    private final String producerIdKey = producerIdGenerator.generateId();
    private long producerIdCount;

    public AmqpAnonymousFallbackProducer(AmqpSession session, JmsProducerInfo info) {
        super(session, info);
        if (this.connection.isAnonymousProducerCache()) {
            this.producerCache = new AnonymousProducerCache(10);
            this.producerCache.setMaxCacheSize(this.connection.getAnonymousProducerCacheSize());
        } else {
            this.producerCache = null;
        }
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        LOG.trace("Started send chain for anonymous producer: {}", (Object)this.getProducerId());
        envelope.setSendAsync(false);
        AmqpProducer producer = null;
        if (this.connection.isAnonymousProducerCache()) {
            producer = (AmqpProducer)this.producerCache.get(envelope.getDestination());
        }
        if (producer == null) {
            JmsProducerInfo info = new JmsProducerInfo(this.getNextProducerId());
            info.setDestination(envelope.getDestination());
            info.setPresettle(((JmsProducerInfo)this.getResourceInfo()).isPresettle());
            AmqpProducerBuilder builder = new AmqpProducerBuilder(this.session, info);
            builder.buildResource(new AnonymousSendRequest(request, builder, envelope));
            if (this.connection.isAnonymousProducerCache()) {
                this.producerCache.put(envelope.getDestination(), builder.getResource());
            }
            this.getParent().getProvider().pumpToProtonTransport(request);
        } else {
            producer.send(envelope, request);
        }
    }

    @Override
    public void close(AsyncResult request) {
        if (this.connection.isAnonymousProducerCache()) {
            for (AmqpProducer producer : this.producerCache.values()) {
                producer.close(new CloseRequest(producer));
            }
        }
        request.onSuccess();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public EndpointState getLocalState() {
        return EndpointState.ACTIVE;
    }

    @Override
    public EndpointState getRemoteState() {
        return EndpointState.ACTIVE;
    }

    private JmsProducerId getNextProducerId() {
        return new JmsProducerId(this.producerIdKey, -1L, this.producerIdCount++);
    }

    private final class AnonymousProducerCache
    extends LRUCache<JmsDestination, AmqpProducer> {
        private static final long serialVersionUID = 1L;

        public AnonymousProducerCache(int cacheSize) {
            super(cacheSize);
        }

        @Override
        protected void onCacheEviction(Map.Entry<JmsDestination, AmqpProducer> cached) {
            LOG.trace("Producer: {} evicted from producer cache", (Object)cached.getValue());
            cached.getValue().close(new CloseRequest(cached.getValue()));
        }
    }

    private final class CloseRequest
    implements AsyncResult {
        private final AmqpProducer producer;

        public CloseRequest(AmqpProducer producer) {
            this.producer = producer;
        }

        @Override
        public void onFailure(ProviderException result) {
            AmqpAnonymousFallbackProducer.this.connection.getProvider().fireProviderException(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close of anonymous producer {} complete", (Object)this.producer);
        }

        @Override
        public boolean isComplete() {
            return this.producer.isClosed();
        }
    }

    private final class AnonymousCloseRequest
    extends AnonymousRequest {
        private final AmqpProducer producer;

        public AnonymousCloseRequest(AnonymousSendCompleteRequest sendComplete) {
            super(sendComplete.getWrappedRequest(), sendComplete.envelope);
            this.producer = sendComplete.getProducer();
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onSuccess();
        }

        @Override
        public AmqpProducer getProducer() {
            return this.producer;
        }
    }

    private final class AnonymousSendCompleteRequest
    extends AnonymousRequest {
        private final AmqpProducer producer;

        public AnonymousSendCompleteRequest(AnonymousSendRequest open) {
            super(open.getWrappedRequest(), open.envelope);
            this.producer = open.getProducer();
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.trace("Send phase of anonymous send failed: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            if (!AmqpAnonymousFallbackProducer.this.connection.isAnonymousProducerCache()) {
                AnonymousCloseRequest close = new AnonymousCloseRequest(this);
                this.producer.close(close);
            }
            super.onFailure(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Send phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            if (!AmqpAnonymousFallbackProducer.this.connection.isAnonymousProducerCache()) {
                AnonymousCloseRequest close = new AnonymousCloseRequest(this);
                this.producer.close(close);
            } else {
                super.onSuccess();
            }
        }

        @Override
        public AmqpProducer getProducer() {
            return this.producer;
        }
    }

    private final class AnonymousSendRequest
    extends AnonymousRequest {
        private final AmqpProducerBuilder producerBuilder;

        public AnonymousSendRequest(AsyncResult sendResult, AmqpProducerBuilder producerBuilder, JmsOutboundMessageDispatch envelope) {
            super(sendResult, envelope);
            this.producerBuilder = producerBuilder;
        }

        @Override
        public void onSuccess() {
            LOG.trace("Open phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AnonymousSendCompleteRequest send = new AnonymousSendCompleteRequest(this);
            try {
                this.getProducer().send(this.envelope, send);
            }
            catch (ProviderException e) {
                super.onFailure(e);
            }
        }

        @Override
        public AmqpProducer getProducer() {
            return (AmqpProducer)this.producerBuilder.getResource();
        }
    }

    private abstract class AnonymousRequest
    extends WrappedAsyncResult {
        protected final JmsOutboundMessageDispatch envelope;

        public AnonymousRequest(AsyncResult sendResult, JmsOutboundMessageDispatch envelope) {
            super(sendResult);
            this.envelope = envelope;
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.debug("Send failed during {} step in chain: {}", (Object)this.getClass().getName(), (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onFailure(result);
        }

        public abstract AmqpProducer getProducer();
    }
}

