/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.ai.component.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraIOException;
import org.eclipse.kura.ai.inference.Tensor;
import org.eclipse.kura.ai.inference.TensorDescriptor;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireRecord;

public class TensorListAdapter {
    private static TensorListAdapter instance;
    private List<TensorDescriptor> descriptors;

    private TensorListAdapter() {
    }

    private void setDescriptors(List<TensorDescriptor> descriptors) {
        TensorListAdapter.instance.descriptors = descriptors;
    }

    public static TensorListAdapter givenDescriptors(List<TensorDescriptor> descriptors) {
        if (instance == null) {
            instance = new TensorListAdapter();
        }
        instance.setDescriptors(descriptors);
        return instance;
    }

    public List<Tensor> fromWireRecord(WireRecord wireRecord) throws KuraException {
        LinkedList<Tensor> output = new LinkedList<Tensor>();
        for (TensorDescriptor descriptor : TensorListAdapter.instance.descriptors) {
            TypedValue<?> value = this.getTypedValueByNameFromMap(descriptor.getName(), wireRecord.getProperties());
            output.add(this.createTensorFromTypedValue(value, descriptor));
        }
        return output;
    }

    public List<WireRecord> fromTensorList(List<Tensor> tensors) throws KuraIOException {
        ArrayList<WireRecord> result = new ArrayList<WireRecord>();
        for (Tensor tensor : tensors) {
            HashMap<String, TypedValue> properties = new HashMap<String, TypedValue>();
            String name = tensor.getDescriptor().getName();
            Class tensorType = tensor.getType();
            Optional tensorData = tensor.getData(tensorType);
            if (tensorData.isPresent()) {
                Object data;
                List tensorDataList = (List)tensorData.get();
                if (tensorType.isAssignableFrom(Byte.class)) {
                    data = this.toByteArray(tensorDataList);
                } else {
                    if (tensorDataList.size() != 1) {
                        throw new KuraIOException((Object)("The tensor " + name + " does not contain data of length 1."));
                    }
                    data = tensorDataList.get(0);
                }
                TypedValue typedValue = TypedValues.newTypedValue((Object)data);
                properties.put(name, typedValue);
            }
            result.add(new WireRecord(properties));
        }
        return result;
    }

    private TypedValue<?> getTypedValueByNameFromMap(String name, Map<String, TypedValue<?>> properties) throws KuraException {
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            return entry.getValue();
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    private Tensor createTensorFromTypedValue(TypedValue<?> typedValue, TensorDescriptor descriptor) throws KuraIOException {
        Object value = typedValue.getValue();
        switch (typedValue.getType()) {
            case BOOLEAN: {
                ArrayList<Boolean> boolData = new ArrayList<Boolean>();
                boolData.add((Boolean)value);
                return new Tensor(Boolean.class, descriptor, boolData);
            }
            case BYTE_ARRAY: {
                byte[] byteArrayValue = (byte[])value;
                ArrayList<Byte> byteArrayData = new ArrayList<Byte>();
                byte[] byArray = byteArrayValue;
                int n = byteArrayValue.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    byteArrayData.add(b);
                    ++n2;
                }
                return new Tensor(Byte.class, descriptor, byteArrayData);
            }
            case DOUBLE: {
                ArrayList<Double> doubleData = new ArrayList<Double>();
                doubleData.add((Double)value);
                return new Tensor(Double.class, descriptor, doubleData);
            }
            case FLOAT: {
                ArrayList<Float> floatData = new ArrayList<Float>();
                floatData.add((Float)value);
                return new Tensor(Float.class, descriptor, floatData);
            }
            case INTEGER: {
                ArrayList<Integer> intData = new ArrayList<Integer>();
                intData.add((Integer)value);
                return new Tensor(Integer.class, descriptor, intData);
            }
            case LONG: {
                ArrayList<Long> longData = new ArrayList<Long>();
                longData.add((Long)value);
                return new Tensor(Long.class, descriptor, longData);
            }
            case STRING: {
                ArrayList<String> stringData = new ArrayList<String>();
                stringData.add((String)value);
                return new Tensor(String.class, descriptor, stringData);
            }
        }
        throw new KuraIOException((Object)"Unable to create Tensor: unsupported type.");
    }

    private byte[] toByteArray(List<?> bytes) {
        byte[] result = new byte[bytes.size()];
        int i = 0;
        while (i < bytes.size()) {
            result[i] = bytes.get(i) instanceof Byte ? (Byte)bytes.get(i) : Byte.parseByte(bytes.get(i).toString());
            ++i;
        }
        return result;
    }
}

