/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.subscriptions;

import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.subscriptions.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

class TreeNode {
    Token m_token;
    List<TreeNode> m_children = new ArrayList<TreeNode>();
    Set<ISessionsStore.ClientTopicCouple> m_subscriptions = new HashSet<ISessionsStore.ClientTopicCouple>();

    TreeNode() {
    }

    Token getToken() {
        return this.m_token;
    }

    void setToken(Token topic) {
        this.m_token = topic;
    }

    void addSubscription(ISessionsStore.ClientTopicCouple s) {
        this.m_subscriptions.add(s);
    }

    void addChild(TreeNode child) {
        this.m_children.add(child);
    }

    TreeNode copy() {
        TreeNode copy = new TreeNode();
        copy.m_children = new ArrayList<TreeNode>(this.m_children);
        copy.m_subscriptions = new HashSet<ISessionsStore.ClientTopicCouple>(this.m_subscriptions);
        copy.m_token = this.m_token;
        return copy;
    }

    TreeNode childWithToken(Token token) {
        for (TreeNode child : this.m_children) {
            if (!child.getToken().equals(token)) continue;
            return child;
        }
        return null;
    }

    void updateChild(TreeNode oldChild, TreeNode newChild) {
        this.m_children.remove(oldChild);
        this.m_children.add(newChild);
    }

    Collection<ISessionsStore.ClientTopicCouple> subscriptions() {
        return this.m_subscriptions;
    }

    public void remove(ISessionsStore.ClientTopicCouple clientTopicCouple) {
        this.m_subscriptions.remove(clientTopicCouple);
    }

    void matches(Queue<Token> tokens, List<ISessionsStore.ClientTopicCouple> matchingSubs) {
        Token t = tokens.poll();
        if (t == null) {
            matchingSubs.addAll(this.m_subscriptions);
            for (TreeNode n : this.m_children) {
                if (n.getToken() != Token.MULTI && n.getToken() != Token.SINGLE) continue;
                matchingSubs.addAll(n.subscriptions());
            }
            return;
        }
        if (this.m_token == Token.MULTI) {
            matchingSubs.addAll(this.m_subscriptions);
            return;
        }
        for (TreeNode n : this.m_children) {
            if (!n.getToken().match(t)) continue;
            n.matches(new LinkedBlockingQueue<Token>(tokens), matchingSubs);
        }
    }

    int size() {
        int res = this.m_subscriptions.size();
        for (TreeNode child : this.m_children) {
            res += child.size();
        }
        return res;
    }

    TreeNode removeClientSubscriptions(String clientID) {
        TreeNode newSubRoot = this.copy();
        ArrayList<ISessionsStore.ClientTopicCouple> subsToRemove = new ArrayList<ISessionsStore.ClientTopicCouple>();
        for (ISessionsStore.ClientTopicCouple s : newSubRoot.m_subscriptions) {
            if (!s.clientID.equals(clientID)) continue;
            subsToRemove.add(s);
        }
        for (ISessionsStore.ClientTopicCouple s : subsToRemove) {
            newSubRoot.m_subscriptions.remove(s);
        }
        ArrayList<TreeNode> newChildren = new ArrayList<TreeNode>(newSubRoot.m_children.size());
        for (TreeNode child : newSubRoot.m_children) {
            newChildren.add(child.removeClientSubscriptions(clientID));
        }
        newSubRoot.m_children = newChildren;
        return newSubRoot;
    }
}

