/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.inference;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.ai.inference.TensorDescriptorBuilder;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TensorDescriptor {
    private final String name;
    private final String type;
    private final Optional<String> format;
    private final List<Long> shape;
    private final Map<String, Object> parameters;

    public TensorDescriptor(String name, String type, Optional<String> format, List<Long> shape, Map<String, Object> parameters) {
        this.name = name;
        this.type = type;
        this.format = format;
        this.shape = Collections.unmodifiableList(shape);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public static TensorDescriptorBuilder builder(String name, String type, List<Long> shape) {
        return new TensorDescriptorBuilder(name, type, shape);
    }

    public TensorDescriptorBuilder toBuilder() {
        return TensorDescriptorBuilder.fromTensorDescriptor(this);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getFormat() {
        return this.format;
    }

    public List<Long> getShape() {
        return this.shape;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

