/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.container.orchestration.ContainerNetworkConfiguration;
import org.eclipse.kura.container.orchestration.ImageConfiguration;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ContainerConfiguration {
    private String containerName;
    private List<Integer> containerPortsExternal;
    private List<Integer> containerPortsInternal;
    private List<String> containerEnvVars;
    private List<String> containerDevices;
    private Map<String, String> containerVolumes;
    private Boolean containerPrivileged;
    private Boolean isFrameworkManaged = true;
    private Map<String, String> containerLoggerParameters;
    private String containerLoggingType;
    private ImageConfiguration imageConfig;
    private ContainerNetworkConfiguration networkConfiguration;
    private List<String> entryPoint;
    private Boolean containerRestartOnFailure = false;
    private Optional<Long> memory;
    private Optional<Float> cpus;
    private Optional<String> gpus;

    private ContainerConfiguration() {
    }

    public boolean isFrameworkManaged() {
        return this.isFrameworkManaged;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public List<Integer> getContainerPortsExternal() {
        return this.containerPortsExternal;
    }

    public List<Integer> getContainerPortsInternal() {
        return this.containerPortsInternal;
    }

    public List<String> getContainerEnvVars() {
        return this.containerEnvVars;
    }

    public List<String> getContainerDevices() {
        return this.containerDevices;
    }

    public Map<String, String> getContainerVolumes() {
        return this.containerVolumes;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public Map<String, String> getLoggerParameters() {
        return this.containerLoggerParameters;
    }

    public String getContainerLoggingType() {
        return this.containerLoggingType;
    }

    public ImageConfiguration getImageConfiguration() {
        return this.imageConfig;
    }

    public String getContainerImage() {
        return this.imageConfig.getImageName();
    }

    public String getContainerImageTag() {
        return this.imageConfig.getImageTag();
    }

    public Optional<RegistryCredentials> getRegistryCredentials() {
        return this.imageConfig.getRegistryCredentials();
    }

    public int getImageDownloadTimeoutSeconds() {
        return this.imageConfig.getimageDownloadTimeoutSeconds();
    }

    public ContainerNetworkConfiguration getContainerNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    public boolean getRestartOnFailure() {
        return this.containerRestartOnFailure;
    }

    public Optional<Long> getMemory() {
        return this.memory;
    }

    public Optional<Float> getCpus() {
        return this.cpus;
    }

    public Optional<String> getGpus() {
        return this.gpus;
    }

    public static ContainerConfigurationBuilder builder() {
        return new ContainerConfigurationBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.containerDevices, this.containerEnvVars, this.containerLoggerParameters, this.containerLoggingType, this.containerName, this.containerPortsExternal, this.containerPortsInternal, this.containerPrivileged, this.containerVolumes, this.cpus, this.entryPoint, this.gpus, this.imageConfig, this.isFrameworkManaged, this.memory, this.networkConfiguration, this.containerRestartOnFailure);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerConfiguration other = (ContainerConfiguration)obj;
        return Objects.equals(this.containerDevices, other.containerDevices) && Objects.equals(this.containerEnvVars, other.containerEnvVars) && Objects.equals(this.containerLoggerParameters, other.containerLoggerParameters) && Objects.equals(this.containerLoggingType, other.containerLoggingType) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerPortsExternal, other.containerPortsExternal) && Objects.equals(this.containerPortsInternal, other.containerPortsInternal) && Objects.equals(this.containerPrivileged, other.containerPrivileged) && Objects.equals(this.containerVolumes, other.containerVolumes) && Objects.equals(this.cpus, other.cpus) && Objects.equals(this.entryPoint, other.entryPoint) && Objects.equals(this.gpus, other.gpus) && Objects.equals(this.imageConfig, other.imageConfig) && Objects.equals(this.isFrameworkManaged, other.isFrameworkManaged) && Objects.equals(this.memory, other.memory) && Objects.equals(this.networkConfiguration, other.networkConfiguration) && Objects.equals(this.containerRestartOnFailure, other.containerRestartOnFailure);
    }

    /* synthetic */ ContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this();
    }

    public static final class ContainerConfigurationBuilder {
        private String containerName;
        private List<Integer> containerPortsExternal = new ArrayList<Integer>();
        private List<Integer> containerPortsInternal = new ArrayList<Integer>();
        private List<String> containerEnvVars = new LinkedList<String>();
        private List<String> containerDevices = new LinkedList<String>();
        private Map<String, String> containerVolumes = new HashMap<String, String>();
        private Boolean containerPrivileged = false;
        private Boolean isFrameworkManaged = false;
        private Map<String, String> containerLoggerParameters;
        private String containerLoggingType;
        private final ImageConfiguration.ImageConfigurationBuilder imageConfigBuilder = new ImageConfiguration.ImageConfigurationBuilder();
        private final ContainerNetworkConfiguration.ContainerNetworkConfigurationBuilder networkConfigurationBuilder = new ContainerNetworkConfiguration.ContainerNetworkConfigurationBuilder();
        private List<String> entryPoint = new LinkedList<String>();
        private Boolean containerRestartOnFailure = false;
        private Optional<Long> memory = Optional.empty();
        private Optional<Float> cpus = Optional.empty();
        private Optional<String> gpus = Optional.empty();

        public ContainerConfigurationBuilder setContainerName(String serviceName) {
            this.containerName = serviceName;
            return this;
        }

        public ContainerConfigurationBuilder setFrameworkManaged(Boolean isFrameworkManaged) {
            this.isFrameworkManaged = isFrameworkManaged;
            return this;
        }

        public ContainerConfigurationBuilder setExternalPorts(List<Integer> containerPortsExternal) {
            this.containerPortsExternal = new ArrayList<Integer>(containerPortsExternal);
            return this;
        }

        public ContainerConfigurationBuilder setInternalPorts(List<Integer> containerPortsInternal) {
            this.containerPortsInternal = new ArrayList<Integer>(containerPortsInternal);
            return this;
        }

        public ContainerConfigurationBuilder setEnvVars(List<String> vars) {
            this.containerEnvVars = new LinkedList<String>(vars);
            return this;
        }

        public ContainerConfigurationBuilder setDeviceList(List<String> devices) {
            this.containerDevices = new LinkedList<String>(devices);
            return this;
        }

        public ContainerConfigurationBuilder setVolumes(Map<String, String> volumeMap) {
            this.containerVolumes = new HashMap<String, String>(volumeMap);
            return this;
        }

        public ContainerConfigurationBuilder setLoggerParameters(Map<String, String> paramMap) {
            this.containerLoggerParameters = new HashMap<String, String>(paramMap);
            return this;
        }

        public ContainerConfigurationBuilder setLoggingType(String containerLoggingType) {
            this.containerLoggingType = containerLoggingType;
            return this;
        }

        public ContainerConfigurationBuilder setPrivilegedMode(Boolean containerPrivileged) {
            this.containerPrivileged = containerPrivileged;
            return this;
        }

        public ContainerConfigurationBuilder setContainerImage(String serviceImage) {
            this.imageConfigBuilder.setImageName(serviceImage);
            return this;
        }

        public ContainerConfigurationBuilder setContainerImageTag(String serviceImageTag) {
            this.imageConfigBuilder.setImageTag(serviceImageTag);
            return this;
        }

        public ContainerConfigurationBuilder setRegistryCredentials(Optional<RegistryCredentials> registryCredentials) {
            this.imageConfigBuilder.setRegistryCredentials(registryCredentials);
            return this;
        }

        public ContainerConfigurationBuilder setImageDownloadTimeoutSeconds(int imageDownloadTimeoutSeconds) {
            this.imageConfigBuilder.setImageDownloadTimeoutSeconds(imageDownloadTimeoutSeconds);
            return this;
        }

        public ContainerConfigurationBuilder setEntryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public ContainerConfigurationBuilder setContainerNetowrkConfiguration(ContainerNetworkConfiguration networkConfiguration) {
            this.networkConfigurationBuilder.setNetworkMode(networkConfiguration.getNetworkMode());
            return this;
        }

        public ContainerConfigurationBuilder setImageConfiguration(ImageConfiguration imageConfig) {
            this.imageConfigBuilder.setImageName(imageConfig.getImageName());
            this.imageConfigBuilder.setImageTag(imageConfig.getImageTag());
            this.imageConfigBuilder.setRegistryCredentials(imageConfig.getRegistryCredentials());
            this.imageConfigBuilder.setImageDownloadTimeoutSeconds(imageConfig.getimageDownloadTimeoutSeconds());
            return this;
        }

        public ContainerConfigurationBuilder setRestartOnFailure(boolean containerRestartOnFailure) {
            this.containerRestartOnFailure = containerRestartOnFailure;
            return this;
        }

        public ContainerConfigurationBuilder setMemory(Optional<Long> memory) {
            this.memory = memory;
            return this;
        }

        public ContainerConfigurationBuilder setCpus(Optional<Float> cpus) {
            this.cpus = cpus;
            return this;
        }

        public ContainerConfigurationBuilder setGpus(Optional<String> gpus) {
            this.gpus = gpus;
            return this;
        }

        public ContainerConfiguration build() {
            ContainerConfiguration result = new ContainerConfiguration(null);
            result.containerName = Objects.requireNonNull(this.containerName, "Request Container Name cannot be null");
            result.containerPortsExternal = this.containerPortsExternal;
            result.containerPortsInternal = this.containerPortsInternal;
            result.containerEnvVars = this.containerEnvVars;
            result.containerDevices = this.containerDevices;
            result.containerVolumes = this.containerVolumes;
            result.containerPrivileged = this.containerPrivileged;
            result.isFrameworkManaged = this.isFrameworkManaged;
            result.containerLoggerParameters = this.containerLoggerParameters;
            result.containerLoggingType = this.containerLoggingType;
            result.imageConfig = this.imageConfigBuilder.build();
            result.networkConfiguration = this.networkConfigurationBuilder.build();
            result.entryPoint = Objects.requireNonNull(this.entryPoint, "Container EntryPoint list must not be null");
            result.containerRestartOnFailure = this.containerRestartOnFailure;
            result.memory = this.memory;
            result.cpus = this.cpus;
            result.gpus = this.gpus;
            return result;
        }
    }
}

